#!/bin/bash

PWD=$(dirname $0)
depends=('pciutils-libs' 'ncurses-libs')
depend_files=('pciutils-libs-3.5.1-3.el7.x86_64.rpm' 'ncurses-libs-5.9-14.20130511.el7_4.x86_64.rpm')
pkgs=('nvmemgr')
pkg_files=('nvmemgr-00.10.027-1.el7.centos.x86_64.rpm')

for i in ${!depends[@]}; do
	pkg=${depends[$i]}
	file=${depend_files[$i]}

	(rpm -q $pkg)
	if [ $? -eq 0 ]; then
		echo "Skip $pkg which has been installed"
		continue
	fi

	rpm -ivh ${PWD}/$file
	if [ $? -ne 0 ]; then
		echo
		echo "*** Failed to install $pkg"
		exit 1
	fi
done

rpm -qa|grep pblaze|xargs rpm -e
for i in ${!pkgs[@]}; do
	pkg=${pkgs[$i]}
	file=${pkg_files[$i]}

	rpm -e $pkg
	rpm -ivh ${PWD}/$file
	if [ $? -ne 0 ]; then
		echo
		echo "*** Failed to install $pkg"
		exit 1
	fi
done

echo
echo "*** Installation finished succesfully"
