#!/bin/bash

PWD=$(dirname $0)
depends=()
depend_files=()
pkgs=('nvmemgr')
pkg_files=('nvmemgr-00.10.027-1.el8.x86_64.rpm')

for i in ${!depends[@]}; do
	pkg=${depends[$i]}
	file=${depend_files[$i]}

	(rpm -q $pkg)
	if [ $? -eq 0 ]; then
		echo "Skip $pkg which has been installed"
		continue
	fi

	rpm -ivh ${PWD}/$file
	if [ $? -ne 0 ]; then
		echo
		echo "*** Failed to install $pkg"
		exit 1
	fi
done

rpm -qa|grep pblaze|xargs rpm -e
for i in ${!pkgs[@]}; do
	pkg=${pkgs[$i]}
	file=${pkg_files[$i]}

	rpm -e $pkg
	rpm -ivh ${PWD}/$file
	if [ $? -ne 0 ]; then
		echo
		echo "*** Failed to install $pkg"
		exit 1
	fi
done

echo
echo "*** Installation finished succesfully"
