/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.manage;

import com.huawei.cdrommount.manage.LogStreamManage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SystemConfig {
    FileInputStream inputStream = null;
    Properties prop = null;
    private String filename = null;
    private static SystemConfig config = null;

    public static SystemConfig createSystemConfig() {
        if (null != config) {
            return config;
        }
        config = new SystemConfig();
        return config;
    }

    private SystemConfig() {
        try {
            this.filename = "config/SystemConfig.ini";
            this.inputStream = new FileInputStream(this.filename);
            this.prop = new Properties();
            this.prop.load(this.inputStream);
        }
        catch (IOException ex) {
            LogStreamManage.error(ex);
        }
    }

    public SystemConfig(String cfg) {
        try {
            this.inputStream = new FileInputStream(cfg);
            this.filename = cfg;
            this.prop = new Properties();
            this.prop.load(this.inputStream);
        }
        catch (IOException ex) {
            LogStreamManage.error(ex);
        }
        this.prop.list(System.out);
    }

    public void SaveCfg() {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(this.filename);
            this.prop.store(outputFile, "save config");
        }
        catch (Exception e) {
            LogStreamManage.error(e);
        }
        finally {
            if (null != outputFile) {
                try {
                    outputFile.close();
                }
                catch (IOException ex) {
                    LogStreamManage.error(ex);
                }
            }
        }
    }

    public String getConfigVlaue(String configName) {
        String value = this.prop.getProperty(configName);
        if (null == value) {
            return null;
        }
        return value.trim();
    }
}

