/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import expect4j.Closure;
import expect4j.Expect4j;
import expect4j.ExpectState;
import expect4j.StreamPair;
import expect4j.matches.EofMatch;
import expect4j.matches.Match;
import expect4j.matches.RegExpMatch;
import expect4j.matches.TimeoutMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;

public abstract class ExpectUtils {
    public static final Logger log = Logger.getLogger((class$expect4j$ExpectUtils == null ? (class$expect4j$ExpectUtils = ExpectUtils.class$("expect4j.ExpectUtils")) : class$expect4j$ExpectUtils).getName());
    static /* synthetic */ Class class$expect4j$ExpectUtils;

    public static String Http(String remotehost, String url) throws Exception {
        Socket s = null;
        s = new Socket(remotehost, 80);
        log.fine("Connected to " + s.getInetAddress().toString());
        Expect4j expect = new Expect4j(s);
        expect.send("GET " + url + " HTTP 1.1\r\n");
        expect.send("Host: " + remotehost + "\r\n");
        expect.send("Connection: close\r\n");
        expect.send("User-Agent: Expect4j\r\n");
        expect.send("\r\n");
        log.fine("Sent header info");
        String remaining = null;
        expect.expect(new Match[]{new RegExpMatch("HTTP/1.[01] \\d{3} (.*)\n?\r", new Closure(){

            public void run(ExpectState state) {
                log.fine("HTTP Header");
                String match = state.getMatch();
                String[] parts = match.split(" ");
                state.addVar("httpCode", parts[1]);
                state.exp_continue();
            }
        }), new RegExpMatch("Content-Type: (.*\\/.*)\r\n", new Closure(){

            public void run(ExpectState state) {
                state.addVar("contentType", state.getMatch());
                state.exp_continue();
            }
        }), new EofMatch(new Closure(){

            public void run(ExpectState state) {
                log.fine("Capturing until EOF");
            }
        }), new TimeoutMatch(10000L, new Closure(){

            public void run(ExpectState state) {
                log.fine("Timeout");
            }
        })});
        remaining = expect.getLastState().getBuffer();
        String httpCode = (String)expect.getLastState().getVar("httpCode");
        System.out.println("HTTP Code: " + httpCode);
        String contentType = (String)expect.getLastState().getVar("contentType");
        log.fine("Content Type: " + contentType);
        s.close();
        return remaining;
    }

    public static Expect4j SSH(String hostname, String username, String password) throws Exception {
        return ExpectUtils.SSH(hostname, username, password, 22);
    }

    public static Expect4j SSH(String hostname, String username, String password, int port) throws Exception {
        JSch jsch = new JSch();
        Session session = jsch.getSession(username, hostname, port);
        if (password != null) {
            log.finer("Using password");
            session.setPassword(password);
        }
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setDaemonThread(true);
        session.connect(3000);
        ChannelShell channel = (ChannelShell)session.openChannel("shell");
        channel.setPtyType("vt102");
        Hashtable env = new Hashtable();
        channel.setEnv(env);
        Expect4j expect = new Expect4j(channel.getInputStream(), channel.getOutputStream());
        channel.connect(5000);
        return expect;
    }

    public static Expect4j telnet(String hostname, int port) throws Exception {
        final TelnetClient client = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, true);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(false, false, false, false);
        client.addOptionHandler((TelnetOptionHandler)ttopt);
        client.addOptionHandler((TelnetOptionHandler)echoopt);
        client.addOptionHandler((TelnetOptionHandler)gaopt);
        client.connect(hostname, port);
        FromNetASCIIInputStream is = new FromNetASCIIInputStream(client.getInputStream());
        ToNetASCIIOutputStream os = new ToNetASCIIOutputStream(client.getOutputStream());
        StreamPair pair = new StreamPair((InputStream)is, (OutputStream)os){

            public void close() {
                try {
                    if (client != null) {
                        client.disconnect();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Expect4j expect4j = new Expect4j(pair);
        return expect4j;
    }

    public static Expect4j spawn(String cmdLine) throws Exception {
        String[] cmdArgs = cmdLine.split(" ");
        Process process = Runtime.getRuntime().exec(cmdArgs);
        InputStream is = process.getInputStream();
        OutputStream os = process.getOutputStream();
        StreamPair iopair = new StreamPair(is, os);
        Expect4j expect = new Expect4j(iopair);
        return expect;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

