/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.communication;

import com.huawei.vm.console.communication.Receiver;
import com.huawei.vm.console.utils.ResourceUtil;
import com.huawei.vm.console.utils.TestPrint;
import com.huawei.vm.console.utils.VMException;
import com.kvm.LogManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class CommunicationReceiver
implements Receiver {
    private final Socket socket;
    private final BufferedInputStream in;
    private int overTime = 3000;
    private Logger logger = LogManager.getInstance().getLogger(CommunicationReceiver.class);

    public CommunicationReceiver(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.overTime = Integer.parseInt(ResourceUtil.getConfigItem("com.huawei.vm.console.config.receiver.overtime"));
    }

    public CommunicationReceiver(Socket socket, int overTime) throws IOException {
        this(socket);
        this.overTime = overTime;
    }

    @Override
    public void receive(byte[] packet, int size) throws VMException {
        int curRec = 0;
        int off = 0;
        try {
            this.socket.setSoTimeout(0);
        }
        catch (SocketException e1) {
            this.logger.error(Thread.currentThread().getName() + " : Receiver -- Socket Excpetion on set time out:", e1);
        }
        while (size > 0) {
            try {
                curRec = this.in.read(packet, off, size);
            }
            catch (IOException e) {
                this.logger.error(Thread.currentThread().getName() + " : Receiver", e);
                throw new VMException(102);
            }
            if (curRec < 0) {
                throw new VMException(101);
            }
            this.logger.info("curRec:" + curRec + " off:" + off + " size:" + size);
            off += curRec;
            size -= curRec;
        }
    }

    @Override
    public int receiveImmediate(byte[] packet, int size) throws VMException {
        int curRec = 0;
        int off = 0;
        try {
            this.socket.setSoTimeout(this.overTime);
        }
        catch (SocketException e1) {
            this.logger.error(Thread.currentThread().getName() + " : Receiver -- Socket Excpetion:", e1);
        }
        while (size > 0) {
            try {
                curRec = this.in.read(packet, off, size);
            }
            catch (InterruptedIOException interruptedioexception) {
                this.logger.error("", interruptedioexception);
                break;
            }
            catch (IOException e) {
                this.logger.error(Thread.currentThread().getName() + " : Receiver -- IO Excpetion:", e);
                throw new VMException(102);
            }
            if (curRec < 0) {
                throw new VMException(101);
            }
            this.logger.info("curRec:" + curRec + " off:" + off + " size:" + size);
            off += curRec;
            size -= curRec;
        }
        return off;
    }

    @Override
    public boolean receiveByLimit(byte[] packet, int size, int limitTime) throws VMException {
        this.logger.info("limitTime:" + limitTime);
        int curRec = 0;
        int off = 0;
        try {
            this.socket.setSoTimeout(limitTime);
        }
        catch (SocketException e1) {
            this.logger.error(Thread.currentThread().getName() + " : Receiver -- Socket Excpetion on set time out:" + e1.getMessage(), e1);
        }
        while (size > 0) {
            try {
                curRec = this.in.read(packet, off, size);
            }
            catch (InterruptedIOException interruptedioexception) {
                this.logger.error("", interruptedioexception);
                try {
                    this.socket.setSoTimeout(0);
                }
                catch (SocketException e) {
                    this.logger.error(Thread.currentThread().getName() + " : Receiver -- Socket Excpetion on set time out:", e);
                }
                if (0 != off) continue;
                return false;
            }
            catch (IOException e) {
                this.logger.error(Thread.currentThread().getName() + " : Receiver -- IO Excpetion:", e);
                throw new VMException(102);
            }
            if (curRec < 0) {
                throw new VMException(101);
            }
            this.logger.info("curRec:" + curRec + " off:" + off + " size:" + size);
            off += curRec;
            size -= curRec;
        }
        TestPrint.printArray(2, packet, 0, off, Thread.currentThread().getName() + " : Receiver -- packet");
        return true;
    }

    @Override
    public void setOverTime(int overTime) {
        if (0 < overTime) {
            this.overTime = overTime;
        }
    }
}

