/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.utils;

import com.huawei.vm.console.communication.ProtocolCode;
import com.huawei.vm.console.utils.DataElement;
import com.kvm.LogManager;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class DataArray {
    private final LinkedList linkedList = new LinkedList();
    private final LinkedList bigArrList = new LinkedList();
    private final LinkedList smallArrList = new LinkedList();
    private final int bigArrSize = ProtocolCode.CDROM_PACKET_SIZE + 12 + 20;
    private final int smallArrSize = 12;
    private int capacity = 256;
    private int elementNumber = 0;
    private int totalNum = 0;
    private final Object blockLock = new Object();
    private final Object arrBlockLock = new Object();
    private Logger logger = LogManager.getInstance().getLogger(DataArray.class);

    public DataArray() {
    }

    public DataArray(int capacity) {
        if (capacity > 0) {
            this.capacity = capacity;
        }
    }

    public void initArrList(int bigArrCap, int smallArrCap) {
        for (int i = 0; i < bigArrCap; ++i) {
            this.bigArrList.addLast(new byte[this.bigArrSize]);
        }
        for (int j = 0; j < smallArrCap; ++j) {
            this.smallArrList.addLast(new byte[this.smallArrSize]);
        }
    }

    public DataElement getFirst() {
        DataElement data = null;
        try {
            data = (DataElement)this.linkedList.getFirst();
        }
        catch (NoSuchElementException e) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement getAndRemoveFirst() {
        DataElement data = null;
        try {
            Object object = this.blockLock;
            synchronized (object) {
                data = (DataElement)this.linkedList.removeFirst();
                --this.elementNumber;
            }
        }
        catch (NoSuchElementException e) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement getAndRemoveFirstByBlock() {
        DataElement data = null;
        Object object = this.blockLock;
        synchronized (object) {
            while (true) {
                try {
                    data = (DataElement)this.linkedList.removeFirst();
                    --this.elementNumber;
                }
                catch (NoSuchElementException e) {
                    try {
                        this.blockLock.wait();
                    }
                    catch (InterruptedException e1) {
                        this.logger.error(Thread.currentThread().getName() + "--Thread interrupted!", e1);
                        break;
                    }
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLast(DataElement element) {
        boolean result = false;
        if (this.elementNumber >= this.capacity) {
            result = false;
        } else {
            if (null != element) {
                Object object = this.blockLock;
                synchronized (object) {
                    this.linkedList.addLast(element);
                    ++this.elementNumber;
                    this.blockLock.notifyAll();
                }
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMore(DataElement element) {
        if (null != element) {
            Object object = this.blockLock;
            synchronized (object) {
                this.linkedList.addLast(element);
                ++this.elementNumber;
                this.blockLock.notifyAll();
            }
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getDataNum() {
        return this.linkedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArr(int arrLen) {
        this.logger.info(Thread.currentThread().getName() + "--Get a arr. Total -" + ++this.totalNum);
        byte[] arr = null;
        Object object = this.arrBlockLock;
        synchronized (object) {
            try {
                arr = this.smallArrSize < arrLen ? (byte[])this.bigArrList.removeFirst() : (byte[])this.smallArrList.removeFirst();
            }
            catch (NoSuchElementException e) {
                arr = this.smallArrSize < arrLen ? new byte[this.bigArrSize] : new byte[this.smallArrSize];
            }
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(byte[] arr) {
        if (null != arr) {
            Object object = this.arrBlockLock;
            synchronized (object) {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = 0;
                }
                if (this.smallArrSize == arr.length) {
                    this.smallArrList.addLast(arr);
                } else if (this.bigArrSize == arr.length) {
                    this.bigArrList.addLast(arr);
                }
            }
        }
    }

    public int getBigArrNum() {
        return this.bigArrList.size();
    }

    public int getSmallArrNum() {
        return this.smallArrList.size();
    }
}

