/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.utils;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ResourceUtil {
    private static final ResourceBundle config = ResourceBundle.getBundle("com.huawei.vm.console.vmconfigResource");
    private static Logger logger = LogManager.getLogger(ResourceUtil.class);
    private static final String resultPath = "com.huawei.vm.console.vmResult";
    private static final String resourcePath = "com.huawei.vm.console.vmResource";
    private static final String keyPrefix = "com.huawei.vm.console.error.";
    private ResourceBundle resource = "zh".equals(Locale.getDefault().getLanguage()) ? ResourceBundle.getBundle("com.huawei.vm.console.vmResource") : ResourceBundle.getBundle("com.huawei.vm.console.vmResource", new Locale("en"));
    public static final String CREATE_IMAGE_SAVE_IMAGE = "com.huawei.vm.console.creatImage.saveTitle";
    public static final String ERROR_UNKNOWN_ERROR = "com.huawei.vm.console.error.unknown";
    public static final String CONFIG_VM_VERSION = "com.huawei.vm.console.config.version";
    public static String CONFIG_VM_LIBARY = "";
    public static final String CONFIG_VM_LIB_EXT = "com.huawei.vm.console.config.libExt";
    public static final String CONFIG_VM_LIBARY_PATH = "com.huawei.vm.console.config.library.path";
    public static final String CONFIG_VM_READ_RETRY = "com.huawei.vm.console.config.device.read.retry";
    public static final String CONFIG_VM_RECEIVE_OVERTIME = "com.huawei.vm.console.config.receiver.overtime";
    public static final String CONFIG_VM_BUSINESS_OVERTIME = "com.huawei.vm.console.config.business.overtime";
    public static final String CONFIG_VM_PRINT_LEVEL = "com.huawei.vm.console.config.print.level";
    public static final String CONFIG_VM_MAX_PACKET_SIZE = "com.huawei.vm.console.config.datapacket.size";
    public static final String CONFIG_VM_MAX_CDROM_PACKET_SIZE = "com.huawei.vm.console.config.cdrom.datapacket.size";
    public static final String CONFIG_VM_MAX_FLOPPY_PACKET_SIZE = "com.huawei.vm.console.config.floppy.datapacket.size";
    public static final String CONFIG_VM_HEART_BIT_INTERVAL = "com.huawei.vm.console.config.heartBit.interval";

    public String getCONFIG_VM_LIBARY() {
        return CONFIG_VM_LIBARY;
    }

    public void setCONFIG_VM_LIBARY(String cONFIGVMLIBARY) {
        CONFIG_VM_LIBARY = cONFIGVMLIBARY;
    }

    public void setLanguage(String language) {
        this.resource = "en".equalsIgnoreCase(language) ? ResourceBundle.getBundle(resourcePath, new Locale("en")) : ResourceBundle.getBundle(resourcePath, new Locale("zh"));
    }

    public void dosetLanguage(String language) {
        this.resource = "en".equalsIgnoreCase(language) ? ResourceBundle.getBundle(resultPath, new Locale("en")) : ResourceBundle.getBundle(resultPath, new Locale("zh"));
    }

    public static String getConfigItem(String key) {
        String configResource = null;
        try {
            configResource = config.getString(key);
        }
        catch (MissingResourceException e) {
            logger.error("Resource Util :can not find config info, key:" + key);
            configResource = CONFIG_VM_BUSINESS_OVERTIME.equals(key) ? "20000" : (CONFIG_VM_LIB_EXT.equals(key) ? ".dll" : ("VMConsoleLib".equals(key) ? "VMConsoleLib" : ("VMConsoleLib_x64".equals(key) ? "VMConsoleLib_x64" : (CONFIG_VM_LIBARY_PATH.equals(key) ? "com/huawei/vm/console/" : (CONFIG_VM_READ_RETRY.equals(key) ? "10" : (CONFIG_VM_RECEIVE_OVERTIME.equals(key) ? "3000" : (CONFIG_VM_VERSION.equals(key) ? "2.20.5.52" : (CONFIG_VM_PRINT_LEVEL.equals(key) ? "100" : (CONFIG_VM_MAX_PACKET_SIZE.equals(key) ? "1024" : (CONFIG_VM_HEART_BIT_INTERVAL.equals(key) ? "10000" : "0"))))))))));
        }
        return configResource;
    }

    public String getResource(String key) {
        String configResource = null;
        try {
            configResource = this.resource.getString(key);
        }
        catch (MissingResourceException e) {
            logger.error("Resource Util :can not find resource info, key:" + key);
            configResource = CREATE_IMAGE_SAVE_IMAGE.equals(key) ? "Save Image File" : "Virtual Media";
        }
        return configResource;
    }

    public String getErrMessage(int errCode) {
        try {
            return this.resource.getString(keyPrefix + errCode);
        }
        catch (MissingResourceException me) {
            return this.resource.getString(ERROR_UNKNOWN_ERROR);
        }
    }
}

