/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.virtualconnection.impl;

import com.huawei.vm.console.management.ConsoleControllers;
import com.huawei.vm.console.utils.VMException;
import com.huawei.vm.virtualconnection.VirtualConnect;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.SabreUDFImageBuilder;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFRevision;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.handler.SerializationHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class VirtualConnectISO
extends VirtualConnect {
    private static final int CDROM = 2;
    private static final int PORT_VALID_START = 1;
    private static final int PORT_VALID_END = 65535;
    private static final int ERR_VIRCONN_OK = 0;
    private static final int ERR_VIRCONN_CONN_ALREADY_EXIST = 501;
    private static final int ERR_VIRCONN_PARA_TYPE_ERROR = 502;
    private static final int ERR_VIRCONN_PARA_IP_ERROR = 503;
    private static final int ERR_VIRCONN_PARA_PORT_ERROR = 504;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_NULL = 505;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_INVALID = 506;
    private static final int ERR_VIRCONN_CONN_NOT_EXIST = 507;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_NOT_ACTIVE = 508;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_STILL_IDLE = 509;
    private static final int ERR_VIRCONN_LOCAL_DIR_BLANK = 510;
    private static final int ERR_FILE_NUMBER_OVER = 511;
    private static final int MAX_FILE_COUNT = 20000;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private ConsoleControllers vmApplet = null;
    private javax.swing.Timer cdRomVMlink = null;
    private boolean vmmconnected = false;
    private static Logger logger = LogManager.getLogger(VirtualConnectISO.class);

    public VirtualConnectISO() {
        this.vmApplet = new ConsoleControllers();
        this.vmApplet.setLanguage("en");
    }

    public VirtualConnectISO(String threadName) {
        this.vmApplet = new ConsoleControllers(threadName);
        this.vmApplet.setLanguage("en");
    }

    @Override
    public int connect(int type, String serverIp, int serverPort, long verifyId, String imagePath) {
        if (this.vmmconnected) {
            return 501;
        }
        if (2 != type) {
            return 502;
        }
        if (0 != this.validateIP(serverIp)) {
            return 503;
        }
        if (serverPort < 1 || serverPort > 65535) {
            return 504;
        }
        int chkPathResult = this.checkISOImagePath(imagePath);
        if (0 != chkPathResult) {
            return chkPathResult;
        }
        File imageFile = new File(imagePath);
        if (imageFile.isDirectory()) {
            File[] subFile = imageFile.listFiles();
            if (subFile == null || subFile.length == 0) {
                return 510;
            }
            try {
                Map<Long, UDFExtendFile> memoryStruct = this.writeImageByDir(imagePath);
                if (null == memoryStruct) {
                    return -1;
                }
                return this.createVMLink(2, serverIp, serverPort, verifyId, imagePath, imageFile.getName(), memoryStruct, 2);
            }
            catch (VMException e) {
                e.printStackTrace();
                return 511;
            }
        }
        return this.createVMLink(2, serverIp, serverPort, verifyId, imagePath);
    }

    @Override
    public int disconnect() {
        if (!this.vmmconnected) {
            System.out.println("[vmm] vmm connection not exists.");
            return 507;
        }
        this.disconnectVMLink(2);
        return 0;
    }

    @Override
    public String getErrMsg(int errCode) {
        return this.vmApplet.getStatement(errCode);
    }

    private int validateIP(String ip) {
        Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
        Matcher matcher = pattern.matcher(ip);
        if (matcher.matches()) {
            return 0;
        }
        return 503;
    }

    private int checkISOImagePath(String imagePath) {
        if (null == imagePath || "".equals(imagePath)) {
            return 505;
        }
        return 0;
    }

    private int createVMLink(int deviceType, String serverIP, int serverPort, long certifyID, String imagePath) {
        byte[] codeKey = new byte[]{(byte)(certifyID >> 24 & 0xFFL), (byte)(certifyID >> 16 & 0xFFL), (byte)(certifyID >> 8 & 0xFFL), (byte)(certifyID & 0xFFL)};
        this.vmApplet.creatVMLink(deviceType, imagePath, serverIP, serverPort, codeKey, null, false, false, false, null, null, null, 1);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.checkCdromVMConsole();
    }

    private int createVMLink(int deviceType, String serverIP, int serverPort, long certifyID, String imagePath, String localDirName, Map<Long, UDFExtendFile> memoryStruct, int srcType) {
        byte[] codeKey = new byte[]{(byte)(certifyID >> 24 & 0xFFL), (byte)(certifyID >> 16 & 0xFFL), (byte)(certifyID >> 8 & 0xFFL), (byte)(certifyID & 0xFFL)};
        this.vmApplet.creatVMLink(deviceType, imagePath, serverIP, serverPort, codeKey, null, false, false, false, localDirName, memoryStruct, null, srcType);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.checkCdromVMConsole();
    }

    private void disconnectVMLink(int deviceType) {
        if (deviceType == 2) {
            this.vmApplet.destroyVMLink(deviceType);
            Timer t = new Timer("cdrom disconnectVMLink");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    VirtualConnectISO.this.vmmconnected = false;
                }
            };
            t.schedule(task, 2000L);
        }
    }

    private int checkCdromVMConsole() {
        int state_code = 0;
        if (!this.vmApplet.isConsoleOK(2)) {
            if (this.vmApplet.isVMLinkCrt(2)) {
                Timer date = new Timer("cdrom checkVMConsole");
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (null == VirtualConnectISO.this.cdRomVMlink) {
                            VirtualConnectISO.this.cdRomVMlink = new javax.swing.Timer(1000, VirtualConnectISO.this.doCdRomVMlink());
                        }
                        VirtualConnectISO.this.cdRomVMlink.start();
                    }
                };
                date.schedule(task, 800L);
                this.vmmconnected = true;
                state_code = 0;
            } else {
                this.vmmconnected = false;
                this.vmApplet.destroyVMLink(2);
                state_code = this.vmApplet.getConsoleState(2);
                if (0 == state_code) {
                    state_code = 508;
                    System.out.println("[vmm] Create vmm failed,console leaves idle state but still not active.");
                }
            }
        } else {
            this.vmmconnected = false;
            state_code = this.vmApplet.getConsoleState(2);
            if (0 == state_code) {
                state_code = 509;
                System.out.println("[vmm] Create vmm failed,console initialization failed,still in idle state.");
            }
        }
        return state_code;
    }

    private Action doCdRomVMlink() {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VirtualConnectISO.this.vmApplet.isVMLinkCrt(2)) {
                    VirtualConnectISO.this.cdRomVMlink.stop();
                    VirtualConnectISO.this.cdRomVMlink = null;
                    VirtualConnectISO.this.disconnectVMLink(2);
                }
            }
        };
        return action;
    }

    @Override
    public int connect(int type, String serverIp, int serverPort, byte[] certifyID, byte[] salt, boolean bCodeKeyNego, boolean bSecret, String imagePath) {
        try {
            if (this.vmmconnected) {
                return 501;
            }
            if (2 != type) {
                return 502;
            }
            if (0 != this.validateIP(serverIp)) {
                return 503;
            }
            if (serverPort < 1 || serverPort > 65535) {
                return 504;
            }
            int chkPathResult = this.checkISOImagePath(imagePath);
            if (0 != chkPathResult) {
                return chkPathResult;
            }
            File imageFile = new File(imagePath);
            if (imageFile.isDirectory()) {
                File[] subFile = imageFile.listFiles();
                if (subFile == null || subFile.length == 0) {
                    return 510;
                }
                try {
                    Map<Long, UDFExtendFile> memoryStruct = this.writeImageByDir(imagePath);
                    if (null == memoryStruct) {
                        return -1;
                    }
                    this.vmApplet.creatVMLink(2, imagePath, serverIp, serverPort, certifyID, salt, bCodeKeyNego, bSecret, false, imageFile.getName(), memoryStruct, null, 2);
                }
                catch (VMException e) {
                    e.printStackTrace();
                    return 511;
                }
            } else {
                this.vmApplet.creatVMLink(2, imagePath, serverIp, serverPort, certifyID, salt, bCodeKeyNego, bSecret, false, null, null, null, 1);
            }
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.checkCdromVMConsole();
        }
        catch (Exception e) {
            logger.error("", e);
            return -1;
        }
    }

    private Map<Long, UDFExtendFile> writeImageByDir(String cdLocalDir) throws VMException {
        Map<Long, UDFExtendFile> memoryStruct = null;
        try {
            File dirFile = new File(cdLocalDir);
            SabreUDFImageBuilder mySabreUDF = new SabreUDFImageBuilder();
            this.getDir(dirFile);
            File[] childFiles = dirFile.listFiles();
            for (int i = 0; i < childFiles.length; ++i) {
                mySabreUDF.addFileToRootDirectory(childFiles[i]);
            }
            if (dirFile.getName().length() >= 30) {
                mySabreUDF.setImageIdentifier(dirFile.getName().substring(0, 28) + "~");
            } else {
                mySabreUDF.setImageIdentifier(dirFile.getName());
            }
            mySabreUDF.writeImage("cdLocalDir\\cdLocalDir.iso", UDFRevision.Revision102);
            memoryStruct = ((SerializationHandler)mySabreUDF.getSerializationHandler()).getExtendMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memoryStruct;
    }

    private long getDir(File f) throws VMException {
        long size = 0L;
        File[] flist = f.listFiles();
        if (flist != null && flist.length != 0) {
            size = flist.length;
            for (int i = 0; i < flist.length; ++i) {
                if (flist[i].isDirectory()) {
                    size += this.getDir(flist[i]);
                }
                if (size <= 20000L) continue;
                throw new VMException(338);
            }
        }
        return size;
    }
}

