/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.CombinationKey;
import com.kvm.ImagePane;
import com.kvm.LogManager;
import com.kvm.PackData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

class CombineKeyListener
implements ActionListener {
    private final int bladeNO;
    private final PackData pack;
    private CombinationKey combinationKey;
    private static Logger logger = LogManager.getInstance().getLogger(CombineKeyListener.class);

    CombineKeyListener(CombinationKey combinationKey) {
        this.bladeNO = combinationKey.bladeNO;
        this.pack = combinationKey.pack;
        this.combinationKey = combinationKey;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.combinationKey.b1.getActionCommand())) {
            logger.info("Ctrl+Shift");
            byte[] combinKeyReq = this.pack.combinKeyCS(this.bladeNO);
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            combinKeyReq = this.pack.resetKey(this.bladeNO);
            this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.b2.getActionCommand())) {
            logger.info("Ctrl+Esc");
            byte[] combinKeyReq = this.pack.combinKeyCE(this.bladeNO);
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            combinKeyReq = this.pack.resetKey(this.bladeNO);
            this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.b3.getActionCommand())) {
            logger.info("Ctrl+Alt+Del");
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.combinKeyCtrlAltDel(this.bladeNO));
                Thread.sleep(50L);
                this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.combinKeyCtrlAlt(this.bladeNO));
                Thread.sleep(50L);
                this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.combinKeyCtrlAltDel(this.bladeNO));
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.resetKey(this.bladeNO));
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.b4.getActionCommand())) {
            logger.info("Alt+Tab");
            byte[] combinKeyReq = this.pack.combinKeyAT(this.bladeNO);
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            combinKeyReq = this.pack.resetKey(this.bladeNO);
            this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.b5.getActionCommand())) {
            logger.info("Ctrl+Space");
            byte[] combinKeyReq = this.pack.combinKeyCSP(this.bladeNO);
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            combinKeyReq = this.pack.resetKey(this.bladeNO);
            this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.b6.getActionCommand())) {
            logger.info("ResetKeyBoard");
            byte[] combinKeyReq = this.pack.clearKey(this.bladeNO);
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
                Thread.sleep(100L);
                this.combinationKey.bladeThread.bladeCommu.sentData(combinKeyReq);
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
        if (e.getActionCommand().equals(this.combinationKey.send.getActionCommand())) {
            try {
                this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.combinKeyCustom(this.bladeNO, this.combinationKey));
                this.resetVirtualKey();
                Thread.sleep(100L);
                this.combinationKey.bladeThread.bladeCommu.sentData(this.pack.resetKey(this.bladeNO));
            }
            catch (InterruptedException e1) {
                logger.error("", e1);
            }
            this.combinationKey.dispose();
            this.combinationKey = null;
            return;
        }
    }

    private void resetVirtualKey() {
        this.pack.meta = 0;
        this.pack.alt = 0;
        this.pack.shift = 0;
        this.pack.ctrl = 0;
    }

    public void remove() {
        this.combinationKey.b1.removeActionListener(this);
        this.combinationKey.b2.removeActionListener(this);
        this.combinationKey.b3.removeActionListener(this);
        this.combinationKey.b4.removeActionListener(this);
        this.combinationKey.b5.removeActionListener(this);
        this.combinationKey.b6.removeActionListener(this);
        this.combinationKey.send.removeActionListener(this);
        this.combinationKey.bPanel1.removeAll();
        this.combinationKey.bPanel2.removeAll();
        this.combinationKey.bPanel.removeAll();
        this.combinationKey.tPanel.removeAll();
        this.combinationKey.removeAll();
        if (!this.combinationKey.kvmInterface.isFullScreen) {
            this.combinationKey.kvmInterface.kvmUtil.getImagePane(this.bladeNO).requestFocus();
        } else {
            ImagePane imagePane = this.combinationKey.kvmInterface.kvmUtil.getImagePane(this.bladeNO);
            if (imagePane.isNew()) {
                if (this.combinationKey.kvmInterface.base.isMstsc) {
                    this.combinationKey.kvmInterface.fullScreen.setCursor(this.combinationKey.kvmInterface.base.defCursor);
                    imagePane.setCursor(this.combinationKey.kvmInterface.base.defCursor);
                } else {
                    this.combinationKey.kvmInterface.fullScreen.setCursor(this.combinationKey.kvmInterface.base.myCursor);
                    imagePane.setCursor(this.combinationKey.kvmInterface.base.myCursor);
                }
            }
        }
    }

    public void removeAll() {
        this.combinationKey.b1.removeActionListener(this);
        this.combinationKey.b2.removeActionListener(this);
        this.combinationKey.b3.removeActionListener(this);
        this.combinationKey.b4.removeActionListener(this);
        this.combinationKey.b5.removeActionListener(this);
        this.combinationKey.b6.removeActionListener(this);
        this.combinationKey.send.removeActionListener(this);
        this.combinationKey.bPanel1.removeAll();
        this.combinationKey.bPanel2.removeAll();
        this.combinationKey.bPanel.removeAll();
        this.combinationKey.tPanel.removeAll();
        this.combinationKey.removeAll();
    }
}

