/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount;

import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.manage.LogStreamManage;
import com.huawei.cdrommount.manage.MountThread;
import com.huawei.cdrommount.manage.ParameterCheckManage;
import com.huawei.cdrommount.model.ConnectModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class CDROMMount {
    private HWDiscoverModel snmpModel = null;
    private LinkedHashMap<String, ConnectModel> connModels;
    private LinkedHashMap<String, MountThread> threads;
    Iterator<String> iterator;
    private LinkedHashMap<Integer, String> mountErrMsg;
    private LinkedHashMap<Integer, String> uMountErrMsg;

    public CDROMMount(String ip, String path, String user, String pwd, String vmmPort, String ipmiPort) {
        LogStreamManage.openStream();
        String[] args = new String[]{ip, path, user, pwd, vmmPort, ipmiPort};
        this.mountErrMsg = new LinkedHashMap();
        this.uMountErrMsg = new LinkedHashMap();
        ParameterCheckManage checkManage = new ParameterCheckManage();
        this.connModels = checkManage.check(args);
        if (this.connModels == null || this.connModels.isEmpty()) {
            LogStreamManage.log("Check parameter failed.");
            this.mountErrMsg.put(0, "601");
            return;
        }
        try {
            this.snmpModel = new HWDiscoverModel();
            this.snmpModel.setIPAddress(ip);
            this.snmpModel.setUserName(user);
            this.snmpModel.setUserPassword(pwd);
            this.snmpModel.setIPMIPort(ipmiPort);
        }
        catch (UMateException ex) {
            LogStreamManage.log("Init snmp model failed.msg:" + ex);
        }
    }

    public CDROMMount(String ip, String path, String user, String pwd, String authProtocol, String privacyProtocol, String slot, String port, String ver) {
        LogStreamManage.openStream();
        String[] args = new String[]{ip, path, user, pwd, authProtocol, privacyProtocol, slot, port, ver};
        ParameterCheckManage checkManage = new ParameterCheckManage();
        this.mountErrMsg = new LinkedHashMap();
        this.uMountErrMsg = new LinkedHashMap();
        this.connModels = checkManage.check(args);
        if (this.connModels == null || this.connModels.isEmpty()) {
            LogStreamManage.log("Check parameter failed.");
            this.mountErrMsg.put(0, "601");
            return;
        }
        try {
            this.snmpModel = new HWDiscoverModel();
            this.snmpModel.setIPAddress(ip);
            this.snmpModel.setUserName(user);
            this.snmpModel.setUserPassword(pwd);
            this.snmpModel.setAuthenticationProtocol(authProtocol);
            this.snmpModel.setPrivacyProtocol(privacyProtocol);
            this.snmpModel.setSNMPPort(port);
            this.snmpModel.setVersion(ver);
        }
        catch (UMateException ex) {
            LogStreamManage.log("Init snmp model failed.msg:" + ex);
        }
    }

    public CDROMMount(String ip, String path, String user, String pwd, String vmmPort, String ipmiPort, String type) {
        LogStreamManage.openStream();
        String[] args = new String[]{ip, path, user, pwd, vmmPort, ipmiPort, type};
        this.mountErrMsg = new LinkedHashMap();
        this.uMountErrMsg = new LinkedHashMap();
        ParameterCheckManage checkManage = new ParameterCheckManage();
        this.connModels = checkManage.check(args);
        if (this.connModels == null || this.connModels.isEmpty()) {
            LogStreamManage.log("Check parameter failed.");
            this.mountErrMsg.put(0, "601");
            return;
        }
        try {
            this.snmpModel = new HWDiscoverModel();
            this.snmpModel.setIPAddress(ip);
            this.snmpModel.setUserName(user);
            this.snmpModel.setUserPassword(pwd);
            this.snmpModel.setIPMIPort(ipmiPort);
        }
        catch (UMateException ex) {
            LogStreamManage.log("Init snmp model failed.msg:" + ex);
        }
    }

    public CDROMMount(String ip, String path, String user, String pwd, String authProtocol, String privacyProtocol, String slot, String port, String ver, String type) {
        LogStreamManage.openStream();
        String[] args = new String[]{ip, path, user, pwd, authProtocol, privacyProtocol, slot, port, ver, type};
        ParameterCheckManage checkManage = new ParameterCheckManage();
        this.mountErrMsg = new LinkedHashMap();
        this.uMountErrMsg = new LinkedHashMap();
        this.connModels = checkManage.check(args);
        if (this.connModels == null || this.connModels.isEmpty()) {
            LogStreamManage.log("Check parameter failed.");
            this.mountErrMsg.put(0, "601");
            return;
        }
        try {
            this.snmpModel = new HWDiscoverModel();
            this.snmpModel.setIPAddress(ip);
            this.snmpModel.setUserName(user);
            this.snmpModel.setUserPassword(pwd);
            this.snmpModel.setAuthenticationProtocol(authProtocol);
            this.snmpModel.setPrivacyProtocol(privacyProtocol);
            this.snmpModel.setSNMPPort(port);
            this.snmpModel.setVersion(ver);
        }
        catch (UMateException ex) {
            LogStreamManage.log("Init snmp model failed.msg:" + ex);
        }
    }

    public boolean mount() throws InterruptedException {
        boolean ret = true;
        LogStreamManage.log("Connecting KVM CD-ROM begin.\n");
        this.threads = new LinkedHashMap();
        this.iterator = this.connModels.keySet().iterator();
        while (this.iterator.hasNext()) {
            ConnectModel get = this.connModels.get(this.iterator.next());
            MountThread thread = new MountThread(get, this.snmpModel);
            thread.start();
            this.threads.put(Integer.toString(get.getBladeNO()), thread);
        }
        for (String next : this.threads.keySet()) {
            while (!this.threads.get((Object)next).isComplete) {
                Thread.sleep(1000L);
            }
            if (this.threads.get((Object)next).mountRet) continue;
            this.mountErrMsg.put(this.threads.get(next).getBladeNo(), this.threads.get(next).getMountErrMsg());
            ret = false;
        }
        return ret;
    }

    public boolean uMount() {
        boolean ret = true;
        for (String next : this.threads.keySet()) {
            this.threads.get((Object)next).isStop = true;
            try {
                this.threads.get(next).join();
                if (this.threads.get((Object)next).umountRet) continue;
                this.uMountErrMsg.put(this.threads.get(next).getBladeNo(), this.threads.get(next).getUmountErrMsg());
                ret = false;
            }
            catch (Exception ex) {
                ret = false;
                LogStreamManage.error(ex);
            }
        }
        LogStreamManage.log("Connecting KVM CD-ROM end.\n");
        LogStreamManage.closeStream();
        return ret;
    }

    public LinkedHashMap<Integer, String> getMountErrMsg() {
        return this.mountErrMsg;
    }

    public LinkedHashMap<Integer, String> getUmountErrMsg() {
        return this.uMountErrMsg;
    }

    public static void main(String[] args) throws IOException {
        CDROMMount mm = new CDROMMount("192.168.2.77", "\\\\tsclient\\E\\iWork\\ServiceCD2.0-V112\\FusionServer Tools-ServiceCD2.0-V112.iso", "root", "Huawei12#$", "8208", "623");
        try {
            boolean ret = mm.mount();
            LogStreamManage.log(ret + "Connect KVM CD-ROM over.\n");
        }
        catch (InterruptedException ex) {
            LogStreamManage.log("Connect KVM CD-ROM failed.\n");
        }
        catch (Exception ex1) {
            LogStreamManage.log(ex1.toString());
        }
    }
}

