/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount;

import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.ipmitool.IPMITool;
import com.huawei.cdrommount.manage.LogStreamManage;

public class GetVmmFlagByIPMI {
    public HWDiscoverModel snmpModel = null;

    public GetVmmFlagByIPMI(HWDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    public int getVmmFlag() throws Exception {
        this.snmpModel.setIPMIParameter("raw 0x30 0x94 0xdb 0x07 0x00 0x20 0x03 0x00 0x01");
        IPMITool ipmi = new IPMITool();
        String execResult = ipmi.GetExecResult(this.snmpModel);
        if (!ipmi.successFlag) {
            this.snmpModel.setMsg(execResult);
            LogStreamManage.log(this.snmpModel.getIPAddress() + ":get vmm flag failed,message:" + execResult + "\n");
            return 3;
        }
        LogStreamManage.log(this.snmpModel.getIPAddress() + ":get vmm flag success.\n");
        if (execResult.contains("db 07 00 00 01")) {
            LogStreamManage.log(this.snmpModel.getIPAddress() + ":vmm flag is encryption.\n");
            return 2;
        }
        if (execResult.contains("db 07 00 00 00")) {
            LogStreamManage.log(this.snmpModel.getIPAddress() + ":vmm flag is not encryption.\n");
            return 1;
        }
        return 3;
    }

    public static String getKvmOrVmmPort(HWDiscoverModel mod) throws Exception {
        String result = null;
        result = GetVmmFlagByIPMI.getV3KvmOrVmmPort(mod, "VMM");
        return GetVmmFlagByIPMI.verifyPortResult("VMM", result);
    }

    private static String getV3KvmOrVmmPort(HWDiscoverModel mod, String type) throws Exception {
        String result = null;
        StringBuffer ipmicmd = new StringBuffer();
        ipmicmd.append("raw 0x30 0x93 0xdb 0x07 0x00 0x38");
        if ("KVM".equals(type)) {
            ipmicmd.append(" 0x0a");
        } else if ("VMM".equals(type)) {
            ipmicmd.append(" 0x0b");
        }
        IPMITool ipmi = new IPMITool();
        String execResult = ipmi.GetExecResult(mod);
        if (null != execResult && execResult.contains("db 07 00 00")) {
            String[] array = execResult.trim().split(" ");
            if (array.length >= 9) {
                String flag = array[9] + array[8];
                result = Integer.valueOf(flag, 16).toString();
            }
        } else {
            result = null;
        }
        return result;
    }

    private static String getV2KvmOrVmmPort(HWDiscoverModel mod, String type) throws Exception {
        String result = null;
        StringBuffer ipmicmd = new StringBuffer();
        ipmicmd.append("raw 0x30 0x93 0xdb 0x07 0x00 0x10 0x04 0x02");
        if ("KVM".equals(type)) {
            ipmicmd.append(" 0x01");
        } else if ("VMM".equals(type)) {
            ipmicmd.append(" 0x02");
        }
        IPMITool ipmi = new IPMITool();
        String execResult = ipmi.GetExecResult(mod);
        LogStreamManage.log(execResult + "\n");
        if (null != execResult && execResult.contains("db 07 00 00")) {
            LogStreamManage.log("test\n");
            String[] array = execResult.trim().split(" ");
            if (array.length >= 7) {
                String flag = array[6] + array[5];
                result = Integer.valueOf(flag, 16).toString();
            }
        } else {
            result = null;
        }
        return result;
    }

    private static String verifyPortResult(String type, String port) {
        if (port == null && "KVM".equals(type)) {
            port = "2198";
        } else if (port == null && "VMM".equals(type)) {
            port = "8208";
        }
        return port;
    }
}

