/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount;

import com.huawei.cdrommount.HWDiscover.manage.SNMPCommandBase;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import com.huawei.cdrommount.manage.LogStreamManage;

public class GetVmmFlagBySNMP
extends SNMPCommandBase {
    private String bladeNo;

    public GetVmmFlagBySNMP(HWDiscoverModel snmpModel) {
        super(snmpModel);
    }

    public void setBladeNo(String number) {
        this.bladeNo = number;
    }

    @Override
    public boolean execSNMPCommand() throws Exception {
        switch (this.snmpModel.getProductType()) {
            case Common: 
            case E6000: 
            case E9000: {
                return this.getVmmFlag();
            }
        }
        return true;
    }

    private boolean getVmmFlag() throws Exception {
        this.snmpBase = SNMPBase.SNMPCreate(this.snmpModel, this.snmpBase);
        String flag = null;
        for (int i = 0; i < 5; ++i) {
            flag = this.getOIDValue("1.3.6.1.4.1.2011.2.82.1.82.4." + this.bladeNo + ".2010.1.3.0");
            LogStreamManage.log("1.3.6.1.4.1.2011.2.82.1.82.4." + this.bladeNo + ".2010.1.3.0\n");
            if (!flag.contains("Null")) break;
            LogStreamManage.log("Get vmm flag by SNMP return Null,times:" + i + ".\n");
            Thread.sleep(8000L);
        }
        if (null == flag) {
            this.snmpModel.setMsg("Get vmm flag by SNMP error.");
            LogStreamManage.log(this.snmpModel.getIPAddress() + " get vmm flag by SNMP error.\n");
            return false;
        }
        if (flag.contains("Null")) {
            throw new Exception("Get vmm flag by SNMP return Null");
        }
        LogStreamManage.log(this.snmpModel.getIPAddress() + " get vmm flag by SNMP success,flag:" + flag + ".\n");
        return flag.equals("2");
    }
}

