/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover;

import com.huawei.cdrommount.HWDiscover.HWDiscoverThread;
import com.huawei.cdrommount.HWDiscover.common.HWDiscoverEnum;
import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverResultModel;
import com.huawei.cdrommount.common.SystemConfig;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.display.ProgressBarManage;
import com.huawei.cdrommount.common.file.FileOperation;
import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HWDiscoverBase {
    private static Logger logger = new Logger(HWDiscoverBase.class);
    public ProgressBarManage pgManage = null;
    public static String logType = "Discover";
    public Map<String, Future> serversThread = null;
    public static Map<String, Object> servers = null;
    public static String date = "";
    public static String logSavePath = "";
    public boolean showPrintMsg = false;

    public void statisticServerState(Map<String, Future> serversThread, Map<String, Object> servers, HWDiscoverResultModel resultModel) {
        Object[] keyArray;
        Set<String> keySet = serversThread.keySet();
        for (Object IPAddress : keyArray = keySet.toArray()) {
            HWDiscoverModel get = (HWDiscoverModel)servers.get(IPAddress);
            if (!get.isIsRun() || !serversThread.get(IPAddress).isDone()) continue;
            if (UMateException.SameNameDiffOtherInfo.equals(get.getMsg())) {
                serversThread.remove(IPAddress);
                continue;
            }
            this.addUpResultAndPrint(get, resultModel);
            serversThread.remove(IPAddress);
            this.pgManage.addCompetedNumber(1);
        }
    }

    public Thread createThread(HWDiscoverModel model) {
        return new HWDiscoverThread(model);
    }

    private HWDiscoverResultModel threadRun(String inputXml, String outputXml, Class modelClass) throws Exception {
        File file;
        HWDiscoverResultModel resultModel = new HWDiscoverResultModel();
        logSavePath = MessageDescription.getLogSavePath(logType);
        if (outputXml != null && !"".equals(outputXml) && outputXml.startsWith(MessageDescription.getLogSavePath(logType)) && (file = new File(outputXml).getParentFile()) != null) {
            logSavePath = file.getPath() + "/";
        }
        servers = this.getConfigServers(inputXml, modelClass);
        resultModel.setLogSavePath(logSavePath + date + "/");
        this.pgManage = new ProgressBarManage(servers.size());
        this.pgManage.start();
        boolean notFinish = true;
        boolean isFirstRun = true;
        ExecutorService threadPool = null;
        this.serversThread = new LinkedHashMap<String, Future>();
        resultModel.setTotalServersCount(servers.size());
        System.out.print(HWDiscoverModel.getHeadPrint());
        try {
            int poolThreads = Integer.parseInt(SystemConfig.createSystemConfig().getConfigVlaue(HWDiscoverEnum.DiscoverEnum.thread_count.name()));
            while (notFinish) {
                threadPool = Executors.newFixedThreadPool(poolThreads);
                SNMPBase.SNMPInit();
                notFinish = false;
                Iterator<String> iterator = servers.keySet().iterator();
                while (iterator.hasNext()) {
                    HWDiscoverModel get = (HWDiscoverModel)servers.get(iterator.next());
                    if (!isFirstRun && !UMateException.SameNameDiffOtherInfo.equals(get.getMsg())) continue;
                    notFinish = true;
                    get.setMsg("");
                    Thread discoverThread = this.createThread(get);
                    Future<?> submit = threadPool.submit(discoverThread);
                    this.serversThread.put(get.getIPAddress(), submit);
                }
                threadPool.shutdown();
                Thread.sleep(50L);
                while (!threadPool.isTerminated()) {
                    this.statisticServerState(this.serversThread, servers, resultModel);
                    Thread.sleep(50L);
                }
                this.statisticServerState(this.serversThread, servers, resultModel);
                isFirstRun = false;
            }
        }
        catch (Exception exp) {
            System.out.println("Task run error." + exp.getMessage());
            if (exp.getMessage().equals(MessageDescription.SleepInterrupted)) {
                resultModel.setErrorMsg(MessageDescription.TaskAbandoned);
            } else {
                resultModel.setErrorMsg(exp.getMessage());
            }
            logger.error(exp);
        }
        return resultModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manage(String inputXml, String outputXml, Class modelClass) {
        StringBuilder buffer = new StringBuilder(MessageDescription.xmlHeader);
        HWDiscoverResultModel resultModel = null;
        try {
            resultModel = this.threadRun(inputXml, outputXml, modelClass);
            this.printResult(resultModel);
            LinkedHashMap<String, Object> hwOrderServers = this.getObjectOrder(servers);
            Iterator iterator = hwOrderServers.keySet().iterator();
            while (iterator.hasNext()) {
                HWDiscoverModel get = (HWDiscoverModel)hwOrderServers.get(iterator.next());
                if (!get.isIsRun() || UMateException.SameNameDiffOtherInfo.equals(get.getMsg())) {
                    get.setMsg(MessageDescription.TaskAbandoned);
                } else if (this.serversThread.containsKey(get.getIPAddress()) && !this.serversThread.get(get.getIPAddress()).isDone()) {
                    get.setMsg(MessageDescription.TaskAbandoned);
                    this.serversThread.get(get.getIPAddress()).cancel(true);
                    get.setInterrupt(true);
                }
                if ("".equals(get.getMsg())) {
                    logger.info(String.format("%s pass.", get.getIPAddress()));
                } else {
                    logger.info(String.format("%s %s", get.getIPAddress(), get.getMsg()));
                }
                buffer.append(this.getXmlString(get));
            }
        }
        catch (Exception ex) {
            System.out.println("Task run error." + ex.getMessage());
            if (null != resultModel) {
                resultModel.setErrorMsg(ex.getMessage());
            }
            logger.error(ex);
        }
        finally {
            if (this.pgManage != null && this.pgManage.isAlive()) {
                this.pgManage.interrupt();
            }
        }
        if (resultModel == null) {
            return;
        }
        if ("".equals(resultModel.getLogSavePath())) {
            resultModel.setLogSavePath(logSavePath + date + "/");
        }
        buffer.append(this.getResultModelXmlString(resultModel));
        buffer.append(MessageDescription.xmlFooter);
        try {
            if (null != outputXml && !"".equals(outputXml.trim())) {
                FileOperation.writeFile(outputXml, buffer.toString());
            }
            outputXml = resultModel.getLogSavePath() + "output.xml";
            FileOperation.writeFile(outputXml, buffer.toString());
        }
        catch (Exception ex) {
            System.out.println("Export result to xml error." + ex.getMessage());
            logger.error(ex);
        }
        System.gc();
    }

    public void addUpResultAndPrint(HWDiscoverModel model, HWDiscoverResultModel resultModel) {
        if (model.isIsFind()) {
            resultModel.addOKServersCount();
        } else {
            resultModel.addMajorServersCount();
        }
        System.out.print(model.toFindString());
    }

    public LinkedHashMap<String, Object> getObjectOrder(Map<String, Object> map) {
        ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                HWDiscoverModel m1 = (HWDiscoverModel)o1.getValue();
                HWDiscoverModel m2 = (HWDiscoverModel)o2.getValue();
                if (m1.isIsFind() && m2.isIsFind() || !m1.isIsFind() && !m2.isIsFind()) {
                    String[] IP2;
                    String[] IP1 = m1.getIPAddress().split("\\.");
                    if (!IP1[0].equals((IP2 = m2.getIPAddress().split("\\."))[0])) {
                        return Integer.parseInt(IP1[0]) - Integer.parseInt(IP2[0]);
                    }
                    if (!IP1[1].equals(IP2[1])) {
                        return Integer.parseInt(IP1[1]) - Integer.parseInt(IP2[1]);
                    }
                    if (!IP1[2].equals(IP2[2])) {
                        return Integer.parseInt(IP1[2]) - Integer.parseInt(IP2[2]);
                    }
                    return Integer.parseInt(IP1[3]) - Integer.parseInt(IP2[3]);
                }
                if (m1.isIsFind()) {
                    return -1;
                }
                return 1;
            }
        });
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : infoIds) {
            newMap.put((String)entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private Map<String, Object> getConfigServers(String inputXml, Class modelClass) throws Exception {
        List elements = null;
        try {
            SAXReader reader = new SAXReader();
            Document read = reader.read(new File(inputXml));
            Element rootElement = read.getRootElement();
            date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            elements = rootElement.elements();
        }
        catch (Exception ex) {
            logger.error(ex);
            if (ex.getMessage().indexOf(MessageDescription.XMLParseError) > -1 || ex.getMessage().indexOf(MessageDescription.XMLParseErrorCN) > -1 || ex.getMessage().indexOf(MessageDescription.XMLParseError2) > -1 || ex.getMessage().indexOf(MessageDescription.XMLParseError2CN) > -1) {
                throw new UMateException("XML file parse error." + MessageDescription.XMLParseError);
            }
            throw ex;
        }
        String startIP = "";
        String endIP = "";
        LinkedHashMap<String, Object> hwServers = new LinkedHashMap<String, Object>();
        for (int i = 0; i < elements.size(); ++i) {
            HWDiscoverModel hwModel = (HWDiscoverModel)modelClass.newInstance();
            Element element = (Element)elements.get(i);
            hwModel.setVersion(element.elementText("SNMPVersion"));
            hwModel.setUserName(element.elementText("UserName"));
            hwModel.setUserPassword(element.elementText("UserPassword"));
            hwModel.setSNMPPort(element.elementText("SNMPPort"));
            hwModel.setSNMPTrapPort(element.elementText("SNMPTrapPort"));
            hwModel.setTransmitType(element.elementText("TransmitType"));
            hwModel.setAuthenticationProtocol(element.elementText("AuthenticationProtocol"));
            hwModel.setPrivacyProtocol(element.elementText("PrivacyProtocol"));
            hwModel.setCommunity(element.elementText("Community"));
            hwModel.setIPMIPort(element.elementText("IPMIPort"));
            hwModel.setSSHPort(element.elementText("SSHPort"));
            hwModel.setDate(date);
            hwModel.setLogSavePath(logSavePath);
            startIP = element.elementText("StartIPAddress");
            startIP = startIP == null ? "" : startIP.trim();
            endIP = element.elementText("EndIPAddress");
            String string = endIP = endIP == null ? "" : endIP.trim();
            if ("".equals(endIP)) {
                hwModel.setIPAddress(startIP);
                if (hwServers.containsKey(startIP)) continue;
                hwServers.put(startIP, hwModel);
                continue;
            }
            String[] splitStartIP = startIP.split("\\.");
            String[] splitEndIP = endIP.split("\\.");
            if (splitStartIP.length != 4 || splitEndIP.length != 4) {
                throw new UMateException(MessageDescription.InvalidIP);
            }
            if (!splitStartIP[0].equals(splitEndIP[0]) || !splitStartIP[1].equals(splitEndIP[1])) {
                throw new UMateException(MessageDescription.InvalidSegment);
            }
            int thirdStartIP = Integer.parseInt(splitStartIP[2]);
            int thirdEndIP = Integer.parseInt(splitEndIP[2]);
            int lastStartIP = Integer.parseInt(splitStartIP[3]);
            int lastEndIP = Integer.parseInt(splitEndIP[3]);
            if (thirdStartIP > thirdEndIP || thirdStartIP == thirdEndIP && lastStartIP > lastEndIP) {
                throw new UMateException(MessageDescription.EndIPBiggerThanStartIP);
            }
            for (int thirdIP = thirdStartIP; thirdIP <= thirdEndIP; ++thirdIP) {
                String IPSect = splitStartIP[0] + "." + splitStartIP[1] + "." + thirdIP + ".";
                int loopEndIP = thirdIP < thirdEndIP ? 254 : lastEndIP;
                for (int loopStartIP = thirdIP == thirdStartIP ? lastStartIP : 1; loopStartIP <= loopEndIP; ++loopStartIP) {
                    HWDiscoverModel tmpHWModel = (HWDiscoverModel)modelClass.newInstance();
                    tmpHWModel.setIPAddress(IPSect + loopStartIP);
                    tmpHWModel.setVersion(hwModel.getVersion().name());
                    tmpHWModel.setUserName(hwModel.getUserName());
                    tmpHWModel.setUserPassword(hwModel.getUserPassword());
                    tmpHWModel.setSNMPPort(hwModel.getSNMPPort());
                    tmpHWModel.setSNMPTrapPort(hwModel.getSNMPTrapPort());
                    tmpHWModel.setTransmitType(hwModel.getTransmitType());
                    tmpHWModel.setAuthenticationProtocol(hwModel.getAuthenticationProtocol().name());
                    tmpHWModel.setPrivacyProtocol(hwModel.getPrivacyProtocol().name());
                    tmpHWModel.setCommunity(hwModel.getCommunity());
                    tmpHWModel.setIPMIPort(hwModel.getIPMIPort());
                    tmpHWModel.setSSHPort(hwModel.getSSHPort());
                    tmpHWModel.setDate(date);
                    tmpHWModel.setLogSavePath(logSavePath);
                    if (hwServers.containsKey(tmpHWModel.getIPAddress())) continue;
                    hwServers.put(tmpHWModel.getIPAddress(), tmpHWModel);
                }
            }
        }
        return hwServers;
    }

    public void printResult(HWDiscoverResultModel resultModel) {
        System.out.println("Summary:");
        System.out.println("1) total discover " + resultModel.getTotalServersCount() + " servers,PASS " + resultModel.getOkServersCount() + ",FAIL " + resultModel.getMajorServersCount());
        System.out.println("2) detail log in " + resultModel.getLogSavePath());
    }

    public String getXmlString(HWDiscoverModel model) {
        return model.toFindXMLString();
    }

    public static String setFormatString(String[] args) {
        String returnStr = "";
        if (args.length == 1) {
            HWDiscoverModel.setFormatString(HWDiscoverEnum.PrintType.Normal);
        } else if (args[1].equalsIgnoreCase("expert")) {
            HWDiscoverModel.setFormatString(HWDiscoverEnum.PrintType.Debug);
        } else if (args.length > 2 && args[2].equalsIgnoreCase("expert")) {
            HWDiscoverModel.setFormatString(HWDiscoverEnum.PrintType.Debug);
            returnStr = args[1];
        } else if (args[args.length - 1].equalsIgnoreCase("expert")) {
            HWDiscoverModel.setFormatString(HWDiscoverEnum.PrintType.Debug);
            returnStr = args[1];
        } else {
            HWDiscoverModel.setFormatString(HWDiscoverEnum.PrintType.Normal);
            returnStr = args[1];
        }
        return returnStr;
    }

    public String getResultModelXmlString(HWDiscoverResultModel resultModel) {
        return resultModel.toFindXMLString();
    }

    public void manage(String logFilePath, String outputFileName, Map<String, Object> models) {
        int poolThreads = Integer.parseInt(SystemConfig.createSystemConfig().getConfigVlaue(HWDiscoverEnum.DiscoverEnum.thread_count.name()));
        this.manage(logFilePath, outputFileName, models, poolThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manage(String logFilePath, String outputFileName, Map<String, Object> models, int poolThreads) {
        HWDiscoverResultModel resultModel = new HWDiscoverResultModel();
        resultModel.setLogSavePath(logFilePath);
        StringBuilder buffer = new StringBuilder(MessageDescription.xmlHeader);
        if (models == null) {
            models = servers;
        }
        try {
            HWDiscoverModel get;
            Iterator<String> iterator;
            boolean notFinish = true;
            boolean isFirstRun = true;
            ExecutorService threadPool = null;
            this.serversThread = new LinkedHashMap<String, Future>();
            resultModel.setTotalServersCount(models.size());
            try {
                this.pgManage = new ProgressBarManage(models.size());
                this.pgManage.start();
                if (!this.showPrintMsg) {
                    System.out.print(HWDiscoverModel.getHeadPrint());
                }
                while (notFinish) {
                    threadPool = Executors.newFixedThreadPool(poolThreads);
                    SNMPBase.SNMPInit();
                    notFinish = false;
                    iterator = models.keySet().iterator();
                    while (iterator.hasNext()) {
                        get = (HWDiscoverModel)models.get(iterator.next());
                        if (!isFirstRun && !UMateException.SameNameDiffOtherInfo.equals(get.getMsg())) continue;
                        notFinish = true;
                        get.setMsg("");
                        Thread discoverThread = this.createThread(get);
                        Future<?> submit = threadPool.submit(discoverThread);
                        this.serversThread.put(get.getIPAddress(), submit);
                    }
                    threadPool.shutdown();
                    Thread.sleep(50L);
                    while (!threadPool.isTerminated()) {
                        this.statisticServerState(this.serversThread, models, resultModel);
                        Thread.sleep(50L);
                    }
                    this.statisticServerState(this.serversThread, models, resultModel);
                    isFirstRun = false;
                }
            }
            catch (Exception exp) {
                System.out.println("Task run error." + exp.getMessage());
                if (exp.getMessage().equals(MessageDescription.SleepInterrupted)) {
                    resultModel.setErrorMsg(MessageDescription.TaskAbandoned);
                } else {
                    resultModel.setErrorMsg(exp.getMessage());
                }
                logger.error(exp);
            }
            finally {
                if (this.pgManage != null && this.pgManage.isAlive()) {
                    this.pgManage.interrupt();
                }
            }
            this.printResult(resultModel);
            LinkedHashMap<String, Object> hwOrderServers = this.getObjectOrder(models);
            iterator = hwOrderServers.keySet().iterator();
            while (iterator.hasNext()) {
                get = (HWDiscoverModel)hwOrderServers.get(iterator.next());
                if (!get.isIsRun() || UMateException.SameNameDiffOtherInfo.equals(get.getMsg())) {
                    get.setMsg(MessageDescription.TaskAbandoned);
                } else if (this.serversThread.containsKey(get.getIPAddress()) && !this.serversThread.get(get.getIPAddress()).isDone()) {
                    get.setMsg(MessageDescription.TaskAbandoned);
                    this.serversThread.get(get.getIPAddress()).cancel(true);
                    get.setInterrupt(true);
                }
                if ("".equals(get.getMsg())) {
                    logger.info(String.format("%s pass.", get.getIPAddress()));
                } else {
                    logger.info(String.format("%s %s", get.getIPAddress(), get.getMsg()));
                }
                buffer.append(this.getXmlString(get));
            }
        }
        catch (Exception notFinish) {
            // empty catch block
        }
        buffer.append(this.getResultModelXmlString(resultModel));
        buffer.append(MessageDescription.xmlFooter);
        try {
            String outputXml = logFilePath + outputFileName;
            FileOperation.writeFile(outputXml, buffer.toString());
            outputXml = MessageDescription.getLogSavePath("") + "result.xml";
            FileOperation.writeFile(outputXml, buffer.toString());
        }
        catch (Exception ex) {
            System.out.println("Export result to xml error." + ex.getMessage());
            logger.error(ex);
        }
        System.gc();
    }

    public static void initLogType(String logType) {
        logSavePath = MessageDescription.getLogSavePath(logType);
        date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }
}

