/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover.manage;

import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.ipmitool.IPMITool;
import com.huawei.cdrommount.common.log.Logger;

public class GetVersionByIPMI {
    private HWDiscoverModel snmpModel = null;
    private static Logger logger = new Logger(GetVersionByIPMI.class);

    public GetVersionByIPMI(HWDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    public boolean getVersion() {
        try {
            IPMITool ipmi = new IPMITool();
            String version = this.getVersionByIPMI(ipmi, "6");
            if (null == version) {
                return false;
            }
            this.snmpModel.setBIOSVersion(version);
            version = this.getVersionByIPMI(ipmi, "1");
            this.snmpModel.setBMCVersion(version);
            version = this.getVersionByIPMI(ipmi, "2");
            this.snmpModel.setCPLDVersion(version);
        }
        catch (Exception ex) {
            logger.error(ex);
            if ("".equals(this.snmpModel.getMsg())) {
                this.snmpModel.setMsg(MessageDescription.VersionGetFail);
            }
            return false;
        }
        return true;
    }

    private String getVersionByIPMI(IPMITool ipmi, String versionType) throws Exception {
        String cmd = "raw 0x30 0x90 0x08 0 %s 0x00 0x10";
        String version = null;
        cmd = String.format(cmd, versionType);
        this.snmpModel.setIPMIParameter(cmd);
        String execResult = ipmi.GetExecResult(this.snmpModel);
        if (!ipmi.successFlag) {
            this.snmpModel.setMsg(execResult);
            logger.info(this.snmpModel.getIPAddress() + " get version by IPMI error,message:" + execResult);
            return version;
        }
        String[] split = execResult.trim().replace("\r", " ").replace("\n", " ").split(" +");
        if (!"80".equals(split[0])) {
            return version;
        }
        version = "";
        for (int i = 1; i < split.length; ++i) {
            int tmpInt = Integer.valueOf(split[i], 16);
            version = version + (char)tmpInt;
        }
        if (version.indexOf(")") > -1) {
            version = version.substring(version.indexOf(")") + 1);
        }
        return version;
    }
}

