/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover.model;

import com.huawei.cdrommount.HWDiscover.common.HWDiscoverEnum;
import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;

public class HWDiscoverModel
extends IPMIAndSNMPModel {
    private static String formatStringNormal = "%-17s%-20s%-25s%-10s\n";
    private static String formatStringDebug = "%-17s%-20s%-25s%-10s%s\n";
    private static String formatString = formatStringNormal;
    public static String xmlFormatString = "  <Server>\n    <IPAddress>%s</IPAddress>\n    <ProductName>%s</ProductName>\n    <SerialNumber>%s</SerialNumber>\n    <iBMCVersion>%s</iBMCVersion>\n    <CPLDVersion>%s</CPLDVersion>\n    <BiosVersion>%s</BiosVersion>\n    <SoftwareVersion>%s</SoftwareVersion>\n    <Result>%s</Result>\n    <ErrorMessage>%s</ErrorMessage>\n  </Server>\n";
    private static String xmlFormatStringLogCollect = "  <Server>\n    <IPAddress>%s</IPAddress>\n    <ProductName>%s</ProductName>\n    <SerialNumber>%s</SerialNumber>\n    <iBMCVersion>%s</iBMCVersion>\n    <CPLDVersion>%s</CPLDVersion>\n    <BiosVersion>%s</BiosVersion>\n    <SoftwareVersion>%s</SoftwareVersion>\n    <Health>%s</Health>\n    <Result>%s</Result>\n    <ErrorMessage>%s</ErrorMessage>\n  </Server>\n";
    public static String upgradeXmlFormatString = "  <Server>\n    <ID></ID>\n    <IPAddress>%s</IPAddress>\n    <ProductName>%s</ProductName>\n    <SerialNumber>%s</SerialNumber>\n    <Result>%s</Result>\n    <iBMCVersion>%s</iBMCVersion>\n    <CPLDVersion>%s</CPLDVersion>\n    <BiosVersion>%s</BiosVersion>\n    <SoftwareVersion>%s</SoftwareVersion>\n    <ErrorMessage>%s</ErrorMessage>\n  </Server>\n";
    private String startIPAddress = "";
    private String endIPAddress = "";
    private HWDiscoverEnum.HealthType health = HWDiscoverEnum.HealthType.Unknown;
    private boolean isFind = false;
    private String msg = "";
    private String productName = "";
    private String serialNumber = "";
    private HWDiscoverEnum.ProductType productType = HWDiscoverEnum.ProductType.Common;
    private boolean isRun = false;
    private String date = "";
    private String logSavePath = "";
    private HWDiscoverEnum.DiscoverType discoverType = HWDiscoverEnum.DiscoverType.Unknown;
    private HWDiscoverEnum.DiscoverType oldDiscoverType = HWDiscoverEnum.DiscoverType.Unknown;
    private int lastDiscoverType = 0;
    private boolean status = false;
    private boolean opSuccess = false;
    private String BMCVersion = "";
    private String BIOSVersion = "";
    private String CPLDVersion = "";
    private String HDBackCPLDVersion = "";
    private String UBootVersion = "";
    private String FPGAVersion = "";
    private String software = "";
    private boolean interrupt = false;

    public static void setFormatString(HWDiscoverEnum.PrintType type) {
        switch (type) {
            case Debug: {
                formatString = formatStringDebug;
                break;
            }
            default: {
                formatString = formatStringNormal;
            }
        }
    }

    public String getStartIPAddress() {
        return this.startIPAddress;
    }

    public void setStartIPAddress(String startIPAddress) {
        this.startIPAddress = startIPAddress;
    }

    public String getEndIPAddress() {
        return this.endIPAddress;
    }

    public void setEndIPAddress(String endIPAddress) {
        this.endIPAddress = endIPAddress;
    }

    public HWDiscoverEnum.HealthType getHealth() {
        return this.health;
    }

    public String getHealth(int errorLevel) {
        if (errorLevel == 0) {
            return HWDiscoverEnum.HealthType.OK.name();
        }
        if (errorLevel == 1) {
            return HWDiscoverEnum.HealthType.Info.name();
        }
        if (errorLevel == 2) {
            return HWDiscoverEnum.HealthType.Warning.name();
        }
        if (errorLevel == 3) {
            return HWDiscoverEnum.HealthType.Minor.name();
        }
        if (errorLevel == 4) {
            return HWDiscoverEnum.HealthType.Major.name();
        }
        if (errorLevel == 5) {
            return HWDiscoverEnum.HealthType.Critical.name();
        }
        return HWDiscoverEnum.HealthType.Unknown.name();
    }

    public void setHealth(String health) throws UMateException {
        try {
            this.health = HWDiscoverEnum.HealthType.valueOf(health);
        }
        catch (Exception exp) {
            this.msg = "Server health value is error.";
            throw new UMateException("Server health value is error.", exp);
        }
    }

    public void setHealth(HWDiscoverEnum.HealthType health) {
        this.health = health;
    }

    public boolean isIsFind() {
        return this.isFind;
    }

    public void setIsFind(boolean isFind) {
        this.isFind = isFind;
    }

    public String getMsg() {
        this.msg = this.msg == null ? "" : this.msg;
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        if (null != productName && !"".equals(productName.trim())) {
            if (productName.toLowerCase().startsWith("tecal")) {
                productName = productName.substring("tecal".length());
            }
            this.productName = productName.trim();
        }
    }

    public HWDiscoverEnum.ProductType getProductType() {
        return this.productType;
    }

    public void setProductType(HWDiscoverEnum.ProductType productType) {
        this.msg = "";
        this.productType = productType;
    }

    public String getBMCVersion() {
        return this.BMCVersion;
    }

    public void setBMCVersion(String BMCVersion) {
        this.BMCVersion = BMCVersion;
    }

    public String getBIOSVersion() {
        return this.BIOSVersion;
    }

    public void setBIOSVersion(String BIOSVersion) {
        this.BIOSVersion = BIOSVersion;
    }

    public String getCPLDVersion() {
        return this.CPLDVersion;
    }

    public void setCPLDVersion(String CPLDVersion) {
        this.CPLDVersion = CPLDVersion;
    }

    public String getHDBackCPLDVersion() {
        return this.HDBackCPLDVersion;
    }

    public void setHDBackCPLDVersion(String HDBackCPLDVersion) {
        this.HDBackCPLDVersion = HDBackCPLDVersion;
    }

    public String getUBootVersion() {
        return this.UBootVersion;
    }

    public void setUBootVersion(String UBootVersion) {
        this.UBootVersion = UBootVersion;
    }

    public String getFPGAVersion() {
        return this.FPGAVersion;
    }

    public void setFPGAVersion(String FPGAVersion) {
        this.FPGAVersion = FPGAVersion;
    }

    public String toHealthString() {
        if (MessageDescription.ConnectError.equals(this.getMsg())) {
            return "";
        }
        String printHealth = this.getHealth().name();
        return String.format(formatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), printHealth, this.getMsg());
    }

    public String toHealthXMLString() {
        String printHealth = this.getHealth().name();
        return String.format(xmlFormatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), this.getBMCVersion(), this.getCPLDVersion(), this.getBIOSVersion(), this.getSoftware(), printHealth, this.getMsg());
    }

    public String toNoHealthXMLString() {
        String logStatus = this.status ? "PASS" : "FAIL";
        return String.format(xmlFormatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), this.getBMCVersion(), this.getCPLDVersion(), this.getBIOSVersion(), this.getSoftware(), logStatus, this.getMsg());
    }

    public String toFindString() {
        if (MessageDescription.ConnectError.equals(this.getMsg())) {
            return "";
        }
        String printFind = this.isIsFind() ? "PASS" : "FAIL";
        return String.format(formatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), printFind, this.getMsg());
    }

    public String toFindXMLString() {
        String printFind = this.isIsFind() ? "PASS" : "FAIL";
        return String.format(xmlFormatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), this.getBMCVersion(), this.getCPLDVersion(), this.getBIOSVersion(), this.getSoftware(), printFind, this.getMsg());
    }

    public String toLogCollectString() {
        if (MessageDescription.ConnectError.equals(this.getMsg())) {
            return "";
        }
        String logStatus = this.status ? "PASS" : "FAIL";
        return String.format(formatString, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), logStatus, this.getMsg());
    }

    public String toLogCollectXMLString() {
        String logStatus = this.status ? "PASS" : "FAIL";
        return String.format(xmlFormatStringLogCollect, this.getIPAddress(), this.getProductName(), this.getSerialNumber(), this.getBMCVersion(), this.getCPLDVersion(), this.getBIOSVersion(), this.getSoftware(), this.getHealth().name(), logStatus, this.getMsg());
    }

    public static String getHeadPrint() {
        return String.format(formatString, "IPAddress", "ProductName", "SerialNumber", "Result", "ErrorMessage");
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (null == serialNumber) {
            return;
        }
        this.serialNumber = serialNumber = serialNumber.trim().replace("\r", "").replace("\n", "").replace("\t", "");
    }

    public boolean isIsRun() {
        return this.isRun;
    }

    public void setIsRun(boolean isRun) {
        this.isRun = isRun;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLogSavePath(String type) {
        if ("".equals(this.logSavePath)) {
            return MessageDescription.getLogSavePath(type);
        }
        if (!this.logSavePath.endsWith("/") && !this.logSavePath.endsWith("\\")) {
            this.logSavePath = this.logSavePath + "/";
        }
        return this.logSavePath;
    }

    public void setLogSavePath(String logSavePath) {
        this.logSavePath = logSavePath = logSavePath == null ? "" : logSavePath.trim();
    }

    public HWDiscoverEnum.DiscoverType getDiscoverType() {
        return this.discoverType;
    }

    public void setDiscoverType(HWDiscoverEnum.DiscoverType discoverType) {
        this.discoverType = discoverType;
    }

    public int getLastDiscoverType() {
        return this.lastDiscoverType;
    }

    public void setLastDiscoverType(int lastDiscoverType) {
        this.lastDiscoverType = lastDiscoverType;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public boolean isOpSuccess() {
        return this.opSuccess;
    }

    public void setOpSuccess(boolean opSuccess) {
        this.opSuccess = opSuccess;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String software) {
        this.software = software;
    }

    public HWDiscoverEnum.DiscoverType getOldDiscoverType() {
        return this.oldDiscoverType;
    }

    public void setOldDiscoverType(HWDiscoverEnum.DiscoverType oldDiscoverType) {
        this.oldDiscoverType = oldDiscoverType;
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }
}

