/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount;

import com.huawei.cdrommount.manage.LogStreamManage;
import com.huawei.vm.console.management.ConsoleControllers;
import com.huawei.vm.virtualconnection.VirtualConnect;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class VirtualConnectIMG
extends VirtualConnect {
    private static final int IMG = 1;
    private static final int PORT_VALID_START = 1;
    private static final int PORT_VALID_END = 65535;
    private static final int ERR_VIRCONN_OK = 0;
    private static final int ERR_VIRCONN_CONN_ALREADY_EXIST = 501;
    private static final int ERR_VIRCONN_PARA_TYPE_ERROR = 502;
    private static final int ERR_VIRCONN_PARA_IP_ERROR = 503;
    private static final int ERR_VIRCONN_PARA_PORT_ERROR = 504;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_NULL = 505;
    private static final int ERR_VIRCONN_PARA_ISO_PATH_INVALID = 506;
    private static final int ERR_VIRCONN_CONN_NOT_EXIST = 507;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_NOT_ACTIVE = 508;
    private static final int ERR_VIRCONN_CREATE_FAILED_CONSOLE_STILL_IDLE = 509;
    private ConsoleControllers vmApplet = null;
    private javax.swing.Timer imgVMlink = null;
    private boolean vmmconnected = false;

    public VirtualConnectIMG() {
        this.vmApplet = new ConsoleControllers();
        this.vmApplet.setLanguage("en");
    }

    public VirtualConnectIMG(String threadName) {
        this.vmApplet = new ConsoleControllers(threadName);
        this.vmApplet.setLanguage("en");
    }

    public String getErrMsg(int errCode) {
        return this.vmApplet.getStatement(errCode);
    }

    public int connect(int type, String serverIp, int serverPort, long verifyID, String imgPath) {
        if (this.vmmconnected) {
            return 501;
        }
        if (1 != type) {
            return 502;
        }
        return this.createVMLink(1, serverIp, serverPort, verifyID, imgPath);
    }

    public int connect(int type, String serverIp, int serverPort, byte[] certifyID, byte[] salt, boolean bCodeKeyNego, boolean bSecret, String imagePath) {
        try {
            if (this.vmmconnected) {
                return 501;
            }
            if (1 != type) {
                return 502;
            }
            if (serverPort < 1 || serverPort > 65535) {
                return 504;
            }
            try {
                LogStreamManage.log("1," + imagePath + "," + serverIp + "," + serverPort + "," + certifyID + "," + salt + "," + bCodeKeyNego + "," + bSecret + "\n");
                String ret = this.vmApplet.creatVMLink(1, imagePath, serverIp, serverPort, certifyID, salt, bCodeKeyNego, bSecret, false, null, null, null, 1);
            }
            catch (Exception ex) {
                LogStreamManage.log("VMLink:" + ex + "\n");
            }
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.checkCdromVMConsole();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int disconnect() {
        if (!this.vmmconnected) {
            System.out.println("[vmm] vmm connection not exists.");
            return 507;
        }
        this.disconnectVMLink(1);
        return 0;
    }

    private int createVMLink(int deviceType, String serverIP, int serverPort, long certifyID, String imagePath) {
        byte[] codeKey = new byte[]{(byte)(certifyID >> 24 & 0xFFL), (byte)(certifyID >> 16 & 0xFFL), (byte)(certifyID >> 8 & 0xFFL), (byte)(certifyID & 0xFFL)};
        try {
            LogStreamManage.log(deviceType + "," + imagePath + "," + serverIP + "," + serverPort + "," + codeKey + "\n");
            this.vmApplet.creatVMLink(deviceType, imagePath, serverIP, serverPort, codeKey, null, false, false, false, null, null, null, 1);
        }
        catch (Exception ex) {
            LogStreamManage.log("VMLink:" + ex + "\n");
        }
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.checkCdromVMConsole();
    }

    private void disconnectVMLink(int deviceType) {
        if (deviceType == 1) {
            this.vmApplet.destroyVMLink(deviceType);
            Timer t = new Timer("cdrom disconnectVMLink");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    VirtualConnectIMG.this.vmmconnected = false;
                }
            };
            t.schedule(task, 2000L);
        }
    }

    private int checkCdromVMConsole() {
        int state_code = 0;
        if (!this.vmApplet.isConsoleOK(1)) {
            if (this.vmApplet.isVMLinkCrt(1)) {
                Timer date = new Timer("cdrom checkVMConsole");
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (null == VirtualConnectIMG.this.imgVMlink) {
                            VirtualConnectIMG.this.imgVMlink = new javax.swing.Timer(1000, VirtualConnectIMG.this.doImgVMlink());
                        }
                        VirtualConnectIMG.this.imgVMlink.start();
                    }
                };
                date.schedule(task, 800L);
                this.vmmconnected = true;
                state_code = 0;
            } else {
                this.vmmconnected = false;
                this.vmApplet.destroyVMLink(1);
                state_code = this.vmApplet.getConsoleState(1);
                if (0 == state_code) {
                    state_code = 508;
                    System.out.println("[vmm] Create vmm failed,console leaves idle state but still not active.");
                }
            }
        } else {
            this.vmmconnected = false;
            state_code = this.vmApplet.getConsoleState(1);
            if (0 == state_code) {
                state_code = 509;
                System.out.println("[vmm] Create vmm failed,console initialization failed,still in idle state.");
            }
        }
        return state_code;
    }

    private Action doImgVMlink() {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VirtualConnectIMG.this.vmApplet.isVMLinkCrt(1)) {
                    VirtualConnectIMG.this.imgVMlink.stop();
                    VirtualConnectIMG.this.imgVMlink = null;
                    VirtualConnectIMG.this.disconnectVMLink(1);
                }
            }
        };
        return action;
    }
}

