/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.display;

import com.huawei.cdrommount.common.GlobalStaticValue;
import com.huawei.cdrommount.common.file.FileOperation;
import com.huawei.cdrommount.common.log.Logger;

public class ProgressBarManage
extends Thread {
    private Logger logger = new Logger(ProgressBarManage.class);
    private int totalNumber = 0;
    private String progressLogPath = GlobalStaticValue.progressLogPath;
    private int completedNumber = 0;
    private double percentage = 0.0;

    public ProgressBarManage(int totalNumber) {
        this.totalNumber = totalNumber;
    }

    public ProgressBarManage(int totleNumber, String logPath) {
        this.totalNumber = totleNumber;
        this.progressLogPath = logPath;
    }

    public synchronized void addCompetedNumber(int number) {
        this.completedNumber += number;
    }

    public synchronized void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    private String getPercentage() {
        if (this.totalNumber != 0) {
            this.percentage = (double)this.completedNumber / (double)this.totalNumber;
        }
        return Integer.toString((int)(this.percentage * 100.0));
    }

    @Override
    public void run() {
        String oldContent = "";
        String content = "";
        try {
            while (!this.isInterrupted()) {
                content = this.getPercentage();
                if (!oldContent.equals(content)) {
                    FileOperation.writeFile(this.progressLogPath, content);
                    if (this.percentage >= 1.0) break;
                }
                ProgressBarManage.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception ex) {
            this.logger.error(ex);
        }
    }
}

