/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.file;

import com.huawei.cdrommount.common.UMateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class FileOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String oldPath, String newPath) throws IOException {
        int bytesum = 0;
        int byteread = 0;
        File oldfile = new File(oldPath);
        File newFile = new File(newPath);
        if (null != newFile.getParentFile()) {
            newFile.getParentFile().mkdirs();
        }
        if (oldfile.exists()) {
            FileInputStream inStream = null;
            FileOutputStream fs = null;
            try {
                inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
            }
            finally {
                if (null != fs) {
                    fs.close();
                }
                if (null != inStream) {
                    ((InputStream)inStream).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFolder(String oldPath, String newPath) throws IOException {
        new File(newPath).mkdirs();
        File a = new File(oldPath);
        String[] file = a.list();
        File temp = null;
        for (int i = 0; i < file.length; ++i) {
            temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
            if (temp.isFile()) {
                FileInputStream input = null;
                FileOutputStream output = null;
                try {
                    int len;
                    input = new FileInputStream(temp);
                    output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                }
                finally {
                    if (null != output) {
                        output.close();
                    }
                    if (null != input) {
                        input.close();
                    }
                }
            }
            if (!temp.isDirectory()) continue;
            this.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
        }
    }

    public boolean renameTo(String oldPath, String newPath) throws IOException, UMateException {
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        if (newFile.exists()) {
            this.deleteFile(newFile.getPath());
        }
        if (oldFile.exists() && !newFile.exists()) {
            boolean renameTo = oldFile.renameTo(newFile);
            return renameTo;
        }
        throw new UMateException("\u539f\u6587\u4ef6\u201c" + oldPath + "\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u76ee\u6807\u6587\u4ef6\u201c" + newPath + "\u201d\u5b58\u5728\u3002");
    }

    public void deleteFile(String fileName) throws UMateException {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            throw new UMateException(fileName + ":file delete error.");
        }
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String content) throws Exception {
        File orderFile = new File(fileName);
        if (null != orderFile.getParentFile() && !orderFile.getParentFile().exists()) {
            orderFile.getParentFile().mkdirs();
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(orderFile);
            ((OutputStream)outStream).write(content.getBytes(Charset.forName("UTF-8")));
            outStream.flush();
        }
        finally {
            if (null != outStream) {
                ((OutputStream)outStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFile(String fileName) throws Exception {
        File zipVersionFile = new File(fileName);
        StringBuffer content = new StringBuffer("");
        InputStreamReader reader = null;
        FileInputStream fileInputStream = null;
        try {
            int read;
            char[] cbuf = new char[1024];
            fileInputStream = new FileInputStream(zipVersionFile);
            reader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            while ((read = reader.read(cbuf)) > 0) {
                content.append(cbuf, 0, read);
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return content;
    }
}

