/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.ipmitool;

import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.common.GlobalStaticValue;
import com.huawei.cdrommount.common.SystemInfo;
import com.huawei.cdrommount.common.internationalization.CommonEnum;
import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import java.io.InputStream;

public class IPMITool {
    private static String ipmitool = null;
    public boolean successFlag = false;
    private Logger logger = new Logger(IPMITool.class);

    public IPMITool() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetExecResult(IPMIAndSNMPModel snmpMudel) throws Exception {
        String result = "";
        String errorResult = "";
        Process exec = null;
        InputStream inputStream = null;
        InputStream errorStream = null;
        try {
            int len;
            String cmd = String.format("%s -I %s -H %s -p %s -U \"%s\" -P \"%s\" %s", ipmitool, snmpMudel.getIPMIInterface().name(), snmpMudel.getIPAddress(), snmpMudel.getIPMIPort(), snmpMudel.getUserName().replace("\"", "\\\""), snmpMudel.getUserPassword().replace("\"", "\\\""), snmpMudel.getIPMIParameter());
            if (SystemInfo.GetOSType() == SystemInfo.OSType.Linux) {
                String[] command = new String[]{"sh", "-c", cmd};
                exec = Runtime.getRuntime().exec(command);
            } else {
                exec = Runtime.getRuntime().exec(cmd);
            }
            inputStream = exec.getInputStream();
            byte[] b = new byte[5120];
            while ((len = inputStream.read(b)) != -1) {
                result = result + new String(b, 0, len, "UTF-8");
            }
            errorStream = exec.getErrorStream();
            while ((len = errorStream.read(b)) != -1) {
                errorResult = errorResult + new String(b, 0, len, "UTF-8");
            }
            int exitValue = exec.waitFor();
            if (exitValue != 0) {
                if (errorResult.indexOf(MessageDescription.AuthenticationTypeNone) > -1) {
                    snmpMudel.setIPMIInterface(IPMIAndSNMPModel.IPMIInterfaceEnum.lanplus);
                    String string = this.GetExecResult(snmpMudel);
                    return string;
                }
                if (errorResult.indexOf(MessageDescription.InvalidUsername) > -1) {
                    String string = MessageDescription.UserNameOrPWDError;
                    return string;
                }
                if (errorResult.indexOf(MessageDescription.InsufficientPrivilegeLevel) > -1) {
                    String string = MessageDescription.NonAdministrator;
                    return string;
                }
                if (errorResult.indexOf(MessageDescription.ActivateSessionFail) > -1) {
                    String string = MessageDescription.ActivateSessionFail;
                    return string;
                }
                if (errorResult.indexOf(MessageDescription.NodeBusy) > -1) {
                    String string = MessageDescription.NodeBusyFail;
                    return string;
                }
                if (errorResult.indexOf(MessageDescription.CommandNotSupport) > -1) {
                    String string = MessageDescription.CommandNotSupport;
                    return string;
                }
                this.logger.info(snmpMudel.getIPAddress() + " ipmi cmd exec failed.Message:" + errorResult);
                String string = MessageDescription.UnableEstablishLANSession;
                return string;
            }
            this.successFlag = true;
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != errorStream) {
                errorStream.close();
            }
            if (null != exec) {
                exec.destroy();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        IPMITool iPMITool = this;
        synchronized (iPMITool) {
            if (null != ipmitool) {
                return;
            }
        }
        SystemInfo.OSType GetOSType = SystemInfo.GetOSType();
        if (GetOSType == SystemInfo.OSType.Windows) {
            ipmitool = GlobalStaticValue.commonBundle.getValue((Object)CommonEnum.CommonResourcesEnum.WindowsIPMITool);
        } else if (GetOSType == SystemInfo.OSType.Linux) {
            ipmitool = GlobalStaticValue.commonBundle.getValue((Object)CommonEnum.CommonResourcesEnum.LinuxIPMITool);
        }
    }

    private String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

