/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.log;

import java.text.MessageFormat;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class Logger {
    private final org.apache.log4j.Logger logger;
    private static final String FQCN = Logger.class.getName();

    public Logger(Class<?> clazz) {
        this.logger = org.apache.log4j.Logger.getLogger(clazz);
    }

    public Logger(String className) {
        this.logger = org.apache.log4j.Logger.getLogger((String)className);
    }

    private Logger() {
        this.logger = org.apache.log4j.Logger.getRootLogger();
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public static Logger getRootLogger() {
        return new Logger();
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            if (Exception.class.isAssignableFrom(message.getClass())) {
                Logger.forcedLog(this.logger, Level.DEBUG, message, (Exception)message);
            } else {
                Logger.forcedLog(this.logger, Level.DEBUG, message);
            }
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            if (Exception.class.isAssignableFrom(message.getClass())) {
                Logger.forcedLog(this.logger, Level.INFO, message, (Exception)message);
            } else {
                Logger.forcedLog(this.logger, Level.INFO, message);
            }
        }
    }

    public void trace(Object message) {
        if (this.logger.isTraceEnabled()) {
            if (Exception.class.isAssignableFrom(message.getClass())) {
                Logger.forcedLog(this.logger, Level.TRACE, message, (Exception)message);
            } else {
                Logger.forcedLog(this.logger, Level.TRACE, message);
            }
        }
    }

    public void warn(Object message) {
        if (this.logger.isEnabledFor(Priority.WARN)) {
            if (Exception.class.isAssignableFrom(message.getClass())) {
                Logger.forcedLog(this.logger, Level.WARN, message, (Exception)message);
            } else {
                Logger.forcedLog(this.logger, Level.WARN, message);
            }
        }
    }

    public void error(Object message) {
        if (this.logger.isEnabledFor(Priority.ERROR)) {
            if (Exception.class.isAssignableFrom(message.getClass())) {
                Logger.forcedLog(this.logger, Level.ERROR, message, (Exception)message);
            } else {
                Logger.forcedLog(this.logger, Level.ERROR, message);
            }
        }
    }

    public void error(String message, Exception ex) {
        if (this.logger.isEnabledFor(Priority.ERROR)) {
            Logger.forcedLog(this.logger, Level.ERROR, message, ex);
        }
    }

    public void assertLog(boolean assertion, String message) {
        if (!assertion) {
            Logger.forcedLog(this.logger, Level.ERROR, message);
        }
    }

    private static void forcedLog(org.apache.log4j.Logger logger, Level level, Object message) {
        logger.callAppenders(new LoggingEvent(FQCN, (Category)logger, (Priority)level, message, null));
    }

    private static void forcedLog(org.apache.log4j.Logger logger, Level level, Object message, Throwable t) {
        logger.callAppenders(new LoggingEvent(FQCN, (Category)logger, (Priority)level, message, t));
    }

    private static String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }
}

