/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.ping;

import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.common.SystemInfo;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.log.Logger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;

public class Ping {
    private static Logger logger = new Logger(Ping.class);

    public static boolean hostCanConnect(String hostName) throws Exception {
        boolean reachable = false;
        try {
            reachable = InetAddress.getByName(hostName).isReachable(10000);
            if (reachable) {
                return reachable;
            }
            reachable = Ping.checkPythonInstall(hostName);
        }
        catch (Exception ex) {
            throw new UMateException(MessageDescription.ConnectError);
        }
        return reachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkPythonInstall(String hostName) {
        InputStream inputStream = null;
        ProcessBuilder pb = null;
        Process start = null;
        BufferedReader br = null;
        String printText = "";
        try {
            pb = SystemInfo.GetOSType() == SystemInfo.OSType.Windows ? new ProcessBuilder("ping", hostName, "-n", "5") : new ProcessBuilder("ping", hostName, "-c", "5");
            pb.redirectErrorStream(true);
            start = pb.start();
            inputStream = start.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream));
            String inline = null;
            while ((inline = br.readLine()) != null) {
                printText = printText + inline + "\r\n";
            }
            Thread.sleep(500L);
            boolean bl = start.exitValue() == 0;
            return bl;
        }
        catch (Exception ex) {
            logger.error(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (start != null) {
                    start.destroy();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

