/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.snmp;

import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPV2c;
import com.huawei.cdrommount.common.snmp.SNMPV3;
import com.huawei.cdrommount.common.snmp.USMFactory;
import java.io.IOException;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public abstract class SNMPBase {
    public IPMIAndSNMPModel snmpMudel = null;

    public static synchronized SNMPBase SNMPCreate(IPMIAndSNMPModel snmpModel, SNMPBase snmpBaseOld) throws IOException, UMateException, Exception {
        if (null != snmpBaseOld) {
            snmpBaseOld.SNMPClose();
        }
        SNMPBase snmpBase = null;
        switch (snmpModel.getVersion()) {
            case V1: 
            case V2C: {
                snmpBase = new SNMPV2c(snmpModel);
                break;
            }
            default: {
                snmpBase = new SNMPV3(snmpModel);
            }
        }
        snmpModel.setSNMPErrorCode(0);
        snmpModel.setSNMPErrorMsg("");
        return snmpBase;
    }

    public static void SNMPInit() {
        USMFactory.clearUsmUsers();
    }

    public String GetOIDValue(String OID) throws Exception {
        return this.GetOIDValue(OID, false);
    }

    public abstract String GetOIDValue(String var1, boolean var2) throws Exception;

    public abstract String GetOIDNextValue(String var1) throws Exception;

    public abstract String GetOIDWalkValue(String var1) throws Exception;

    public abstract void SNMPClose();

    public abstract boolean resetLocalEngine();

    public Variable getSetValue() {
        OID value = null;
        switch (this.snmpMudel.getSNMPValueType()) {
            case Integer32: {
                value = new Integer32(Integer.parseInt(this.snmpMudel.getSNMPSetValue()));
                break;
            }
            case UnsignedInteger32: {
                value = new UnsignedInteger32(Integer.parseInt(this.snmpMudel.getSNMPSetValue()));
                break;
            }
            case OID: {
                value = new OID(this.snmpMudel.getSNMPSetValue());
                break;
            }
            case OctetString: {
                value = new OctetString(this.snmpMudel.getSNMPSetValue());
                break;
            }
            case Counter32: {
                value = new Counter32(Long.parseLong(this.snmpMudel.getSNMPSetValue()));
                break;
            }
            case Counter64: {
                value = new Counter64(Long.parseLong(this.snmpMudel.getSNMPSetValue()));
                break;
            }
            case Gauge32: {
                value = new Gauge32(Long.parseLong(this.snmpMudel.getSNMPSetValue()));
                break;
            }
            case IpAddress: {
                value = new IpAddress(this.snmpMudel.getSNMPSetValue());
                break;
            }
            case Opaque: {
                value = new Opaque(this.snmpMudel.getSNMPSetValue().getBytes());
            }
        }
        return value;
    }
}

