/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.snmp;

import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import java.io.IOException;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPV3
extends SNMPBase {
    private static final Logger logger = new Logger(SNMPV3.class);
    private ScopedPDU scPdu = null;
    private DefaultUdpTransportMapping defaultUdpTransportMapping = null;
    private Snmp snmp = null;
    private UserTarget userTarget = null;
    private ResponseEvent response = null;
    UsmUser user = null;
    USM usm;

    public SNMPV3(IPMIAndSNMPModel snmpModel) throws Exception {
        this.snmpMudel = snmpModel;
        this.scPdu = new ScopedPDU();
        this.scPdu.setType(-95);
        this.scPdu.setMaxRepetitions(50);
        this.scPdu.setNonRepeaters(1);
        this.userTarget = new UserTarget();
        this.userTarget.setAddress(GenericAddress.parse((String)(this.snmpMudel.getTransmitType() + ":" + this.snmpMudel.getIPAddress() + "/" + this.snmpMudel.getSNMPPort())));
        this.userTarget.setRetries(1);
        this.userTarget.setTimeout(20000L);
        this.userTarget.setVersion(3);
        this.userTarget.setSecurityLevel(3);
        this.userTarget.setSecurityModel(3);
        this.userTarget.setSecurityName(new OctetString(this.snmpMudel.getUserName()));
        byte[] localEngineID = MPv3.createLocalEngineID();
        this.usm = new USM(SecurityProtocols.getInstance(), new OctetString(localEngineID), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        this.defaultUdpTransportMapping = new DefaultUdpTransportMapping();
        this.snmp = new Snmp((TransportMapping)this.defaultUdpTransportMapping);
        this.snmp.setLocalEngine(localEngineID, 0, 0);
        this.snmp.listen();
    }

    @Override
    public boolean resetLocalEngine() {
        try {
            byte[] discoverAuthoritativeEngineID = this.snmp.discoverAuthoritativeEngineID(this.userTarget.getAddress(), 20000L);
            if (discoverAuthoritativeEngineID != null && discoverAuthoritativeEngineID.length > 0) {
                logger.info(String.format("%s discover the target server successfully.", this.snmpMudel.getIPAddress()));
                return true;
            }
            logger.info(String.format("%s discover the target server failed.", this.snmpMudel.getIPAddress()));
            return false;
        }
        catch (Exception ex) {
            logger.error(this.snmpMudel.getIPAddress(), ex);
            return false;
        }
    }

    @Override
    public String GetOIDValue(String OID2, boolean canCounter) throws IOException, Exception {
        return this.GetOIDValue(OID2, -96);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetOIDValue(String OID2, int getType) throws Exception {
        this.scPdu.clear();
        if (this.snmpMudel.getSNMPValueType() == IPMIAndSNMPModel.SNMPSetValueType.None) {
            this.scPdu.setType(getType);
            this.scPdu.add(new VariableBinding(new OID(OID2)));
        } else {
            this.scPdu.setType(-93);
            this.scPdu.add(new VariableBinding(new OID(OID2), this.getSetValue()));
        }
        OID AuthP = AuthMD5.ID;
        if (this.snmpMudel.getAuthenticationProtocol() == IPMIAndSNMPModel.AuthenticationProtocol.SHA) {
            AuthP = AuthSHA.ID;
        }
        OID PrivP = PrivDES.ID;
        if (this.snmpMudel.getPrivacyProtocol() == IPMIAndSNMPModel.PrivacyProtocol.AES) {
            PrivP = PrivAES128.ID;
        }
        this.user = new UsmUser(new OctetString(this.snmpMudel.getUserName()), AuthP, new OctetString(this.snmpMudel.getUserPassword()), PrivP, new OctetString(this.snmpMudel.getUserPassword()));
        Logger logger = SNMPV3.logger;
        synchronized (logger) {
            this.usm.addUser(this.user.getSecurityName(), this.user);
            this.response = this.snmp.send((PDU)this.scPdu, (Target)this.userTarget);
        }
        if (this.response == null || this.response.getResponse() == null) {
            SNMPV3.logger.info(String.format("%s %s timeout.", this.snmpMudel.getIPAddress(), OID2));
            return "Request timeout.";
        }
        VariableBinding get = this.response.getResponse().get(0);
        if (get.getVariable().getSyntaxString().equals("Counter")) {
            SNMPV3.logger.info(String.format("%s %s no such object.", this.snmpMudel.getIPAddress(), OID2));
            return "noSuchObject";
        }
        return get.getVariable().toString();
    }

    @Override
    public String GetOIDNextValue(String OID2) throws Exception {
        this.scPdu.setType(-95);
        this.scPdu.clear();
        this.scPdu.add(new VariableBinding(new OID(OID2)));
        this.response = this.snmp.send((PDU)this.scPdu, (Target)this.userTarget);
        if (this.response.getResponse() == null) {
            return "Request timeout.";
        }
        VariableBinding get = this.response.getResponse().get(0);
        return get.getOid() + "=" + get.getVariable();
    }

    @Override
    public String GetOIDWalkValue(String OID2) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void SNMPClose() {
        if (null != this.defaultUdpTransportMapping) {
            try {
                this.defaultUdpTransportMapping.close();
                this.defaultUdpTransportMapping = null;
            }
            catch (Exception exp) {
                logger.error(exp);
            }
        }
        if (null != this.snmp) {
            try {
                this.snmp.close();
            }
            catch (Exception exp) {
                logger.error(exp);
            }
        }
    }
}

