/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.snmp;

import com.huawei.cdrommount.common.UMateException;
import java.util.Iterator;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.OctetString;

class USMFactory {
    private static USM usm = null;
    static OctetString octetString = null;

    USMFactory() {
    }

    static synchronized USM getInstance() {
        if (null == usm) {
            octetString = new OctetString(MPv3.createLocalEngineID());
            usm = new USM(SecurityProtocols.getInstance(), octetString, 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            usm.getUserTable().clear();
            usm.setEngineDiscoveryEnabled(true);
        }
        return usm;
    }

    static synchronized void addUser(UsmUser user) throws UMateException {
        UsmUserTable userTable = usm.getUserTable();
        Iterator userEntries = userTable.getUserEntries().iterator();
        UsmUser usmUser = null;
        while (userEntries.hasNext()) {
            usmUser = ((UsmUserEntry)userEntries.next()).getUsmUser();
            if (USMFactory.compare(usmUser, user)) {
                return;
            }
            if (!usmUser.getSecurityName().equals((Object)user.getSecurityName())) continue;
        }
        usm.addUser(user.getSecurityName(), user);
    }

    static void addUser(UsmUser user, byte[] authoritativeEngineID) {
        usm.addUser(user.getSecurityName(), OctetString.fromByteArray((byte[])authoritativeEngineID), user);
    }

    private static boolean compare(UsmUser user1, UsmUser user2) {
        if (!user1.getSecurityName().equals((Object)user2.getSecurityName())) {
            return false;
        }
        if (!user1.getAuthenticationPassphrase().equals((Object)user2.getAuthenticationPassphrase())) {
            return false;
        }
        if (!user1.getAuthenticationProtocol().equals((Object)user2.getAuthenticationProtocol())) {
            return false;
        }
        if (!user1.getPrivacyPassphrase().equals((Object)user2.getPrivacyPassphrase())) {
            return false;
        }
        if (user1.getPrivacyProtocol() == null) {
            return user2.getPrivacyProtocol() == null;
        }
        return user1.getPrivacyProtocol().equals((Object)user2.getPrivacyProtocol());
    }

    static synchronized void clearUsmUsers() {
        if (null != usm) {
            usm.getUserTable().clear();
            usm.removeAllUsers();
            usm = null;
        }
        USMFactory.getInstance();
    }
}

