/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.manage;

import com.huawei.cdrommount.GetVmmFlagByIPMI;
import com.huawei.cdrommount.GetVmmFlagBySNMP;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.VirtualConnectIMG;
import com.huawei.cdrommount.manage.LogStreamManage;
import com.huawei.cdrommount.model.ConnectModel;
import com.huawei.cdrommount.model.SetVmmKeyByIPMI;
import com.huawei.cdrommount.model.SetVmmKeyBySNMP;
import com.huawei.vm.virtualconnection.impl.VirtualConnectISO;
import java.security.SecureRandom;

public class MountThread
extends Thread {
    private ConnectModel conn = null;
    public boolean isStop = false;
    public boolean isComplete = false;
    public boolean mountRet = false;
    public boolean umountRet = false;
    private HWDiscoverModel snmpModel = null;
    private String mErrMsg;
    private String umErrMsg;

    public MountThread(ConnectModel conn, HWDiscoverModel snmpModel) {
        this.conn = conn;
        this.snmpModel = snmpModel;
    }

    @Override
    public void run() {
        if (this.conn.getConnType() == 0) {
            this.connectBySNMP();
        } else {
            this.connectByIPMI();
        }
    }

    private void connectBySNMP() {
        try {
            VirtualConnectIMG virtualConn = null;
            SetVmmKeyBySNMP newVmmKey = null;
            virtualConn = this.conn.getType() == 1 ? new VirtualConnectIMG() : new VirtualConnectISO();
            long vmmKey = this.conn.getVmmKey();
            String serverIp = this.conn.getServerIP();
            int serverPort = this.conn.getServerPort();
            String imagePath = this.conn.getImagePath();
            LogStreamManage.log("IP " + serverIp + ",file path:" + imagePath + "\n");
            LogStreamManage.log("Set vmm key,server port:" + serverPort + "\n");
            newVmmKey = new SetVmmKeyBySNMP(this.snmpModel, serverPort - 8500 + "");
            boolean ret = newVmmKey.execSNMPCommand();
            LogStreamManage.log("set vmm key,return:" + ret);
            if (!ret) {
                this.isComplete = true;
                return;
            }
            String vmmKeyStr = newVmmKey.getVmmKey();
            String hex20 = vmmKeyStr.substring(0, 40);
            String hex16 = vmmKeyStr.substring(40);
            byte[] hex16bytes = SetVmmKeyBySNMP.convertSecretKeyToBytes(hex16, 16);
            byte[] hex20bytes = SetVmmKeyBySNMP.convertSecretKeyToBytes(hex20, 20);
            GetVmmFlagBySNMP vmmFlagBySNMP = new GetVmmFlagBySNMP(this.snmpModel);
            vmmFlagBySNMP.setBladeNo(serverPort - 8500 + "");
            boolean flag = vmmFlagBySNMP.execSNMPCommand();
            int retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, hex20bytes, hex16bytes, true, flag, imagePath);
            if (0 != retCode1) {
                int retCode2 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, vmmKey, imagePath);
                this.isComplete = true;
                if (0 != retCode2) {
                    LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " connect error,errcode1:" + retCode1 + ", message:" + virtualConn.getErrMsg(retCode1) + "\n");
                    LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " connect error,errcode2:" + retCode2 + ", message:" + virtualConn.getErrMsg(retCode2) + "\n");
                    this.mErrMsg = virtualConn.getErrMsg(retCode1);
                    return;
                }
                this.mountRet = true;
                LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " create vmm success directly.\n");
            } else {
                this.isComplete = true;
                this.mountRet = true;
                LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " create vmm success encrypted.\n");
            }
            while (!this.isStop) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            int retCode = virtualConn.disconnect();
            if (0 != retCode) {
                LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " disconnect error,errcode:" + retCode + " ,message:" + virtualConn.getErrMsg(retCode) + "\n");
                this.umErrMsg = virtualConn.getErrMsg(retCode);
            } else {
                this.umountRet = true;
                LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " disconnect vmm success.\n");
            }
        }
        catch (Exception ex) {
            this.isComplete = true;
            this.umErrMsg = ex.toString();
            LogStreamManage.log(this.conn.getServerIP() + " blade" + this.conn.getBladeNO() + " connect vmm error.Errmsg:" + ex.getMessage() + "\n");
        }
    }

    private void connectByIPMI() {
        try {
            int retCode1;
            VirtualConnectIMG virtualConn = null;
            SetVmmKeyByIPMI newVmmKey = null;
            virtualConn = this.conn.getType() == 1 ? new VirtualConnectIMG() : new VirtualConnectISO();
            long vmmKey = this.conn.getVmmKey();
            String serverIp = this.conn.getServerIP();
            String imagePath = this.conn.getImagePath();
            GetVmmFlagByIPMI vmmFlagByIPMI = new GetVmmFlagByIPMI(this.snmpModel);
            int flag = vmmFlagByIPMI.getVmmFlag();
            LogStreamManage.log(flag + "\n");
            int serverPort = Integer.valueOf(this.conn.getVmmPort());
            LogStreamManage.log(serverPort + "\n");
            if (flag == 1 || flag == 2) {
                newVmmKey = new SetVmmKeyByIPMI(this.snmpModel, null);
                boolean ret = newVmmKey.execSNMPCommand();
                if (!ret) {
                    LogStreamManage.log("Set vmm key failed.\n");
                    Long id = this.getVerifyId();
                    retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, id, imagePath);
                } else {
                    String vmmKeyStr = newVmmKey.getVmmKey().replaceAll(" ", "").replaceAll("0x", "");
                    String hex20 = vmmKeyStr.substring(0, 40);
                    String hex16 = vmmKeyStr.substring(40);
                    byte[] hex16bytes = SetVmmKeyByIPMI.convertSecretKeyToBytes(hex16, 16);
                    byte[] hex20bytes = SetVmmKeyByIPMI.convertSecretKeyToBytes(hex20, 20);
                    boolean bSecret = 1 != flag;
                    retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, hex20bytes, hex16bytes, true, bSecret, imagePath);
                }
            } else {
                Long id = this.getVerifyId();
                newVmmKey = new SetVmmKeyByIPMI(this.snmpModel, id);
                boolean ret = newVmmKey.execSNMPCommand();
                if (!ret) {
                    LogStreamManage.log("Set vmm key failed.\n");
                }
                retCode1 = virtualConn.connect(this.conn.getType(), serverIp, serverPort, id, imagePath);
            }
            if (0 != retCode1) {
                this.isComplete = true;
                LogStreamManage.log(this.conn.getServerIP() + " connect error,errcode1:" + retCode1 + ", message:" + virtualConn.getErrMsg(retCode1) + "\n");
                this.mErrMsg = virtualConn.getErrMsg(retCode1);
                return;
            }
            this.isComplete = true;
            this.mountRet = true;
            LogStreamManage.log(this.conn.getServerIP() + " create vmm success encrypted.\n");
            while (!this.isStop) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            int retCode = virtualConn.disconnect();
            if (0 != retCode) {
                LogStreamManage.log(this.conn.getServerIP() + " disconnect error,errcode:" + retCode + " ,message:" + virtualConn.getErrMsg(retCode) + "\n");
                this.umErrMsg = virtualConn.getErrMsg(retCode);
            } else {
                this.umountRet = true;
                LogStreamManage.log(this.conn.getServerIP() + " disconnect vmm success.\n");
            }
        }
        catch (Exception ex) {
            this.isComplete = true;
            this.umErrMsg = "Mount failed:unknown error";
            LogStreamManage.log(this.conn.getServerIP() + " connect vmm error.Errmsg:" + ex.getMessage() + "\n");
        }
    }

    public String getMountErrMsg() {
        return this.mErrMsg;
    }

    public String getUmountErrMsg() {
        return this.umErrMsg;
    }

    public int getBladeNo() {
        return this.conn.getBladeNO();
    }

    private long getVerifyId() {
        SecureRandom random = new SecureRandom();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 7; ++i) {
            stringBuffer.append(random.nextInt(10));
        }
        return Long.parseLong(stringBuffer.toString());
    }
}

