/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.model;

import com.huawei.cdrommount.HWDiscover.manage.SNMPCommandBase;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import com.huawei.cdrommount.manage.LogStreamManage;
import java.security.SecureRandom;

public class SetVmmKeyBySNMP
extends SNMPCommandBase {
    private String keyOID = "1.3.6.1.4.1.2011.2.82.1.82.4.%s.2010.1.5.0";
    private String vmmKey = this.createVMMSecretCodeKey();
    private String serverSlot = "";
    private String hmmIP = "";
    private String hmmPwd;
    private static final int OXFF = 255;

    public SetVmmKeyBySNMP(HWDiscoverModel snmpModel, String slot) {
        super(snmpModel);
        this.serverSlot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execSNMPCommand() throws Exception {
        try {
            this.snmpBase = SNMPBase.SNMPCreate(this.snmpModel, this.snmpBase);
            this.snmpModel.setMsg("");
            this.snmpModel.setSNMPValueType(IPMIAndSNMPModel.SNMPSetValueType.OctetString);
            String keyOIDStr = String.format(this.keyOID, this.serverSlot);
            this.snmpModel.setSNMPSetValue(this.vmmKey);
            this.snmpBase.resetLocalEngine();
            String OIDValue = this.getOIDValue(keyOIDStr);
            if (null == OIDValue) {
                LogStreamManage.log(String.format("%s set key %s in slot %s failed, Error message:%s\n.", this.snmpModel.getIPAddress(), this.vmmKey, this.serverSlot, this.snmpModel.getMsg()));
                boolean bl = false;
                return bl;
            }
            LogStreamManage.log(String.format("%s set key in slot%s success.\n", this.snmpModel.getIPAddress(), this.serverSlot));
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LogStreamManage.log("Set vmm key failed.error message" + ex.getMessage() + "\n");
        }
        finally {
            this.snmpModel.setSNMPValueType(IPMIAndSNMPModel.SNMPSetValueType.None);
        }
        return false;
    }

    private String createVMMSecretCodeKey() {
        SecureRandom random = new SecureRandom();
        StringBuffer sb = new StringBuffer();
        int randomNum = 0;
        for (int i = 1; i <= 36; ++i) {
            randomNum = random.nextInt(94) + 32;
            String hexStr = Integer.toHexString(randomNum);
            sb.append(hexStr);
        }
        return sb.toString();
    }

    public static byte[] convertSecretKeyToBytes(String secretKey, int length) {
        String tmpHexstring = null;
        byte[] negotiatePass = new byte[length];
        for (int i = 0; i < length; ++i) {
            tmpHexstring = secretKey.substring(i * 2, i * 2 + 2);
            try {
                negotiatePass[i] = (byte)(Integer.parseInt(tmpHexstring, 16) & 0xFF);
                continue;
            }
            catch (NumberFormatException ex) {
                LogStreamManage.log("convertSecretKeyToBytes failed");
            }
        }
        return negotiatePass;
    }

    public String getVmmKey() {
        return this.vmmKey;
    }
}

