/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.storage.impl;

import com.huawei.vm.console.storage.impl.CDROMDriver;
import com.huawei.vm.console.utils.ImageIO;
import com.huawei.vm.console.utils.VMException;
import com.kvm.LogManager;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import java.util.Map;
import org.apache.log4j.Logger;

public class CDROMImage
extends CDROMDriver {
    private static Logger logger = LogManager.getInstance().getLogger(CDROMImage.class);
    private ImageIO image = new ImageIO();
    private ImageIO newImage = null;

    public CDROMImage(String path, boolean isMustExist) throws VMException {
        super(path);
        this.mustExist = isMustExist;
        this.image.open(this.deviceName, this.mustExist);
    }

    @Override
    protected void open(String path) throws VMException {
        this.image.open(path, this.mustExist);
    }

    @Override
    public void close() throws VMException {
        this.image.close();
    }

    @Override
    public void inquiry() {
    }

    @Override
    public int modeSense(byte[] dataBuffer, int pc, int pageCode) {
        dataBuffer[0] = 0;
        dataBuffer[1] = 6;
        dataBuffer[2] = 0 != this.testUnitReady() ? 1 : 112;
        dataBuffer[3] = 0;
        dataBuffer[4] = 0;
        dataBuffer[5] = 0;
        dataBuffer[6] = 0;
        dataBuffer[7] = 0;
        return 8;
    }

    @Override
    public int read(byte[] dataBuffer, long startPosition, int length) throws VMException {
        return this.image.read(dataBuffer, startPosition, length);
    }

    @Override
    public long getMediumSize() throws VMException {
        long result = this.image.getMediumSize();
        if (0L > result) {
            throw new VMException(253);
        }
        return result;
    }

    @Override
    public int readTOC(byte[] dataBuffer, boolean isMSF, int format, int startTrack) throws VMException {
        int totalBlocks = (int)(this.getMediumSize() / 2048L);
        double i = (double)totalBlocks / 75.0 + 2.0;
        int m = (int)i / 60;
        int s = (int)i % 60;
        int f = (int)((i - (double)((int)i)) * 75.0);
        int len = 4;
        if (0 == format) {
            if (startTrack > 1 && startTrack != 170) {
                throw new VMException(252);
            }
            dataBuffer[2] = 1;
            dataBuffer[3] = 1;
            if (startTrack <= 1) {
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 20;
                dataBuffer[len++] = 1;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = (byte)(isMSF ? 2 : 0);
                dataBuffer[len++] = 0;
            }
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 20;
            dataBuffer[len++] = -86;
            dataBuffer[len++] = 0;
            if (isMSF) {
                dataBuffer[len++] = 0;
                dataBuffer[len++] = (byte)m;
                dataBuffer[len++] = (byte)s;
                dataBuffer[len++] = (byte)f;
            } else {
                dataBuffer[len++] = (byte)(totalBlocks >> 24 & 0xFF);
                dataBuffer[len++] = (byte)(totalBlocks >> 16 & 0xFF);
                dataBuffer[len++] = (byte)(totalBlocks >> 8 & 0xFF);
                dataBuffer[len++] = (byte)(totalBlocks & 0xFF);
            }
        } else if (1 == format) {
            dataBuffer[2] = 1;
            dataBuffer[3] = 1;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
            dataBuffer[len++] = 0;
        } else if (2 == format) {
            dataBuffer[2] = 1;
            dataBuffer[3] = 1;
            for (int j = 0; j < 4; ++j) {
                dataBuffer[len++] = 1;
                dataBuffer[len++] = 20;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = j < 3 ? (byte)(160 + j) : (byte)1;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                if (j < 2) {
                    dataBuffer[len++] = 0;
                    dataBuffer[len++] = 1;
                    dataBuffer[len++] = 0;
                    dataBuffer[len++] = 0;
                    continue;
                }
                if (j == 2) {
                    if (isMSF) {
                        dataBuffer[len++] = 0;
                        dataBuffer[len++] = (byte)m;
                        dataBuffer[len++] = (byte)s;
                        dataBuffer[len++] = (byte)f;
                        continue;
                    }
                    dataBuffer[len++] = (byte)(totalBlocks >> 24 & 0xFF);
                    dataBuffer[len++] = (byte)(totalBlocks >> 16 & 0xFF);
                    dataBuffer[len++] = (byte)(totalBlocks >> 8 & 0xFF);
                    dataBuffer[len++] = (byte)(totalBlocks & 0xFF);
                    continue;
                }
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
                dataBuffer[len++] = 0;
            }
        } else {
            logger.info("Read TCO format 10 requested!");
            throw new VMException(252);
        }
        dataBuffer[0] = (byte)(len - 2 >> 8 & 0xFF);
        dataBuffer[1] = (byte)(len - 2 & 0xFF);
        return len;
    }

    @Override
    public void startStopUnit(boolean isEject, boolean isStart) throws VMException {
        if (isEject && !isStart) {
            this.isIsoDiskChanged = true;
            this.setDeviceState(0);
            this.needInit = false;
        } else if (isEject && isStart) {
            this.setDeviceState(3);
            this.needInit = true;
        } else {
            throw new VMException(252);
        }
    }

    @Override
    protected void prepareChangeDisk(String localDirName, Map<Long, UDFExtendFile> memoryStructMap, String diskName) throws VMException {
        this.newImage = new ImageIO();
        this.newImage.open(diskName, true);
    }

    @Override
    public void eject() {
        try {
            this.setDeviceState(0);
            this.deviceName = null;
            this.needInit = false;
            this.close();
        }
        catch (VMException e) {
            logger.error("Image file close fail!", e);
        }
    }

    @Override
    public void insert() throws VMException {
        if (null != this.newImage) {
            this.image = this.newImage;
            this.newImage = null;
            this.setDeviceState(0);
            this.deviceName = this.newDiskName;
            this.newDiskName = null;
        }
        this.needInit = true;
    }

    @Override
    public boolean preventAllowMediumRemoval(boolean isPrevent) {
        return true;
    }

    @Override
    public boolean isInited() {
        return this.image.isActive() || !this.needInit;
    }
}

