/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.Client;
import com.kvm.KVMException;
import com.kvm.KVMInterface;
import com.kvm.KVMUtil;
import com.kvm.LogManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class BladeCommu {
    private long disConnTime = 0L;
    private boolean isRequest = true;
    private KVMInterface kvmInterface = null;
    private static final int READ_SIZE = 4096;
    private static final int TIME_OUT = 20000;
    private static final int WAIT_TIME = 15000;
    private byte[] data = new byte[4096];
    private static final String NET_MESSAGE = "Blade_interrupt_message";
    private Client client = null;
    private int bladeNO = 0;
    private String ip = null;
    private int port = 0;
    private boolean isNew = false;
    private boolean isAutoFlag = true;
    public Socket socket;
    public BufferedOutputStream dout;
    public BufferedInputStream din;
    private Logger logger = LogManager.getInstance().getLogger(BladeCommu.class);

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public BladeCommu(String ip, int port) throws KVMException {
        long startTime = System.currentTimeMillis();
        try {
            this.ip = ip;
            this.port = port;
            if (Base.isProxy) {
                this.socket = KVMUtil.getProxySocket(this.getKvmInterface().base.parameterIP, 80, ip, this.port);
            } else {
                this.logger.info("not proxy");
                this.logger.info("port::" + this.port);
                this.logger.info("ip::" + this.ip);
                this.socket = new Socket(ip, port);
                this.logger.info("create socket success.");
            }
            this.socket.setSoTimeout(20000);
            this.socket.setTcpNoDelay(true);
            this.din = new BufferedInputStream(this.socket.getInputStream());
            this.dout = new BufferedOutputStream(this.socket.getOutputStream(), 1);
        }
        catch (IOException ioe) {
            this.logger.error("", ioe);
            long waitTime = System.currentTimeMillis() - startTime;
            if (waitTime < 15000L) {
                try {
                    Thread.sleep(15000L - waitTime);
                }
                catch (InterruptedException e) {
                    this.logger.error("", e);
                }
            }
            throw new KVMException(ioe.getMessage());
        }
        catch (URISyntaxException e) {
            this.logger.error("", e);
            long waitTime = System.currentTimeMillis() - startTime;
            if (waitTime < 15000L) {
                try {
                    Thread.sleep(15000L - waitTime);
                }
                catch (InterruptedException ie) {
                    this.logger.error("", ie);
                }
            }
            throw new KVMException(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("", e);
        }
    }

    public void reConnBlade(int reConnNum, int maxNum) throws KVMException {
        if (reConnNum > maxNum) {
            return;
        }
        try {
            if (null == this.ip) {
                return;
            }
            this.socket = new Socket(this.ip, this.port);
            this.socket.setSoTimeout(20000);
            this.socket.setTcpNoDelay(true);
            this.din = new BufferedInputStream(this.socket.getInputStream());
            this.dout = new BufferedOutputStream(this.socket.getOutputStream(), 1);
            this.dout.write(this.kvmInterface.packData.reConnectBlade(this.bladeNO, this.kvmInterface.kvmUtil.getImagePane((int)this.bladeNO).colorBit));
            this.sentData(this.kvmInterface.packData.mouseModeControl((byte)36, (byte)2, this.bladeNO));
        }
        catch (IOException ioe) {
            if (++reConnNum <= maxNum) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.reConnBlade(reConnNum, maxNum);
                return;
            }
            throw new KVMException(ioe.getMessage());
        }
    }

    public void sentData(byte[] bytes) {
        try {
            this.dout.write(bytes);
            this.dout.flush();
            this.client.sent += bytes.length;
        }
        catch (IOException ioe) {
            this.logger.error("", ioe);
        }
    }

    public byte[] getData() {
        try {
            int len = this.din.read(this.data);
            if (len < 4096) {
                if (len < 0) {
                    throw new IOException("Data's length is negative");
                }
                byte[] bytes = new byte[len];
                System.arraycopy(this.data, 0, bytes, 0, len);
                this.client.receive += len;
                return bytes;
            }
            this.client.receive += len;
            return this.data;
        }
        catch (IOException ex) {
            if (this.isAutoFlag) {
                if (this.kvmInterface.bladeList.size() == 1) {
                    if (this.isAutoFlag) {
                        try {
                            this.reConnBlade(1, 30);
                            int len = this.din.read(this.data);
                            if (len < 4096) {
                                if (len < 0) {
                                    throw new IOException("Data's length is negative");
                                }
                                byte[] bytes = new byte[len];
                                System.arraycopy(this.data, 0, bytes, 0, len);
                                this.client.receive += len;
                                return bytes;
                            }
                            this.client.receive += len;
                            return this.data;
                        }
                        catch (KVMException e) {
                        }
                        catch (IOException e) {}
                    }
                } else if (this.disConnTime == 0L) {
                    this.repeatConnBlade();
                } else {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (this.socket.isClosed() && this.client.socket.isConnected() && this.isRequest) {
                            this.client.sentData(this.kvmInterface.packData.reqBladeState(this.bladeNO, Base.connMode));
                            this.kvmInterface.clientSocket.bladeMap.put(String.valueOf(this.bladeNO), this.bladeNO);
                        }
                    }
                    catch (KVMException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                this.logger.error("", e1);
            }
            this.closeBladePanelGet();
            return null;
        }
    }

    private void closeBladePanelSend() {
        this.client.kvmInterface.tabbedpane.getModel().removeChangeListener(this.client.kvmInterface.kvmUtil.changeListener);
        if (this.client.kvmInterface.isFullScreen) {
            this.client.kvmInterface.kvmUtil.returnToWin();
        }
        this.client.kvmInterface.kvmUtil.disconnectBlade(this.bladeNO);
        this.client.kvmInterface.tabbedpane.getModel().addChangeListener(this.client.kvmInterface.kvmUtil.changeListener);
        JOptionPane.showMessageDialog(this.client.kvmInterface.toolbar, this.client.kvmInterface.kvmUtil.getString(NET_MESSAGE));
    }

    private void closeBladePanelGet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] repeatConnBlade() {
        this.disConnTime = System.currentTimeMillis();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.error("", e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error("", e);
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            this.client.sentData(this.kvmInterface.packData.reqBladeState(this.bladeNO, Base.connMode));
            this.kvmInterface.clientSocket.bladeMap.put(String.valueOf(this.bladeNO), this.bladeNO);
        }
        catch (KVMException e) {
            return null;
        }
        return null;
    }

    public int getBladeNO() {
        return this.bladeNO;
    }

    public void setBladeNO(int bladeNO) {
        this.bladeNO = bladeNO;
    }

    public boolean isAutoFlag() {
        return this.isAutoFlag;
    }

    public void setAutoFlag(boolean isAutoFlag) {
        this.isAutoFlag = isAutoFlag;
    }

    public Client getClient() {
        return this.client;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}

