/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.KVMUtil;
import com.kvm.LogManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class CopyFileToLocal {
    private static Logger logger = LogManager.getInstance().getLogger(CopyFileToLocal.class);

    public static boolean libarayPrepare() {
        File file1;
        String libName = "unknown";
        String sourceLibName = "unknown";
        String separator = System.getProperty("file.separator");
        String libDir = System.getProperty("java.io.tmpdir");
        boolean libraryInstall = false;
        Base.libID = System.identityHashCode(System.currentTimeMillis());
        if (KVMUtil.isWindowsOS()) {
            libName = Base.MOUSE_LIB + Base.libID + ".dll";
            sourceLibName = "com/kvm/" + Base.MOUSE_LIB + ".dll";
        } else if (KVMUtil.isOsArchByName("x86_64") || KVMUtil.isOsArchByName("amd64")) {
            libName = "libkeyboard_encrypt" + Base.libID + ".so";
            sourceLibName = "com/kvm/libkeyboard_encrypt_64.so";
        } else if (KVMUtil.isOsArchByName("i386")) {
            libName = "libkeyboard_encrypt" + Base.libID + ".so";
            sourceLibName = "com/kvm/libkeyboard_encrypt_32.so";
        } else {
            return false;
        }
        if (!libDir.endsWith(separator)) {
            libDir = libDir + separator;
        }
        libraryInstall = (file1 = new File(libDir = libDir + libName)).exists() ? true : CopyFileToLocal.makeLibaray(sourceLibName, libDir);
        return libraryInstall;
    }

    public static void cleanLib() {
        String libName = "unknown";
        String libExt = "unknown";
        String separator = System.getProperty("file.separator");
        String libDir = System.getProperty("java.io.tmpdir");
        if (KVMUtil.isWindowsOS()) {
            libName = Base.MOUSE_LIB;
            libExt = ".dll";
        } else if (KVMUtil.isLinuxOS()) {
            libName = "libkeyboard_encrypt";
            libExt = ".so";
        } else {
            return;
        }
        File file = new File(libDir);
        if (!libDir.endsWith(separator)) {
            libDir = libDir + separator;
        }
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].startsWith(libName) || !files[i].endsWith(libExt)) continue;
            new File(libDir + files[i]).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean makeLibaray(String source, String dest) {
        ClassLoader classloader = CopyFileToLocal.class.getClassLoader();
        byte[] buffer = new byte[4096];
        if (classloader.getResource(source) == null) {
            return false;
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = classloader.getResourceAsStream(source);
            fileOutputStream = new FileOutputStream(dest);
            int i = inputStream.read(buffer, 0, buffer.length);
            while (i != -1) {
                fileOutputStream.write(buffer, 0, i);
                i = inputStream.read(buffer, 0, buffer.length);
            }
            return true;
        }
        catch (IOException e) {
            logger.error("", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("Console Controller:input stream close error when make lib", e);
            }
            finally {
                try {
                    if (null != fileOutputStream) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Console Controller:Output steam close error when make lib", e);
                }
            }
        }
    }
}

