/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Client;
import com.kvm.KVMInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final StatusPane recevieStatus = new StatusPane(120, 20);
    private final StatusPane sentStatus = new StatusPane(100, 20);
    private final StatusPane frameNumber = new StatusPane(100, 20);
    public Timer dataStaTimer = null;
    public int frameNum = 0;
    public Client client = null;
    private KVMInterface.ToolBarPanel toolBarPanel = null;

    public StatusBar(String str) {
        JLabel lable = new JLabel(str);
        Font font = new Font("Serief", 1, 12);
        lable.setFont(font);
        lable.setForeground(Color.BLUE);
        this.setLayout(new FlowLayout(0, 5, 3));
        this.add(lable);
        this.add(this.recevieStatus);
        this.add(this.sentStatus);
        this.add(this.frameNumber);
        this.setVisible(true);
        this.setStatus();
    }

    public final void setStatus() {
        int delay = 1000;
        this.dataStaTimer = new Timer("DataStaTimer", true);
        this.dataStaTimer.scheduleAtFixedRate((TimerTask)new DataStaTimer(), delay * 5, (long)delay);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.toolBarPanel.repaint();
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setToolBarPanel(KVMInterface.ToolBarPanel toolBarPanel) {
        this.toolBarPanel = toolBarPanel;
    }

    class StatusPane
    extends JLabel {
        public StatusPane(int length, int width) {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.black);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(length, width));
        }
    }

    class DataStaTimer
    extends TimerTask {
        DataStaTimer() {
        }

        @Override
        public void run() {
            StatusBar.this.recevieStatus.setText("Received:" + StatusBar.this.client.receive);
            StatusBar.this.sentStatus.setText("Sent:" + StatusBar.this.client.sent);
            StatusBar.this.frameNumber.setText("FrameNum:" + StatusBar.this.frameNum);
            StatusBar.this.client.receive = 0;
            StatusBar.this.client.sent = 0;
            StatusBar.this.frameNum = 0;
        }
    }
}

