/*
 * Decompiled with CFR 0.152.
 */
package com.kvm.decoder;

import java.awt.Color;

public class ColorConverter {
    public static byte[] rgb2yuv(int R, int G, int B) {
        byte[] yuv = new byte[]{(byte)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B), (byte)(-0.147 * (double)R - 0.289 * (double)G + 0.437 * (double)B), (byte)(0.615 * (double)R - 0.515 * (double)G - 0.1 * (double)B)};
        System.out.printf("yuv(%02x,%02x,%02x)\n", yuv[0], yuv[1], yuv[2]);
        return yuv;
    }

    public static byte[] yuv2rgb(int y, int u, int v) {
        byte[] rgb = new byte[3];
        int R = (int)((double)y + 1.14 * (double)v);
        int G = (int)((double)y - 0.394 * (double)u - 0.581 * (double)v);
        int B = (int)((double)y + 2.028 * (double)u);
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        rgb[0] = (byte)R;
        rgb[0] = (byte)G;
        rgb[0] = (byte)B;
        return rgb;
    }

    public static byte rgb888Tobgr233(byte r, byte g, byte b) {
        byte bgr233 = 0;
        bgr233 = (byte)(b & 0xC0 | g & 0xE0 | r & 0xE0);
        return bgr233;
    }

    public static byte yuv2bgr233(byte y, byte u, byte v) {
        byte bgr233 = 0;
        byte R = (byte)((double)y + 1.14 * (double)v);
        byte G = (byte)((double)y - 0.394 * (double)u - 0.581 * (double)v);
        byte B = (byte)((double)y + 2.028 * (double)u);
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (R > 255) {
            R = -1;
        }
        if (G > 255) {
            G = -1;
        }
        if (B > 255) {
            B = -1;
        }
        bgr233 = (byte)(B & 0xC0 | G & 0xE0 | R & 0xE0);
        System.out.printf("yuv(%02x,%02x,%02x)--rgb(%02x,%02x,%02x)--bgr233(%02x)", y, u, v, R, G, B, bgr233);
        ColorConverter.rgb2yuv(255, 0, 0);
        return bgr233;
    }

    public static int[] rgb2ycbcr(int R, int G, int B) {
        int[] ycbcr = new int[]{(int)(0.257 * (double)R + 0.504 * (double)G + 0.098 * (double)B + 16.0), (int)(-0.148 * (double)R - 0.291 * (double)G + 0.439 * (double)B + 128.0), (int)(0.439 * (double)R - 0.368 * (double)G - 0.071 * (double)B + 128.0)};
        if (ycbcr[1] > 255) {
            ycbcr[1] = 255;
        }
        if (ycbcr[2] > 255) {
            ycbcr[2] = 255;
        }
        System.out.printf("yuv(%02x,%02x,%02x)", ycbcr[0], ycbcr[1], ycbcr[2]);
        return ycbcr;
    }

    public static Color ycbcr2rgbIscolor(int Y, int Cb, int Cr) {
        int R = (int)(1.164 * (double)((Y &= 0xFF) - 16) + 1.596 * (double)((Cr &= 0xFF) - 128));
        int G = (int)(1.164 * (double)(Y - 16) - 0.813 * (double)(Cr - 128) - 0.392 * (double)((Cb &= 0xFF) - 128));
        int B = (int)(1.164 * (double)(Y - 16) + 2.017 * (double)(Cb - 128));
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        Color rgb = new Color(R, G, B);
        return rgb;
    }

    public static int ycbcr2rgb(int Y, int Cb, int Cr) {
        int R = (int)((double)(Y &= 0xFF) + 1.402 * (double)((Cr &= 0xFF) - 128));
        int G = (int)((double)Y - 0.34414 * (double)((Cb &= 0xFF) - 128) - 0.71414 * (double)(Cr - 128));
        int B = (int)((double)Y + 1.772 * (double)(Cb - 128));
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        int rgb = R << 16 | G << 8 | B;
        return rgb;
    }

    public static byte ycbcr2rgb332(int Y, int Cb, int Cr) {
        byte bgr233 = 0;
        int R = (int)(1.164 * (double)((Y &= 0xFF) - 16) + 1.596 * (double)(Math.abs(Cr &= 0xFF) - 128));
        int G = (int)(1.164 * (double)(Y - 16) - 0.813 * (double)(Cr - 128) - 0.392 * (double)((Cb &= 0xFF) - 128));
        int B = (int)(1.164 * (double)(Y - 16) + 2.017 * (double)(Cb - 128));
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        bgr233 = (byte)(B & 0xC0 | (G & 0xE0) >> 2 | (R & 0xE0) >> 5);
        System.out.printf("\n yuv(%02x,%02x,%02x|%d)--rgb(%d|%02x,%02x,%02x)--bgr233(%02x) -%02x %02x \n", Y, Cb, Cr, Cr, R, R, G, B, bgr233, (R & 0xE0) >> 5, R & 0xE0);
        return bgr233;
    }
}

