/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover.common;

import com.huawei.cdrommount.HWDiscover.common.HWDiscoverEnum;
import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.HWDiscover.common.SSHDicover;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import com.huawei.cdrommount.common.ssh.Shell;

public class SNMPDicover {
    private Logger logger = new Logger(SNMPDicover.class);
    public HWDiscoverModel snmpModel = null;
    private SNMPBase snmpBase = null;

    public SNMPDicover(HWDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discover() throws Exception {
        Shell shell = null;
        try {
            if (this.snmpModel.getVersion() != IPMIAndSNMPModel.SNMPVersion.V3) {
                this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V2C.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V2c);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V1.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V1);
                    boolean bl = true;
                    return bl;
                }
                if (this.snmpModel.getUserName().indexOf(" ") > -1) {
                    this.snmpModel.setMsg(MessageDescription.UserNameHasSpace);
                    boolean bl = false;
                    return bl;
                }
                shell = SSHDicover.getShell(this.snmpModel);
                if (null == shell) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V3.name());
            if (this.snmpModel.getLastDiscoverType() == 0) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.MD5.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.DES.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(1);
            }
            if (this.snmpModel.getLastDiscoverType() == 1) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.SHA.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.AES.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(2);
            }
            if (this.snmpModel.getLastDiscoverType() == 2) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.MD5.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.AES.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(3);
            }
            if (this.snmpModel.getLastDiscoverType() == 3) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.SHA.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.DES.name());
                if (this.getServerInfo()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(4);
            }
        }
        catch (Exception ex) {
            if (!UMateException.SameNameDiffOtherInfo.equals(ex.getMessage())) {
                this.logger.error(ex);
            }
            this.snmpModel.setMsg(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (shell != null) {
                shell.disconnect();
            }
        }
        return true;
    }

    private boolean getServerInfo() throws Exception {
        try {
            String OIDValue = "";
            this.snmpBase = SNMPBase.SNMPCreate(this.snmpModel, this.snmpBase);
            if (this.findServer(HWDiscoverEnum.ServerOIDEnum.product_name)) {
                this.snmpModel.setProductType(HWDiscoverEnum.ProductType.Common);
                OIDValue = this.getOIDValue(HWDiscoverEnum.ServerOIDEnum.serialNumber);
                this.snmpModel.setSerialNumber(OIDValue);
                OIDValue = this.getOIDValue(HWDiscoverEnum.ServerOIDEnum.systemHealth);
                OIDValue = HWDiscoverEnum.commonBundle.getValue(HWDiscoverEnum.ServerOIDEnum.systemHealth.name() + "_" + OIDValue);
                this.snmpModel.setHealth(OIDValue);
                boolean bl = true;
                return bl;
            }
            if (MessageDescription.SNMPConfigError.equals(this.snmpModel.getMsg())) {
                boolean bl = false;
                return bl;
            }
            if (this.findServer(HWDiscoverEnum.E6000ServerOIDEnum.E6000_product_name)) {
                this.snmpModel.setProductType(HWDiscoverEnum.ProductType.E6000);
                OIDValue = this.getOIDValue(HWDiscoverEnum.E6000ServerOIDEnum.E6000_serialNumber);
                this.snmpModel.setSerialNumber(OIDValue);
                OIDValue = this.getOIDValue(HWDiscoverEnum.E6000ServerOIDEnum.E6000_systemHealth);
                OIDValue = HWDiscoverEnum.commonBundle.getValue(HWDiscoverEnum.E6000ServerOIDEnum.E6000_systemHealth.name() + "_" + OIDValue);
                this.snmpModel.setHealth(OIDValue);
                boolean bl = true;
                return bl;
            }
            if (MessageDescription.SNMPConfigError.equals(this.snmpModel.getMsg())) {
                boolean bl = false;
                return bl;
            }
            if (this.findServer(HWDiscoverEnum.E9000ServerOIDEnum.E9000_product_name) || this.findServer(HWDiscoverEnum.E9000ServerOIDEnum.E9000_MM_ShelfSN)) {
                this.snmpModel.setProductType(HWDiscoverEnum.ProductType.E9000);
                OIDValue = this.getOIDValue(HWDiscoverEnum.E9000ServerOIDEnum.E9000_serialNumber);
                this.snmpModel.setSerialNumber(OIDValue);
                OIDValue = this.getOIDValue(HWDiscoverEnum.E9000ServerOIDEnum.E9000_systemHealth);
                OIDValue = HWDiscoverEnum.commonBundle.getValue(HWDiscoverEnum.E9000ServerOIDEnum.E9000_systemHealth.name() + "_" + OIDValue);
                this.snmpModel.setHealth(OIDValue);
                boolean bl = true;
                return bl;
            }
            if (MessageDescription.NotHuaweiServerError.equals(this.snmpModel.getMsg())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            if (UMateException.SameNameDiffOtherInfo.equals(ex.getMessage())) {
                throw new UMateException(UMateException.SameNameDiffOtherInfo);
            }
            if (ex.getMessage().indexOf(MessageDescription.PWDLengthError) > -1) {
                throw new UMateException(MessageDescription.PWDLengthShowError);
            }
            this.snmpModel.setMsg(ex.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != this.snmpBase) {
                this.snmpBase.SNMPClose();
            }
        }
        return false;
    }

    private boolean findServer(Enum serverOIDEnum) throws Exception {
        String systemOID = HWDiscoverEnum.commonBundle.getValue(serverOIDEnum);
        String GetOIDValue = this.snmpBase.GetOIDValue(systemOID);
        if ("Request timeout.".equals(GetOIDValue)) {
            this.snmpModel.setMsg(MessageDescription.SNMPConfigError);
            return false;
        }
        if (GetOIDValue.startsWith("noSuch")) {
            this.snmpModel.setMsg(MessageDescription.NotHuaweiServerError);
            return false;
        }
        this.snmpModel.setIsFind(true);
        if (HWDiscoverEnum.E9000ServerOIDEnum.E9000_MM_ShelfSN == serverOIDEnum) {
            this.snmpModel.setProductName("MM910");
        } else {
            this.snmpModel.setProductName(GetOIDValue);
        }
        return true;
    }

    public String getOIDValue(Enum serverOIDEnum) throws Exception {
        String systemOID = HWDiscoverEnum.commonBundle.getValue(serverOIDEnum);
        String GetOIDValue = this.snmpBase.GetOIDValue(systemOID);
        if (!"Request timeout.".equals(GetOIDValue) && !GetOIDValue.startsWith("noSuch")) {
            return GetOIDValue;
        }
        return null;
    }
}

