/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover.manage;

import com.huawei.cdrommount.HWDiscover.common.HWDiscoverEnum;
import com.huawei.cdrommount.HWDiscover.manage.SNMPCommandBase;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetVersionBySNMP
extends SNMPCommandBase {
    private Logger logger = new Logger(GetVersionBySNMP.class);

    public GetVersionBySNMP(HWDiscoverModel snmpModel) {
        super(snmpModel);
    }

    @Override
    public boolean execSNMPCommand() throws Exception {
        switch (this.snmpModel.getProductType()) {
            case Common: {
                return this.getCommonServerVersion();
            }
            case E6000: 
            case E9000: {
                return this.getMMServerVersion();
            }
        }
        return true;
    }

    private boolean getCommonServerVersion() throws Exception {
        this.snmpBase = SNMPBase.SNMPCreate(this.snmpModel, this.snmpBase);
        String version = this.getOIDValue(HWDiscoverEnum.commonBundle.getValue((Object)HWDiscoverEnum.CommonVersionOID.BIOSVersion));
        if (null == version) {
            this.snmpModel.setMsg("Get firmware version by SNMP error.");
            this.logger.info(this.snmpModel.getIPAddress() + " get firmware version by SNMP error.");
            return false;
        }
        this.snmpModel.setBIOSVersion(version);
        version = this.getOIDValue(HWDiscoverEnum.commonBundle.getValue((Object)HWDiscoverEnum.CommonVersionOID.AiBMCVersion));
        if (version == null) {
            this.snmpModel.setMsg("");
            version = this.getOIDValue(HWDiscoverEnum.commonBundle.getValue((Object)HWDiscoverEnum.CommonVersionOID.AiBMC2Version));
        }
        this.snmpModel.setBMCVersion(version);
        version = this.getOIDValue(HWDiscoverEnum.commonBundle.getValue((Object)HWDiscoverEnum.CommonVersionOID.CPLDVersion));
        this.snmpModel.setCPLDVersion(version);
        return true;
    }

    private boolean getMMServerVersion() throws Exception {
        this.snmpBase = SNMPBase.SNMPCreate(this.snmpModel, this.snmpBase);
        String version = this.getOIDValue(HWDiscoverEnum.commonBundle.getValue((Object)HWDiscoverEnum.CommonVersionOID.MMSoftware));
        if (null == version) {
            this.snmpModel.setMsg("Get firmware version by SNMP error.");
            this.logger.info(this.snmpModel.getIPAddress() + " get firmware version by SNMP error.");
            return false;
        }
        this.snmpModel.setSoftware(GetVersionBySNMP.getFWVersion("Software *Version[ ().:-_\\w\\u4e00-\\u9fa5]*", version));
        this.snmpModel.setCPLDVersion(GetVersionBySNMP.getFWVersion("CPLD *Version[ ().:-_\\w\\u4e00-\\u9fa5]*", version));
        return true;
    }

    public static String getFWVersion(String pattern, String version) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(version);
        if (m.find()) {
            String software = m.group(0);
            int index = software.indexOf(":");
            if (index > -1) {
                software = software.substring(index + 1);
            }
            if ((index = software.indexOf(")")) > -1) {
                software = software.substring(index + 1);
            }
            return software.trim();
        }
        return "";
    }
}

