/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.snmp;

import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import java.io.IOException;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPV2c
extends SNMPBase {
    private Logger logger = new Logger(SNMPV2c.class);
    private PDU pdu = null;
    private Snmp snmp = null;
    private CommunityTarget target = null;
    private ResponseEvent response = null;

    public SNMPV2c(IPMIAndSNMPModel snmpModel) throws IOException {
        this.snmpMudel = snmpModel;
        this.pdu = new PDU();
        this.pdu.add(new VariableBinding(new OID(this.snmpMudel.getOID())));
        this.pdu.setType(-95);
        this.target = new CommunityTarget();
        this.target.setRetries(0);
        this.target.setTimeout(10000L);
        this.target.setCommunity(new OctetString(this.snmpMudel.getCommunity()));
        this.target.setAddress(GenericAddress.parse((String)(this.snmpMudel.getTransmitType() + ":" + this.snmpMudel.getIPAddress() + "/" + this.snmpMudel.getSNMPPort())));
        if (this.snmpMudel.getVersion() == IPMIAndSNMPModel.SNMPVersion.V2C) {
            this.target.setVersion(1);
        } else {
            this.target.setVersion(0);
        }
        this.snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        this.snmp.listen();
    }

    @Override
    public String GetOIDValue(String OID2, boolean canCounter) throws Exception {
        this.pdu.clear();
        if (this.snmpMudel.getSNMPValueType() == IPMIAndSNMPModel.SNMPSetValueType.None) {
            this.pdu.setType(-96);
            this.pdu.add(new VariableBinding(new OID(OID2)));
        } else {
            this.pdu.setType(-93);
            this.pdu.add(new VariableBinding(new OID(OID2), this.getSetValue()));
        }
        this.pdu.add(new VariableBinding(new OID(OID2)));
        this.response = this.snmp.send(this.pdu, (Target)this.target);
        if (this.response.getResponse() == null) {
            this.logger.info(String.format("%s %s timeout.", this.snmpMudel.getIPAddress(), OID2));
            return "Request timeout.";
        }
        VariableBinding get = this.response.getResponse().get(0);
        if (!canCounter && get.getVariable().getSyntaxString().equals("Counter")) {
            this.logger.info(String.format("%s %s  no such object.", this.snmpMudel.getIPAddress(), OID2));
            return "noSuchObject";
        }
        return get.getVariable().toString();
    }

    @Override
    public String GetOIDNextValue(String OID2) throws Exception {
        this.pdu.setType(-95);
        this.pdu.clear();
        this.pdu.add(new VariableBinding(new OID(OID2)));
        this.response = this.snmp.send(this.pdu, (Target)this.target);
        if (this.response.getResponse() == null) {
            return "Request timeout.";
        }
        VariableBinding get = this.response.getResponse().get(0);
        return get.getOid() + "=" + get.getVariable();
    }

    @Override
    public String GetOIDWalkValue(String OID2) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void SNMPClose() {
        if (null != this.snmp) {
            try {
                this.snmp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean resetLocalEngine() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

