/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.ssh;

import com.huawei.cdrommount.common.GlobalStaticValue;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import expect4j.Closure;
import expect4j.Expect4j;
import expect4j.ExpectState;
import expect4j.matches.EofMatch;
import expect4j.matches.Match;
import expect4j.matches.RegExpMatch;
import expect4j.matches.TimeoutMatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Shell {
    private com.huawei.cdrommount.common.log.Logger logger = new com.huawei.cdrommount.common.log.Logger(Shell.class);
    private Session session;
    private ChannelShell channel;
    private ChannelSftp sftpChannel;
    private Expect4j expect = null;
    private static final long defaultTimeOut = 1000L;
    private StringBuffer buffer = new StringBuffer();
    public static final int COMMAND_EXECUTION_SUCCESS_OPCODE = -2;
    public static final String BACKSLASH_R = "\r";
    public static final String BACKSLASH_N = "\n";
    public static final String COLON_CHAR = ":";
    public static String ENTER_CHARACTER = "\r";
    public static String lastCmd = "zzzzxxxxxyyyyyttttttzzzz";
    public static String[] linuxPromptRegEx = new String[]{lastCmd};
    public static String[] errorMsg = new String[]{"could not acquire the config lock "};
    private String ip;
    private int port;
    private String user;
    private String password;
    private IPMIAndSNMPModel snmpMudel = null;

    public Shell(IPMIAndSNMPModel snmpMudel) throws Exception {
        this.snmpMudel = snmpMudel;
        Logger.getLogger("expect4j").setLevel(Level.OFF);
        this.ip = snmpMudel.getIPAddress();
        this.port = Integer.parseInt(snmpMudel.getSSHPort());
        this.user = snmpMudel.getUserName();
        this.password = snmpMudel.getUserPassword();
        this.expect = this.getExpect();
    }

    public void disconnect() throws IOException, InterruptedException {
        if (this.channel != null) {
            this.channel.getOutputStream().close();
            this.channel.getInputStream().close();
            this.channel.disconnect();
        }
        if (this.sftpChannel != null) {
            this.sftpChannel.exit();
            this.sftpChannel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        if (null != this.expect) {
            this.expect.close();
        }
    }

    public String getResponse() {
        String result = this.buffer.toString();
        this.buffer.setLength(0);
        return result.replaceAll(lastCmd, "");
    }

    private Expect4j getExpect() throws Exception {
        JSch jsch = new JSch();
        this.session = jsch.getSession(this.user, this.ip, this.port);
        this.session.setPassword(this.password.getBytes());
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.connect(GlobalStaticValue.session_connect_timeout);
        this.channel = (ChannelShell)this.session.openChannel("shell");
        Expect4j expect4j = new Expect4j(this.channel.getInputStream(), this.channel.getOutputStream());
        this.channel.connect();
        this.sftpChannel = (ChannelSftp)this.session.openChannel("sftp");
        this.sftpChannel.connect();
        return expect4j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean executeCommands(String[] commands) throws Exception {
        if (this.expect == null) {
            return false;
        }
        this.buffer.setLength(0);
        Closure closure = new Closure(){

            public void run(ExpectState expectState) throws Exception {
                Shell.this.buffer.append(expectState.getBuffer());
                expectState.exp_continue();
            }
        };
        ArrayList<Match> lstPattern = new ArrayList<Match>();
        String[] regEx = linuxPromptRegEx;
        if (regEx != null && regEx.length > 0) {
            String[] stringArray = regEx;
            // MONITORENTER : regEx
            for (String regexElement : regEx) {
                try {
                    RegExpMatch mat = new RegExpMatch(regexElement, closure);
                    lstPattern.add((Match)mat);
                }
                catch (Exception e) {
                    // MONITOREXIT : stringArray
                    return false;
                }
            }
            lstPattern.add((Match)new EofMatch(new Closure(){

                public void run(ExpectState state) {
                }
            }));
            lstPattern.add((Match)new TimeoutMatch(1000L, new Closure(){

                public void run(ExpectState state) {
                }
            }));
            // MONITOREXIT : stringArray
        }
        boolean isSuccess = true;
        for (String strCmd : commands) {
            this.cmdIsSuccess(lstPattern, strCmd);
        }
        this.cmdIsSuccess(lstPattern, "echo " + lastCmd);
        isSuccess = !this.checkResult(this.expect.expect(lstPattern));
        String response = this.buffer.toString().toLowerCase();
        String[] stringArray = errorMsg;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            if (response.indexOf(msg) > -1) {
                return false;
            }
            ++n2;
        }
        return isSuccess;
    }

    private boolean cmdIsSuccess(List<Match> objPattern, String strCommandPattern) {
        try {
            boolean isFailed = this.checkResult(this.expect.expect(objPattern));
            if (!isFailed) {
                this.expect.send(strCommandPattern);
                this.expect.send(ENTER_CHARACTER);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean checkResult(int intRetVal) {
        return intRetVal == -2;
    }

    public void upload(String directory, String uploadFile, boolean overwrite) throws Exception {
        FileInputStream inputStream = null;
        try {
            this.sftpChannel.cd(directory);
            File file = new File(uploadFile);
            inputStream = new FileInputStream(file);
            if (overwrite) {
                this.sftpChannel.put((InputStream)inputStream, file.getName(), 0);
            } else {
                this.sftpChannel.put((InputStream)inputStream, file.getName());
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new UMateException("Upload file to device fail, please check space is enough or not.");
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String targetFile, String uploadFile, boolean overwrite) throws Exception {
        FileInputStream inputStream = null;
        try {
            File tFile = new File(targetFile);
            if (tFile.getParentFile() != null) {
                String path = tFile.getParentFile().getPath();
                path = path.replace("\\", "/");
                this.sftpChannel.cd(path);
            }
            File file = new File(uploadFile);
            inputStream = new FileInputStream(file);
            if (overwrite) {
                this.sftpChannel.put((InputStream)inputStream, tFile.getName(), 0);
            } else {
                this.sftpChannel.put((InputStream)inputStream, tFile.getName());
            }
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String directory, String downloadFile, String saveFile) throws Exception {
        FileOutputStream outStream = null;
        try {
            this.sftpChannel.cd(directory);
            File file = new File(saveFile);
            outStream = new FileOutputStream(file);
            this.sftpChannel.get(downloadFile, (OutputStream)outStream);
            outStream.flush();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public void delete(String directory, String deleteFile, boolean throwException) throws Exception {
        block2: {
            try {
                this.sftpChannel.cd(directory);
                this.sftpChannel.rm(deleteFile);
            }
            catch (Exception exp) {
                if (!throwException) break block2;
                throw exp;
            }
        }
    }

    public List listFiles(String directory, String regex) throws Exception {
        if (null == regex || "".equals(regex.trim())) {
            return this.listFiles(directory);
        }
        regex = regex.trim();
        ArrayList<String> result = new ArrayList<String>();
        Vector fileList = this.sftpChannel.ls(directory);
        for (ChannelSftp.LsEntry entry : fileList) {
            if (!entry.getFilename().toLowerCase().endsWith(regex.toLowerCase())) continue;
            result.add(entry.getFilename());
        }
        return result;
    }

    public List listFiles(String directory) throws Exception {
        return this.sftpChannel.ls(directory);
    }

    public List listFilesNoException(String directory) throws Exception {
        try {
            return this.sftpChannel.ls(directory);
        }
        catch (Exception ex) {
            this.logger.info(String.format("%s sftp error, msg:%s", this.snmpMudel.getIPAddress(), ex.getMessage()));
            return null;
        }
    }

    public void mkdir(String directory) {
        try {
            this.sftpChannel.mkdir(directory);
        }
        catch (SftpException sftpException) {
            // empty catch block
        }
    }

    public ChannelShell getChannel() {
        return this.channel;
    }

    public ChannelSftp getSftpChannel() {
        return this.sftpChannel;
    }
}

