/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.manage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogStreamManage {
    private static OutputStream outStream = null;
    private static SimpleDateFormat simpleDateFormat = null;

    public static synchronized void openStream() {
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
        File orderFile = new File("log/connect.log");
        if (null != orderFile.getParentFile() && !orderFile.getParentFile().exists()) {
            orderFile.getParentFile().mkdirs();
        }
        try {
            outStream = new FileOutputStream(orderFile, true);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static synchronized void closeStream() {
        try {
            outStream.flush();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (null != outStream) {
                try {
                    outStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static synchronized void log(String msg) {
        try {
            msg = simpleDateFormat.format(new Date()) + msg;
            System.out.println(msg);
            outStream.write(msg.getBytes(Charset.forName("UTF-8")));
            outStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized void error(Exception msg) {
        try {
            msg.printStackTrace();
            outStream.write(msg.getMessage().getBytes(Charset.forName("UTF-8")));
            outStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

