/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.manage;

import com.huawei.cdrommount.manage.LogStreamManage;
import com.huawei.cdrommount.model.ConnectModel;
import java.util.LinkedHashMap;

public class ParameterCheckManage {
    private void help() {
        String printStr = "Usage: CDROMMount serverIP imagePath HMMUser HMMPwd AuthenticationProtocol PrivacyProtocol bladeNO SNMPPort SNMPVer\r\nserverIP:IP address of the target server\r\nimagePath:CD image path, the path can not have spaces\r\nHMMUser:HMM user name\r\nHMMPwd:HMM user password\r\nAuthenticationProtocol:HMM authentication protocol\r\nPrivacyProtocol:HMM privacy protocol\r\nbladeNO:Blade number,Example:1 1,2,3 1,3  all\r\nSNMPPort:Snmp port,default:161\r\nSNMPVer:Snmp version,default:V3\r\n";
        System.out.println(printStr);
    }

    public LinkedHashMap<String, ConnectModel> check(String[] args) {
        if (args.length != 9 && args.length != 6 && args.length != 7 && args.length != 10) {
            LogStreamManage.log("Parameter error.");
            this.help();
            return null;
        }
        String authProtocol = "";
        String privacyProtocol = "";
        String bladeNO = "";
        String snmpPort = "";
        String snmpVer = "";
        String vmmPort = "";
        String ipmiPort = "";
        String fileType = "2";
        String serverIP = args[0];
        String imagePath = args[1];
        String hmmUser = args[2];
        String hmmPwd = args[3];
        if (args.length == 9) {
            authProtocol = args[4];
            privacyProtocol = args[5];
            bladeNO = args[6];
            snmpPort = args[7];
            snmpVer = args[8];
        } else if (args.length == 10) {
            authProtocol = args[4];
            privacyProtocol = args[5];
            bladeNO = args[6];
            snmpPort = args[7];
            snmpVer = args[8];
            fileType = args[9];
        } else if (args.length == 6) {
            vmmPort = args[4];
            ipmiPort = args[5];
        } else if (args.length == 7) {
            vmmPort = args[4];
            ipmiPort = args[5];
            fileType = args[6];
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        if (!serverIP.matches(regex)) {
            LogStreamManage.log("ServerIP does not meet specifications.");
            return null;
        }
        if (args.length == 9) {
            if (!"MD5".equals(authProtocol) && !"SHA".equals(authProtocol)) {
                LogStreamManage.log("Authentication protocol must be MD5 or SHA.\n");
                return null;
            }
            if (!"DES".equals(privacyProtocol) && !"AES".equals(privacyProtocol)) {
                LogStreamManage.log("Privacy protocol must be DES or AES.\n");
                return null;
            }
            if (!("V1".equals(snmpVer) || "V2".equals(snmpVer) || "V3".equals(snmpVer))) {
                LogStreamManage.log("Snmp version must be V1,V2 or V3.\n");
                return null;
            }
        }
        LinkedHashMap<String, ConnectModel> connModels = new LinkedHashMap<String, ConnectModel>();
        ConnectModel conn = null;
        if (args.length >= 9) {
            if ("all".equalsIgnoreCase(bladeNO = bladeNO.replaceAll("\uff0c", ","))) {
                for (int index = 0; index < ConnectModel.totalBladeNO; ++index) {
                    conn = new ConnectModel();
                    conn.setServerIP(serverIP);
                    conn.setImagePath(imagePath);
                    conn.setBladeNO(index + 1);
                    conn.setPwd(hmmPwd);
                    conn.setConnType(0);
                    if ("1".equals(fileType)) {
                        conn.setType(1);
                    } else {
                        conn.setType(2);
                    }
                    connModels.put(Integer.toString(index), conn);
                }
                return connModels;
            }
            String[] split = bladeNO.split(",");
            for (int index = 0; index < split.length; ++index) {
                try {
                    int parseInt = Integer.parseInt(split[index]);
                    if (parseInt > ConnectModel.totalBladeNO) {
                        LogStreamManage.log("bladeNO > " + ConnectModel.totalBladeNO + ".\n");
                        return null;
                    }
                    conn = new ConnectModel();
                    conn.setServerIP(serverIP);
                    conn.setImagePath(imagePath);
                    conn.setBladeNO(parseInt);
                    conn.setPwd(hmmPwd);
                    conn.setConnType(0);
                    if ("1".equals(fileType)) {
                        conn.setType(1);
                    } else {
                        conn.setType(2);
                    }
                    connModels.put(Integer.toString(parseInt), conn);
                    continue;
                }
                catch (Exception exp) {
                    LogStreamManage.log(bladeNO + "bladeNO contain non-numeric characters.\n");
                    return null;
                }
            }
        } else {
            conn = new ConnectModel();
            conn.setServerIP(serverIP);
            conn.setImagePath(imagePath);
            conn.setPwd(hmmPwd);
            conn.setConnType(1);
            conn.setVmmPort(vmmPort);
            if ("1".equals(fileType)) {
                conn.setType(1);
            } else {
                conn.setType(2);
            }
            connModels.put(Integer.toString(0), conn);
        }
        return connModels;
    }
}

