/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.management;

import com.huawei.vm.console.communication.CommunicationReceiver;
import com.huawei.vm.console.communication.CommunicationSender;
import com.huawei.vm.console.communication.ProtocolProcessor;
import com.huawei.vm.console.communication.Receiver;
import com.huawei.vm.console.communication.VMTimerTask;
import com.huawei.vm.console.process.SFF8020iProcessor;
import com.huawei.vm.console.process.UFIProcessor;
import com.huawei.vm.console.storage.impl.CDROMDevice;
import com.huawei.vm.console.storage.impl.CDROMDriver;
import com.huawei.vm.console.storage.impl.CDROMImage;
import com.huawei.vm.console.storage.impl.CDROMLocalDir;
import com.huawei.vm.console.storage.impl.FloppyDevice;
import com.huawei.vm.console.storage.impl.FloppyDriver;
import com.huawei.vm.console.storage.impl.FloppyImage;
import com.huawei.vm.console.utils.ResourceUtil;
import com.huawei.vm.console.utils.VMException;
import com.kvm.AESHandler;
import com.kvm.LogManager;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class VMConsole {
    public static final int CDROM_TYPE = 2;
    public static final int CERTIFY_TIMEOUT = 10000;
    public static final int COMMOM_TYPE = 0;
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int CONSOLE_ACTIVE = 4;
    public static final int CONSOLE_CERTIFY = 2;
    public static final int CONSOLE_DEVICE = 3;
    public static final int CONSOLE_IDLE = 0;
    public static final int CONSOLE_INIT = 1;
    public static final int CONSOLE_OK = 0;
    public static final int DEVICE_TIMEOUT = 10000;
    public static final int FLOPPY_TYPE = 1;
    public static final int MEDIA_DEVICE = 1;
    public static final int MEDIA_IMAGE = 2;
    public static final int MEDIA_LOCAL_DIR = 3;
    public static final int MEDIA_NONE_DEVICE = 0;
    private static final int SECRET_SESSIONID_LEN = 24;
    private static final int SECRETIV_LEN = 16;
    private static final int SECRETKEY_LEN = 16;
    boolean bSecretVMM = false;
    private CDROMDriver cdrom;
    private int cdromErrCode = 0;
    private int cdromState = 0;
    private int cdromType;
    private int consoleState = 0;
    private int errCode = 0;
    private FloppyDriver floppy;
    private int floppyErrCode = 0;
    private int floppyState = 0;
    private int floppyType;
    private Logger logger = LogManager.getInstance().getLogger(VMConsole.class);
    private ProtocolProcessor processor;
    private Thread processorThread;
    private Receiver receiver;
    private ResourceUtil resouceUtil;
    private byte[] secretIV = null;
    private byte[] secretKey = null;
    private CommunicationSender sender;
    private Thread senderThread;
    private byte[] sessionid = null;
    private SFF8020iProcessor SFFProcessor;
    private Thread SFFThread;
    private Socket socket;
    private TimerTask tempTask;
    private Timer timer;
    private VMTimerTask timerTask;
    private UFIProcessor UFIProcessor;
    private Thread UFIThread;

    private void cdromInit() {
        this.SFFThread = null;
        this.SFFProcessor = null;
        if (null != this.cdrom) {
            try {
                this.cdrom.close();
                this.logger.info("VMVconole ---CDROM closed");
            }
            catch (VMException e) {
                this.logger.error("VMConsole : CDROM close error.", e);
            }
            this.cdrom = null;
        }
        this.cdromType = 0;
        this.cdromState = 0;
        this.logger.info("VMConsole : cdrom init -- Finished init.cdromState is idle");
    }

    public void changeCDROMImg(String localDirName, Map<Long, UDFExtendFile> memoryStruct, String imagePath) throws VMException {
        if (null != this.cdrom) {
            if (this.cdrom instanceof CDROMLocalDir) {
                this.cdrom.changeLocalDirDisk(localDirName, memoryStruct, imagePath);
            } else {
                this.cdrom.changeDisk(imagePath);
            }
        }
    }

    public void changeFloppyImg(String imagePath) throws VMException {
        if (null != this.floppy) {
            this.floppy.changeDisk(imagePath);
        }
    }

    public void closeVM(int vmType, int closeReason) {
        switch (vmType) {
            case 0: {
                this.errorProcess(0, closeReason);
                break;
            }
            case 2: {
                this.errorProcess(2, closeReason);
                break;
            }
            case 1: {
                this.errorProcess(1, closeReason);
                break;
            }
        }
    }

    private void commonInit() {
        this.processor = null;
        this.processorThread = null;
        this.receiver = null;
        if (null != this.timerTask) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (null != this.tempTask) {
            this.tempTask.cancel();
            this.tempTask = null;
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
        this.sender = null;
        this.senderThread = null;
        this.socket = null;
        this.consoleState = 0;
        this.cdromState = 0;
        this.floppyState = 0;
        this.logger.info("VMConsole : Finished init.Console is idle");
    }

    private void connect(String serverIP, int serverPort) throws VMException {
        if (null == serverIP || 0 > serverPort) {
            this.logger.error("Invalid argument, serverIP:" + serverIP + " serverPort:" + serverPort);
            throw new VMException(110);
        }
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(serverIP, serverPort), 20000);
            if (!this.socket.isConnected()) {
                this.logger.error("socket connect failed, serverIP:" + serverIP + " serverPort:" + serverPort);
                throw new VMException(103);
            }
            this.logger.info("socket has connected successfully.serverIP:" + serverIP + " serverPort:" + serverPort);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (IOException ioe) {
                this.logger.error("VMConsole : It seems can not set TCP_NODELAY", ioe);
            }
        }
        catch (SocketTimeoutException se) {
            this.logger.error("", se);
            throw new VMException(105);
        }
        catch (IOException ie) {
            this.logger.error("", ie);
            throw new VMException(103);
        }
    }

    private void createCommon(int type, String serverIP, int serverPort) throws VMException, IOException {
        if (0 != this.consoleState) {
            return;
        }
        this.logger.error("VMConsole : enter common init");
        this.commonInit();
        this.errCode = 0;
        this.cdromErrCode = 0;
        this.floppyErrCode = 0;
        this.consoleState = 1;
        if (2 == type) {
            this.cdromState = 1;
        } else if (1 == type) {
            this.floppyState = 1;
        }
        this.connect(serverIP, serverPort);
        this.receiver = new CommunicationReceiver(this.socket);
        this.sender = new CommunicationSender(this.socket, this);
        this.timerTask = new VMTimerTask(this.sender, this);
        this.sender.enableHeartbit(this.timerTask);
        this.processor = new ProtocolProcessor(this.receiver, this);
        this.processor.enableHeartbit(this.timerTask);
        this.processorThread = new Thread(this.processor);
        this.processorThread.setName("Protocol Processor");
        this.processorThread.start();
        this.senderThread = new Thread(this.sender);
        this.senderThread.setName("Sender");
        this.senderThread.start();
        this.logger.error("VMConsole : exit common init");
    }

    public void createSecretCertifyCode(byte[] certifyID, byte[] salt, boolean bCodeKeyNego) {
        int certifyIDLen = certifyID.length;
        this.logger.info("bCodeKeyNego:" + bCodeKeyNego + " certifyIDLen:" + certifyIDLen);
        if (bCodeKeyNego) {
            byte[] completeKey = null;
            StringBuilder strBuilder = new StringBuilder(certifyIDLen);
            for (int i = 0; i < certifyIDLen; ++i) {
                strBuilder.append((char)certifyID[i]);
            }
            try {
                completeKey = AESHandler.generateStoredPasswordHash(strBuilder.toString().toCharArray(), 56, salt);
            }
            catch (Exception ex) {
                this.logger.error("VMConsole : create secret certify code failed", ex);
            }
            this.secretKey = new byte[16];
            this.secretIV = new byte[16];
            this.sessionid = new byte[24];
            System.arraycopy(completeKey, 0, this.sessionid, 0, 24);
            System.arraycopy(completeKey, 24, this.secretKey, 0, 16);
            System.arraycopy(completeKey, 40, this.secretIV, 0, 16);
        } else {
            this.sessionid = new byte[certifyIDLen];
            System.arraycopy(certifyID, 0, this.sessionid, 0, certifyIDLen);
        }
    }

    private void createSFFProcessor() {
        this.logger.info("enter createSFFProcessor");
        this.SFFProcessor = new SFF8020iProcessor(this.cdrom, this.sender);
        this.processor.setSFFArray(this.SFFProcessor.getArray());
        this.SFFProcessor.setSecretKey(this.bSecretVMM, this.secretKey, this.secretIV);
        this.SFFThread = new Thread(this.SFFProcessor);
        this.SFFThread.setName("SFF Processor");
        this.SFFThread.start();
        this.logger.info("exit createSFFProcessor");
    }

    private void createUFIProcessor() {
        this.logger.info("enter createUFIProcessor");
        this.UFIProcessor = new UFIProcessor(this.floppy, this.sender);
        this.UFIProcessor.setSecretKey(this.bSecretVMM, this.secretKey, this.secretIV);
        this.processor.setUFIArray(this.UFIProcessor.getArray());
        this.UFIThread = new Thread(this.UFIProcessor);
        this.UFIThread.setName("UFI Processor");
        this.UFIThread.start();
        this.logger.info("exit createUFIProcessor");
    }

    public void creatVMLink(int type, String serverIPAddress, int serverPort, byte[] certifyID, byte[] salt, boolean bCodeKeyNego, boolean bSecret, String devicePath, int srcType, boolean isWriteProtect, String localDirName, Map<Long, UDFExtendFile> memoryStruct, ResourceUtil util) {
        try {
            this.createCommon(type, serverIPAddress, serverPort);
            if (null != devicePath) {
                if (1 == type && this.floppyState != 4) {
                    this.logger.info("VMConsole : Create floppy=" + devicePath);
                    this.floppyErrCode = 0;
                    this.floppyState = 1;
                    if (srcType == 1) {
                        this.floppyType = 2;
                        this.floppy = new FloppyImage(devicePath, true);
                        this.logger.info("VM Console : create link -- floppy" + this.floppy);
                    } else {
                        this.floppyType = 1;
                        this.floppy = new FloppyDevice(devicePath, this.timerTask);
                    }
                    this.floppy.setWriteProtect(isWriteProtect);
                } else if (2 == type && this.cdromState != 4) {
                    this.logger.info("VMConsole : Create cdrom");
                    this.cdromErrCode = 0;
                    this.cdromState = 1;
                    if (srcType != 0) {
                        File file = new File(devicePath);
                        if (!file.exists()) {
                            this.logger.error("file not exist, fileName:" + file.getName());
                            throw new VMException(336);
                        }
                        if (srcType == 1) {
                            this.cdromType = 2;
                            this.cdrom = new CDROMImage(devicePath, true);
                        } else if (srcType == 2) {
                            this.cdromType = 3;
                            this.cdrom = new CDROMLocalDir(devicePath, true, localDirName, memoryStruct, util);
                            this.cdrom.setLocalDirName(localDirName);
                            this.cdrom.setMemoryStructMap(memoryStruct);
                        }
                    } else {
                        this.cdromType = 1;
                        this.cdrom = new CDROMDevice(devicePath);
                    }
                }
            }
            if (null == this.floppy && null == this.cdrom) {
                this.logger.error("VmConsole:no device create.");
                throw new VMException(301);
            }
            this.bSecretVMM = bSecret;
            this.createSecretCertifyCode(certifyID, salt, bCodeKeyNego);
            this.sentCertifyCode(type);
            this.sentVirtualCommand(type);
        }
        catch (VMException ve) {
            this.logger.error("", ve);
            this.errorProcess(type, ve.getKey());
        }
        catch (IOException ie) {
            this.logger.error("", ie);
            this.errorProcess(type, 103);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destoryVMLink(int type) {
        VMConsole vMConsole = this;
        synchronized (vMConsole) {
            if (0 == this.consoleState) {
                return;
            }
            this.logger.debug("VMConsole : Begin destroy!");
            if (0 == type || 1 == type && 0 == this.cdromState || 2 == type && 0 == this.floppyState) {
                if (4 == this.consoleState && 0 == this.errCode) {
                    this.logger.info("VMConsole : Begin destroy connect!");
                    this.sender.sendImmediate(ProtocolProcessor.vmLinkClosePak((byte)0, (byte)0), 12);
                }
                this.destroyCommonConn();
                if ((0 == type || 2 == type) && 4 == this.cdromState) {
                    this.logger.info("VMConsole : Begin destroy cdrom!");
                    this.destroyCdromConn();
                }
                if ((0 == type || 1 == type) && 4 == this.floppyState) {
                    this.logger.info("VMConsole : Begin destroy floppy!");
                    this.destroyFloppyConn();
                }
                this.initAll();
            } else if (1 == type && 4 == this.cdromState) {
                if (4 == this.floppyState && 0 == this.errCode) {
                    this.logger.info("VMConsole : Begin destroy floppy only!");
                    this.sender.sendImmediate(ProtocolProcessor.vmLinkClosePak((byte)1, (byte)0), 12);
                }
                this.destroyFloppyConn();
                this.floppyInit();
            } else if (2 == type && 4 == this.floppyState) {
                if (4 == this.cdromState && 0 == this.errCode) {
                    this.logger.info("VMConsole : Begin destroy cdrom only!");
                    this.sender.sendImmediate(ProtocolProcessor.vmLinkClosePak((byte)2, (byte)0), 12);
                }
                this.destroyCdromConn();
                this.cdromInit();
            }
        }
    }

    private void destroyCdromConn() {
        if (null != this.SFFProcessor) {
            this.SFFProcessor.setExit();
            this.SFFThread.interrupt();
        }
    }

    private void destroyCommonConn() {
        if (null != this.processorThread) {
            this.processor.setExit();
            this.processorThread.interrupt();
        }
        if (null != this.senderThread) {
            this.sender.setExit();
            this.senderThread.interrupt();
        }
        if (this.socket.isClosed() || null != this.senderThread) {
            // empty if block
        }
        try {
            this.socket.close();
        }
        catch (IOException ie) {
            this.logger.error("VMConsole : Socket close error!", ie);
        }
    }

    private void destroyFloppyConn() {
        if (null != this.UFIProcessor) {
            this.UFIProcessor.setExit();
            this.UFIThread.interrupt();
        }
    }

    public synchronized void errorProcess(int type, int errCode) {
        this.logger.error("VMConsole : An error happend:" + errCode + ":" + this.resouceUtil.getErrMessage(errCode));
        int switcher = this.consoleState;
        if (type == 0) {
            switcher = this.consoleState;
        } else if (type == 2) {
            switcher = this.cdromState;
        } else if (type == 1) {
            switcher = this.floppyState;
        }
        block0 : switch (switcher) {
            case 1: {
                switch (errCode) {
                    case 110: 
                    case 220: 
                    case 223: 
                    case 253: 
                    case 301: 
                    case 320: 
                    case 321: 
                    case 326: 
                    case 327: 
                    case 335: 
                    case 336: {
                        this.setErrCode(type, errCode);
                        this.destoryVMLink(type);
                        break block0;
                    }
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 210: {
                        this.setErrCode(type, errCode);
                        this.setErrCode(0, errCode);
                        this.destoryVMLink(0);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (errCode) {
                    case 335: {
                        this.setErrCode(type, errCode);
                        this.destoryVMLink(type);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 34: 
                    case 35: 
                    case 101: 
                    case 102: 
                    case 121: {
                        this.setErrCode(type, errCode);
                        this.setErrCode(0, errCode);
                        this.destoryVMLink(0);
                        break block0;
                    }
                    case 401: {
                        if (2 == type) {
                            this.setErrCode(0, errCode);
                            this.setErrCode(type, errCode);
                            this.destoryVMLink(type);
                            break block0;
                        }
                        if (1 != type) break block0;
                        this.setErrCode(0, errCode);
                        this.setErrCode(type, errCode);
                        this.destoryVMLink(type);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (errCode) {
                    case 122: 
                    case 335: {
                        this.setErrCode(type, errCode);
                        this.destoryVMLink(type);
                        break block0;
                    }
                    case 17: 
                    case 34: 
                    case 35: 
                    case 101: 
                    case 102: {
                        this.setErrCode(type, errCode);
                        this.setErrCode(0, errCode);
                        this.destoryVMLink(0);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (errCode) {
                    case 34: 
                    case 35: 
                    case 101: 
                    case 102: 
                    case 123: {
                        this.setErrCode(type, errCode);
                        this.setErrCode(0, errCode);
                        this.destoryVMLink(0);
                        break block0;
                    }
                    case 335: {
                        this.setErrCode(type, errCode);
                        this.destoryVMLink(type);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void floppyInit() {
        this.UFIThread = null;
        this.UFIProcessor = null;
        if (null != this.floppy) {
            try {
                this.floppy.close();
                this.logger.info("VMVconole ---FLOPPY closed");
            }
            catch (VMException e) {
                this.logger.error("VMConsole : Floppy close error.", e);
            }
            this.floppy = null;
        }
        this.floppyType = 0;
        this.floppyState = 0;
        this.logger.info("VMConsole : floppy init -- Finished init.floppyState is idle");
    }

    public CDROMDriver getCdrom() {
        return this.cdrom;
    }

    public int getCdRomState() {
        return this.cdromState;
    }

    public int getCdromType() {
        return this.cdromType;
    }

    public int getConsoleState() {
        return this.consoleState;
    }

    public int getFloppyState() {
        return this.floppyState;
    }

    public int getFloppyType() {
        return this.floppyType;
    }

    private byte[] getLocalIP() {
        InetAddress addr = null;
        byte[] ipAddr = null;
        if (this.socket != null) {
            addr = this.socket.getLocalAddress();
            ipAddr = addr.getAddress();
        }
        return ipAddr;
    }

    public byte[] getSecretIV() {
        return this.secretIV;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    private byte[] getSessionID() {
        return this.sessionid;
    }

    public int getState(int type) {
        int result = 0;
        if (0 == type) {
            result = this.errCode;
        } else if (1 == type) {
            result = this.floppyErrCode;
        } else if (2 == type) {
            result = this.cdromErrCode;
        }
        return result;
    }

    private void initAll() {
        this.commonInit();
        this.floppyInit();
        this.cdromInit();
    }

    public void processAck(int ackCode) {
        this.logger.info("ackCode:" + ackCode);
        if (2 == this.consoleState && 0 == ackCode) {
            this.tempTask.cancel();
            byte[] pack = null;
            if (0 != this.cdromType) {
                this.logger.info("enter processAck :virtual cdrom");
                this.createSFFProcessor();
                pack = ProtocolProcessor.devicesPak(2);
                this.cdromState = 3;
            } else {
                this.logger.info("enter processAck :virtual floppy");
                this.createUFIProcessor();
                pack = ProtocolProcessor.devicesPak(1);
                this.floppyState = 3;
            }
            this.consoleState = 3;
            this.tempTask = new TimerTask(){

                @Override
                public void run() {
                    if (3 == VMConsole.this.consoleState) {
                        VMConsole.this.errorProcess(0, 122);
                    }
                    this.cancel();
                }
            };
            if (null == this.timer) {
                this.timer = new Timer("vmm processAck");
            }
            this.timer.schedule(this.tempTask, 10000L);
            this.sender.sendImmediate(pack, 12);
        } else if ((3 == this.consoleState || 4 == this.consoleState) && 16 == ackCode) {
            this.logger.info("come in ACK_DEVICE_CREAT,ackCode==" + ackCode);
            if (null != this.tempTask) {
                this.tempTask.cancel();
                this.tempTask = null;
            }
            if (3 == this.consoleState) {
                this.timer.schedule((TimerTask)this.timerTask, 0L, 1000L);
            }
            this.consoleState = 4;
            if (3 == this.cdromState) {
                this.cdromState = 4;
                this.logger.info("this.cdromState = CONSOLE_ACTIVE;");
            }
            if (3 == this.floppyState) {
                this.floppyState = 4;
                this.logger.info("this.floppyState = CONSOLE_ACTIVE;");
            }
        } else if ((2 == this.cdromState || 2 == this.floppyState) && 49 == ackCode) {
            this.logger.info("ProtocolCode.CN_EXIST==ackCode, ackCode:" + ackCode);
            if (2 == this.cdromState) {
                this.errorProcess(2, 401);
            } else if (2 == this.floppyState) {
                this.errorProcess(1, 401);
            } else {
                this.errorProcess(0, this.errCode);
            }
        } else {
            this.logger.info("enter processAck else");
            if (2 == this.cdromState) {
                this.errorProcess(2, ackCode);
            } else if (2 == this.floppyState) {
                this.errorProcess(1, ackCode);
            } else {
                this.errorProcess(0, this.errCode);
            }
        }
    }

    private void sentCertifyCode(final int type) {
        if (this.consoleState == 1) {
            this.logger.info("enter sentCertifyCode");
            byte[] ip = this.getLocalIP();
            byte[] pack = ProtocolProcessor.connectPak(this.getSessionID(), ip, ResourceUtil.getConfigItem("com.huawei.vm.console.config.version"));
            this.consoleState = 2;
            if (2 == type) {
                this.cdromState = 2;
            } else if (1 == type) {
                this.floppyState = 2;
            }
            this.tempTask = new TimerTask(){

                @Override
                public void run() {
                    if (2 == VMConsole.this.consoleState) {
                        VMConsole.this.errorProcess(type, 121);
                    }
                    this.cancel();
                }
            };
            if (null == this.timer) {
                this.timer = new Timer("vmm sentCertifyCode");
            }
            this.timer.schedule(this.tempTask, 10000L);
            this.sender.sendImmediate(pack, pack.length);
            this.logger.info("exit sentCertifyCode");
        }
    }

    private void sentVirtualCommand(final int type) {
        byte[] pack = null;
        if (2 == type && 4 == this.consoleState && 1 == this.cdromState && 0 != this.cdromType) {
            this.logger.info("enter sentVirtualCommand cdrom");
            this.createSFFProcessor();
            pack = ProtocolProcessor.devicesPak(2);
            this.cdromState = 3;
            this.tempTask = new TimerTask(){

                @Override
                public void run() {
                    if (3 == VMConsole.this.cdromState) {
                        VMConsole.this.errorProcess(type, 122);
                    }
                    this.cancel();
                }
            };
            if (null == this.timer) {
                this.timer = new Timer("cdrom sentVirtualCommand");
            }
            this.timer.schedule(this.tempTask, 10000L);
            this.sender.sendImmediate(pack, 12);
        } else if (1 == type && 4 == this.consoleState && 1 == this.floppyState && 0 != this.floppyType) {
            this.logger.info("enter sentVirtualCommand floppy");
            this.createUFIProcessor();
            pack = ProtocolProcessor.devicesPak(1);
            this.floppyState = 3;
            this.tempTask = new TimerTask(){

                @Override
                public void run() {
                    if (3 == VMConsole.this.floppyState) {
                        VMConsole.this.errorProcess(type, 122);
                    }
                    this.cancel();
                }
            };
            if (null == this.timer) {
                this.timer = new Timer("floppy sentVirtualCommand");
            }
            this.timer.schedule(this.tempTask, 10000L);
            this.sender.sendImmediate(pack, 12);
            this.logger.info("sent floppy VirtualCommand=========" + pack.length);
        }
    }

    public void setCdrom(CDROMDriver cdrom) {
        this.cdrom = cdrom;
    }

    private void setErrCode(int type, int errCode) {
        if (0 == type) {
            this.errCode = errCode;
        }
        if (2 == type) {
            this.cdromErrCode = errCode;
        }
        if (1 == type) {
            this.floppyErrCode = errCode;
        }
    }

    public void setResouceUtil(ResourceUtil resouceUtil) {
        this.resouceUtil = resouceUtil;
    }

    public void setWriteProtect(boolean isWriteProtect) {
        this.floppy.setWriteProtect(isWriteProtect);
    }
}

