/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.process;

import com.huawei.vm.console.communication.CommunicationSender;
import com.huawei.vm.console.communication.ProtocolCode;
import com.huawei.vm.console.communication.ProtocolProcessor;
import com.huawei.vm.console.process.USBProcessor;
import com.huawei.vm.console.storage.impl.FloppyDriver;
import com.huawei.vm.console.utils.VMException;
import com.kvm.AESHandler;
import com.kvm.LogManager;
import org.apache.log4j.Logger;

public class UFIProcessor
extends USBProcessor
implements Runnable {
    private FloppyDriver ufiDevice;
    protected final byte[] inquiryData = new byte[]{0, -128, 0, 1, 31, 0, 0, 0, 72, 85, 65, 87, 69, 73, 32, 32, 70, 76, 79, 80, 80, 89, 32, 86, 77, 32, 49, 46, 49, 46, 48, 32, 32, 32, 32, 32};
    protected final byte[] capacityList = new byte[]{0, 0, 0, 16, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 11, 64, 0, 0, 2, 0};
    private static Logger logger = LogManager.getInstance().getLogger(UFIProcessor.class);

    public UFIProcessor(FloppyDriver floppy, CommunicationSender sender) {
        super(sender);
        this.ufiDevice = floppy;
    }

    @Override
    public void run() {
        logger.info("UFI processor : start");
        while (!this.exitFlag) {
            this.processCommand();
        }
        logger.info(Thread.currentThread().getName() + " close. arr num:" + this.dataArray.getBigArrNum() + "; small arr num:" + this.dataArray.getSmallArrNum() + "; data num :" + this.dataArray.getDataNum());
    }

    private void checkChangeDisk() {
        if (this.ufiDevice.isChangeDisk()) {
            try {
                if (this.ufiDevice.isEject()) {
                    this.ufiDevice.eject();
                } else {
                    this.ufiDevice.insert();
                }
            }
            catch (VMException e) {
                logger.error("UFI processor : Error happened when changing disk", e);
            }
        }
    }

    @Override
    public void processCommand() {
        this.getCommand();
        this.checkChangeDisk();
        if (this.exitFlag) {
            return;
        }
        this.ufiDevice.refreshState();
        switch (this.command[0] & 0xFF) {
            case 4: {
                logger.info("UFI processor : FORMAT_UNIT");
                this.doFormat();
                break;
            }
            case 18: {
                this.doInquiry();
                break;
            }
            case 85: {
                logger.info("UFI processor : MODE_SELECT");
                this.doModeSelect();
                break;
            }
            case 90: {
                this.doModeSense();
                break;
            }
            case 30: {
                logger.info("UFI processor : PREVENT_ALLOW_MEDIUM_REMOVAL");
                this.doPreventAllowMediumRemoval();
                break;
            }
            case 40: 
            case 168: {
                this.doRead();
                break;
            }
            case 37: {
                this.doReadCapacity();
                break;
            }
            case 35: {
                this.doReadFormatCapacity();
                break;
            }
            case 3: {
                this.doRequestSense();
                break;
            }
            case 1: {
                logger.info("UFI processor : Rezero requested!");
                this.setSenseKeys(0, 0, 0, 0);
                break;
            }
            case 43: {
                logger.info("UFI processor : Seek requested!");
                this.setSenseKeys(0, 0, 0, 0);
                break;
            }
            case 29: {
                logger.info("UFI processor : SEND_DIAGNOSTIC");
                this.doSendDiagnostic();
                break;
            }
            case 27: {
                logger.info("UFI processor : START_STOP");
                this.doStartStopUnit();
                break;
            }
            case 0: {
                this.doTestUnitRead();
                break;
            }
            case 47: {
                logger.info("UFI processor : VERIFY");
                this.doVerify();
                break;
            }
            case 42: 
            case 46: 
            case 170: {
                this.doWrite();
                break;
            }
            default: {
                logger.info("UFI processor : Unknown command" + this.command[0] + 255);
                this.setSenseKeys(5, 36, 0, 0);
            }
        }
        this.commandFinish();
    }

    private void doFormat() {
        int paramListLength = ProtocolCode.getInt16bits(this.command, 8);
        byte[] paramList = new byte[paramListLength];
        if (0 == (paramListLength = this.getData(paramList, paramListLength))) {
            logger.error("UFI Processor: Format -- PARAMETER LIST LENGTH ERROR");
            this.setSenseKeys(5, 26, 0, 0);
            return;
        }
        if (this.ufiDevice.isWriteProtect()) {
            logger.error("UFI Processor: Format -- Write Protect.");
            this.setSenseKeys(7, 39, 0, 0);
        } else if (this.ufiDevice.getTotalBlocks() == ProtocolCode.getInt32bits(paramList, 5) && this.ufiDevice.getBlockLength() == ProtocolCode.getInt24bits(paramList, 10)) {
            int track = this.command[2] & 0xFF;
            int side = paramList[1] & 1;
            try {
                this.ufiDevice.formatUnit(2, track, track, side, side);
                this.setSenseKeys(0, 0, 0, 0);
            }
            catch (VMException e) {
                logger.error("UFI Processor: Format -- FORMAT COMMAND FAILED", e);
                this.setSenseKeys(3, 49, 1, e.getKey());
            }
        } else {
            logger.error("UFI Processor: Format -- INVALID FIELD IN PARAMETER");
            this.setSenseKeys(5, 38, 0, 0);
        }
    }

    private void doInquiry() {
        if ((this.command[1] & 0xE0) != 0) {
            this.setSenseKeys(5, 37, 0, 0);
        } else if ((this.command[1] & 1) != 0) {
            this.setSenseKeys(5, 36, 0, 0);
        } else {
            this.sendData(this.inquiryData.length, this.inquiryData, true);
            this.setSenseKeys(0, 0, 0, 0);
        }
    }

    private void doModeSelect() {
        int paramListLength = ProtocolCode.getInt16bits(this.command, 8);
        if (0 == this.getData(this.dataBuffer, paramListLength)) {
            this.setSenseKeys(5, 26, 0, 0);
        } else {
            this.setSenseKeys(0, 0, 0, 0);
        }
    }

    private void doModeSense() {
        int length = this.ufiDevice.modeSense(this.dataBuffer, this.command[2] >> 6 & 3, this.command[2] & 0x3F);
        this.setSenseKeys(0, 0, 0, 0);
        this.sendData(length, this.dataBuffer, true);
    }

    private void doPreventAllowMediumRemoval() {
        if ((this.command[4] & 1) != 0) {
            this.setSenseKeys(5, 36, 0, 0);
        } else {
            this.setSenseKeys(0, 0, 0, 0);
        }
    }

    private void doRead() {
        long lba = ProtocolCode.getInt32bits(this.command, 3);
        long startPos = lba * (long)this.ufiDevice.getBlockLength();
        int length = 0;
        int curRead = 0;
        length = 40 == this.command[0] ? ProtocolCode.getInt16bits(this.command, 8) * this.ufiDevice.getBlockLength() : ProtocolCode.getInt32bits(this.command, 7) * this.ufiDevice.getBlockLength();
        try {
            if (startPos >= 0L && startPos < this.ufiDevice.getMediumSize()) {
                int readLength = 0;
                boolean isLast = false;
                int bufferLen = this.dataBuffer.length;
                while (length > 0) {
                    if (bufferLen < length) {
                        readLength = bufferLen;
                    } else {
                        readLength = length;
                        isLast = true;
                    }
                    curRead = this.ufiDevice.read(this.dataBuffer, startPos, readLength);
                    startPos += (long)curRead;
                    if (curRead == readLength) {
                        this.sendData(readLength, this.dataBuffer, isLast);
                        length -= readLength;
                        continue;
                    }
                    this.sendData(curRead, this.dataBuffer, true);
                    length = -1;
                }
                if (0 == length) {
                    this.setSenseKeys(0, 0, 0, 0);
                } else {
                    logger.error("UFI Processor: Read -- address error(sensekey:ILOGICAL BLOCK ADDRESS OUT OF RANGE)");
                    this.setSenseKeys(5, 33, 0, 0);
                }
            } else {
                logger.error("UFI Processor: Read -- address error(sensekey:ILOGICAL BLOCK ADDRESS OUT OF RANGE)");
                this.setSenseKeys(5, 33, 0, 0);
            }
        }
        catch (VMException e) {
            logger.error("", e);
            switch (e.getKey()) {
                case 250: {
                    logger.error("UFI Processor:Read -- read error(ID CRC ERROR)");
                    this.setSenseKeys(3, 16, 0, (int)(startPos / (long)this.ufiDevice.getBlockLength()));
                    break;
                }
                case 253: {
                    logger.error("UFI Processor : Read -- Meida not present");
                    this.ufiDevice.setDeviceState(0);
                    this.setSenseKeys(2, 58, 0, 0);
                    break;
                }
            }
        }
    }

    private void doReadCapacity() {
        switch (this.ufiDevice.testUnitReady()) {
            case 0: {
                this.setSenseKeys(2, 58, 0, 0);
                break;
            }
            case 2: {
                this.setSenseKeys(6, 40, 0, 0);
                break;
            }
            case 3: {
                int lba = this.ufiDevice.getTotalBlocks() - 1;
                int blockLength = this.ufiDevice.getBlockLength();
                this.dataBuffer[0] = (byte)(lba >> 24 & 0xFF);
                this.dataBuffer[1] = (byte)(lba >> 16 & 0xFF);
                this.dataBuffer[2] = (byte)(lba >> 8 & 0xFF);
                this.dataBuffer[3] = (byte)(lba & 0xFF);
                this.dataBuffer[4] = (byte)(blockLength >> 24 & 0xFF);
                this.dataBuffer[5] = (byte)(blockLength >> 16 & 0xFF);
                this.dataBuffer[6] = (byte)(blockLength >> 8 & 0xFF);
                this.dataBuffer[7] = (byte)blockLength;
                this.setSenseKeys(0, 0, 0, 0);
                this.sendData(8, this.dataBuffer, true);
                break;
            }
        }
    }

    private void doReadFormatCapacity() {
        if (2 == this.ufiDevice.testUnitReady()) {
            this.ufiDevice.setDeviceState(3);
            this.setSenseKeys(6, 40, 0, 0);
        } else {
            this.setSenseKeys(0, 0, 0, 0);
        }
        byte[] capacityList = this.capacityList;
        int totalBlocks = this.ufiDevice.getTotalBlocks();
        int blockLength = this.ufiDevice.getBlockLength();
        capacityList[4] = (byte)(totalBlocks >> 24 & 0xFF);
        capacityList[5] = (byte)(totalBlocks >> 16 & 0xFF);
        capacityList[6] = (byte)(totalBlocks >> 8 & 0xFF);
        capacityList[7] = (byte)(totalBlocks & 0xFF);
        capacityList[9] = (byte)(blockLength >> 16 & 0xFF);
        capacityList[10] = (byte)(blockLength >> 8 & 0xFF);
        capacityList[11] = (byte)(blockLength & 0xFF);
        int dataLen = capacityList.length;
        if (2880 != totalBlocks) {
            dataLen = 12;
        }
        this.sendData(dataLen, capacityList, true);
    }

    private void doRequestSense() {
        byte[] senseData = this.senseData;
        this.sendData(senseData.length, senseData, true);
    }

    private void doSendDiagnostic() {
        this.ufiDevice.setDeviceState(2);
        this.setSenseKeys(0, 0, 0, 0);
    }

    private void doStartStopUnit() {
        if (0 != (this.command[4] & 2)) {
            this.setSenseKeys(5, 36, 0, 0);
        } else {
            this.setSenseKeys(0, 0, 0, 0);
        }
    }

    private void doTestUnitRead() {
        if ((this.command[1] & 0xE0) != 0) {
            this.setSenseKeys(5, 36, 0, 0);
        } else {
            switch (this.ufiDevice.testUnitReady()) {
                case 0: {
                    this.setSenseKeys(2, 58, 0, 0);
                    break;
                }
                case 2: {
                    this.setSenseKeys(6, 40, 0, 0);
                    this.ufiDevice.setDeviceState(3);
                    break;
                }
                case 3: {
                    this.setSenseKeys(0, 0, 0, 0);
                    break;
                }
            }
        }
    }

    private void doVerify() {
        logger.info("Verify requested!");
        this.setSenseKeys(0, 0, 0, 0);
    }

    private void doWrite() {
        long startPos = (long)ProtocolCode.getInt32bits(this.command, 3) * (long)this.ufiDevice.getBlockLength();
        int length = 0;
        length = -86 == this.command[0] ? ProtocolCode.getInt32bits(this.command, 7) : ProtocolCode.getInt16bits(this.command, 8);
        if (0 == (length *= this.ufiDevice.getBlockLength())) {
            this.setSenseKeys(0, 0, 0, 0);
            return;
        }
        int curWrite = 0;
        try {
            if (startPos >= 0L && startPos < this.ufiDevice.getMediumSize() && startPos + (long)length <= this.ufiDevice.getMediumSize()) {
                int bufferLen = this.dataBuffer.length;
                while (length > 0) {
                    curWrite = bufferLen < length ? bufferLen : length;
                    curWrite = this.bSecretVMM ? this.getDataEncry(this.dataBuffer, curWrite) : this.getData(this.dataBuffer, curWrite);
                    if (0 == curWrite) {
                        logger.error("UFI Processor: Write -- address error(sensekey:INVALID FIELD IN COMMAND PACKET)");
                        this.setSenseKeys(5, 36, 0, 0);
                        return;
                    }
                    if (this.ufiDevice.isWriteProtect()) {
                        throw new VMException(254);
                    }
                    this.ufiDevice.write(this.dataBuffer, startPos, curWrite);
                    startPos += (long)curWrite;
                    length -= curWrite;
                }
                this.setSenseKeys(0, 0, 0, 0);
            } else {
                logger.error("UFI Processor: Write -- address error(sensekey:LOGICAL BLOCK ADDRESS OUT OF RANGE)");
                this.setSenseKeys(5, 33, 0, 0);
            }
        }
        catch (VMException ie) {
            logger.error("UFI Processor : Write operation error! Error id:" + ie.getKey(), ie);
            switch (ie.getKey()) {
                case 250: {
                    logger.error("UFI Processor:Write -- Write error(ID CRC ERROR)");
                    this.setSenseKeys(3, 16, 0, 0);
                    break;
                }
                case 253: {
                    logger.error("UFI Processor:Write -- Meida not present.");
                    this.ufiDevice.setDeviceState(0);
                    this.setSenseKeys(2, 58, 0, 0);
                    break;
                }
                case 254: {
                    logger.error("UFI Processor:Write -- Write protect");
                    this.setSenseKeys(7, 39, 0, 0);
                    break;
                }
            }
        }
    }

    @Override
    public void sendData(int dataLength, byte[] dataBuffer, boolean isLast) {
        if (dataLength <= 0) {
            return;
        }
        int off = 0;
        int curLength = dataLength;
        int curState = 1;
        int send_len = 0;
        byte[] curPack = null;
        byte[] curData = null;
        if (0 == dataLength && isLast) {
            curPack = ProtocolProcessor.ufiDataPak(1, 3, dataLength, this.commandID);
            this.sender.sendImmediate(curPack, 12);
        }
        while (dataLength > 0 && !this.exitFlag) {
            if (ProtocolCode.FLOPPY_PACKET_SIZE < dataLength) {
                curLength = ProtocolCode.FLOPPY_PACKET_SIZE;
                curState = 1;
            } else {
                curLength = dataLength;
                curState = isLast ? 3 : 1;
            }
            if (this.bSecretVMM) {
                byte[] data = new byte[curLength];
                byte[] datalen = new byte[]{(byte)(curLength >> 24 & 0xFF), (byte)(curLength >> 16 & 0xFF), (byte)(curLength >> 8 & 0xFF), (byte)(curLength & 0xFF)};
                System.arraycopy(dataBuffer, off, data, 0, curLength);
                byte[] temDes = AESHandler.encry_bytes(data, this.secretKey, this.secretIV, curLength);
                if (0 == temDes.length) {
                    return;
                }
                curData = this.sender.getByteArr(12 + temDes.length + 4);
                ProtocolProcessor.ufiDataPak(curData, 0, 1, curState, temDes.length + 4, this.commandID);
                System.arraycopy(datalen, 0, curData, 12, 4);
                System.arraycopy(temDes, 0, curData, 16, temDes.length);
                send_len = 12 + temDes.length + 4;
            } else {
                curData = this.sender.getByteArr(12 + curLength);
                ProtocolProcessor.ufiDataPak(curData, 0, 1, curState, curLength, this.commandID);
                System.arraycopy(dataBuffer, off, curData, 12, curLength);
                send_len = 12 + curLength;
            }
            while (!this.sender.send(curData, send_len) && !this.exitFlag) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            off += curLength;
            dataLength -= curLength;
        }
    }

    @Override
    public void commandFinish() {
        int result = 0;
        if (0 != this.getSenseKey() && 3 != (this.command[0] & 0xFF)) {
            result = 1;
        }
        byte[] cmpltArr = this.sender.getByteArr(12);
        ProtocolProcessor.ufiCmpltPak(cmpltArr, 0, result, this.commandID);
        this.sender.sendImmediate(cmpltArr, 12);
    }
}

