/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.huawei.vm.console.utils.TestPrint;
import com.kvm.AESHandler;
import com.kvm.Base;
import com.kvm.BladeCommu;
import com.kvm.DrawThread;
import com.kvm.ImagePane;
import com.kvm.KVMException;
import com.kvm.KVMInterface;
import com.kvm.KVMUtil;
import com.kvm.LogManager;
import com.kvm.UnPackData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import org.apache.log4j.Logger;

public class BladeThread
extends Thread {
    private static final int KVM_COMMAND = 0;
    private static final int BLADE_POSITI = 1;
    private static final int KEYSTATE_POSITI = 2;
    private static final int IMAGEDATA_POSITI = 2;
    private static final int FILTER_SIZE = 20;
    private boolean isConn = true;
    private int bladeNO = 0;
    private boolean isNew = true;
    private ArrayList compareBuf = new ArrayList();
    private DrawThread drawThread = null;
    public BladeCommu bladeCommu = null;
    public KVMInterface kvmInterface = null;
    public UnPackData unPack = null;
    public Hashtable keyState = new Hashtable();
    public Hashtable bladeStateInfo = new Hashtable();
    public KVMUtil kvmUtil = null;
    public Timer timer = null;
    public byte[] keyEnData = new byte[16];
    private static final int NEGO_DATA_PWD_LEN = 32;
    private static final int NEGO_DATA_SALT_LEN = 16;
    private boolean SingleMouseStatus = false;
    private boolean SynMouseStatus = false;
    private Logger logger = LogManager.getInstance().getLogger(BladeThread.class);
    private boolean encryted = false;
    public boolean negotiatedKeyState = false;
    private byte[] bladeKvmkey = null;
    private byte[] bladeKbdkey = null;
    private byte[] bladeVmmkey = null;

    public boolean getSingleMouseStatus() {
        return this.SingleMouseStatus;
    }

    public void setSingleMouseStatus(boolean status) {
        this.SingleMouseStatus = status;
    }

    public boolean getSynMouseStatus() {
        return this.SynMouseStatus;
    }

    public void setSynMouseStatus(boolean status) {
        this.SynMouseStatus = status;
    }

    public boolean getEncrytedStatus() {
        return this.encryted;
    }

    public void setEncrytedStatus(boolean status) {
        this.encryted = status;
    }

    public void setNegotaitedKeyState(boolean state) {
        this.negotiatedKeyState = state;
    }

    public void initBladeNegotiatedKey(char[] inputPlainKey, byte[] salt) {
        byte[] completeKey = null;
        try {
            completeKey = AESHandler.generateStoredPasswordHash(inputPlainKey, 48, salt);
        }
        catch (Exception ex) {
            this.logger.error("", ex);
        }
        byte[] kvmSecretKey = new byte[16];
        byte[] kbdSecretKey = new byte[16];
        byte[] vmmSecretKey = new byte[16];
        System.arraycopy(completeKey, 0, kvmSecretKey, 0, 16);
        System.arraycopy(completeKey, 16, kbdSecretKey, 0, 16);
        System.arraycopy(completeKey, 32, vmmSecretKey, 0, 16);
        this.bladeKvmkey = new byte[16];
        KVMUtil.perIntToByteCon(this.bladeKvmkey, 0, kvmSecretKey);
        this.bladeKbdkey = new byte[16];
        KVMUtil.perIntToByteCon(this.bladeKbdkey, 0, kbdSecretKey);
        this.bladeVmmkey = new byte[16];
        KVMUtil.perIntToByteCon(this.bladeVmmkey, 0, vmmSecretKey);
        this.logger.info("new completekey:" + TestPrint.parseBytesToString(completeKey));
    }

    public byte[] getBladeKvmkey() {
        return this.negotiatedKeyState ? this.bladeKvmkey : Base.getKvmSecretKeyBigEnd();
    }

    public byte[] getBladeKbdkey() {
        return this.negotiatedKeyState ? this.bladeKbdkey : Base.getKbdSecretKeyBigEnd();
    }

    public byte[] getBladeKeyIV() {
        return this.negotiatedKeyState ? this.bladeVmmkey : Base.getVmmSecretKeyBigEnd();
    }

    public void setKvmUtil(KVMUtil kvmUtil) {
        this.kvmUtil = kvmUtil;
    }

    public BladeThread(String ip, int port, int bladeNO, boolean isNew) throws KVMException {
        this.bladeCommu = new BladeCommu(ip, port);
        this.isNew = isNew;
        this.bladeNO = bladeNO;
    }

    @Override
    public void run() {
        ImagePane imagePane = this.kvmUtil.getImagePane(this.bladeNO);
        byte[] bytes = null;
        while (this.isConn) {
            while (this.drawThread.lList.size() > 2000) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.error("", e);
                }
            }
            bytes = this.bladeCommu.getData();
            if (bytes == null) {
                if (!this.bladeCommu.isAutoFlag()) break;
                continue;
            }
            ++imagePane.imageReceive;
            if (!this.drawThread.isDisplay) continue;
            this.kvmUtil.start = 0;
            block13: while (this.kvmUtil.diviStreamNew(bytes, this.isNew)) {
                this.unPack.setkvmType(this.kvmUtil.result);
                byte[] unPackData = null;
                unPackData = this.unPack.getData();
                if (unPackData == null) continue;
                switch (unPackData[0]) {
                    case 2: {
                        if (this.getEncrytedStatus()) {
                            int pack_len = this.kvmUtil.dlen;
                            int offset = 0xFF00 & unPackData[2] << 8 | 0xFF & unPackData[3];
                            if (offset != 0) {
                                int encrydata_len = pack_len - 2 - 6;
                                int origdata_len = unPackData[5] & 0xFF;
                                byte[] encrytedData = new byte[encrydata_len];
                                byte[] tempUnPackData = new byte[origdata_len + 5];
                                System.arraycopy(unPackData, 0, tempUnPackData, 0, 5);
                                System.arraycopy(unPackData, 6, encrytedData, 0, encrydata_len);
                                byte[] decryted_data = AESHandler.aes_cbc_128_decrypt(encrytedData, this.getBladeKvmkey(), this.getBladeKeyIV());
                                System.arraycopy(decryted_data, 0, tempUnPackData, 5, origdata_len);
                                unPackData = tempUnPackData;
                            }
                        }
                        if (!this.isNew) {
                            if (!this.fileImageData(unPackData)) continue block13;
                            this.distributeImageData(unPackData);
                            continue block13;
                        }
                        this.distributeImageData(unPackData);
                        continue block13;
                    }
                    case 4: {
                        this.distributeKeyStateData(unPackData);
                        continue block13;
                    }
                    case 8: {
                        this.distributeConnectStateData(unPackData);
                        continue block13;
                    }
                    case 37: {
                        this.distributeMouseModeData(unPackData);
                        continue block13;
                    }
                    case 40: {
                        continue block13;
                    }
                    case 64: {
                        this.distributeSecretKeyNegotiate(unPackData);
                        continue block13;
                    }
                    case 50: {
                        this.distributeNegotiVMMCodeKey(unPackData);
                    }
                }
                this.logger.error("error data");
            }
        }
    }

    public boolean fileImageData(byte[] unPackData) {
        boolean judge = true;
        StringBuffer temBuffer = new StringBuffer();
        temBuffer.append(unPackData[1]);
        temBuffer.append(unPackData[2]);
        int IMAGEDATA_POSITI1 = 3;
        int IMAGEDATA_POSITI2 = 4;
        try {
            temBuffer.append(unPackData[IMAGEDATA_POSITI1]);
            temBuffer.append(unPackData[IMAGEDATA_POSITI2]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        int count = this.compareBuf.size();
        for (int i = 0; i < count; ++i) {
            if (!temBuffer.toString().equals((String)this.compareBuf.get(i))) continue;
            judge = false;
            break;
        }
        if (judge) {
            if (this.compareBuf.size() == 20) {
                this.compareBuf.remove(0);
                this.compareBuf.add(temBuffer.toString());
            } else {
                this.compareBuf.add(temBuffer.toString());
            }
        }
        return judge;
    }

    public void distributeImageData(byte[] unPackData) {
        if (this.drawThread != null && this.drawThread.imagePane != null) {
            this.drawThread.lList.add(unPackData);
        }
    }

    public void distributeKeyStateData(byte[] unPackData) {
        ImagePane imagePane = this.kvmUtil.getImagePane(this.bladeNO);
        if (imagePane != null) {
            this.keyState.clear();
            this.keyState.put(this.bladeNO + "", unPackData[2]);
            if (this.bladeNO == this.kvmInterface.actionBlade || this.kvmInterface.fullScreen != null && this.bladeNO == this.kvmInterface.fullScreen.actionBlade) {
                this.kvmUtil.setNumAndCapLock();
            }
        }
    }

    public void distributeConnectStateData(byte[] unPackData) {
        byte conState = unPackData[2];
        this.logger.info("conState:" + conState);
        switch (conState) {
            case 2: {
                this.drawThread.imagePane.quitConn("over_userconnect");
                break;
            }
            case 3: {
                this.drawThread.imagePane.quitConn("str_errorname");
                break;
            }
            case 4: {
                this.drawThread.imagePane.quitConn("SIGNAL_OUT_RANGE");
                break;
            }
            case 6: {
                this.drawThread.imagePane.quitConn("encry_not_match");
                break;
            }
        }
    }

    public void distributeMouseModeData(byte[] unPackData) {
        byte conState = 0;
        conState = unPackData[2];
        switch (conState) {
            case 0: {
                Base.isSynMouse = false;
                Base.isSingleMouse = false;
                if (this.getSingleMouseStatus()) {
                    Base.isSingleMouse = true;
                    this.kvmInterface.floatToolbar.powerMenu.SingleMouseMenu.setSelected(true);
                    if (this.kvmInterface.isFullScreen && null != this.kvmInterface.fullScreen.toolBar.powerMenu && !this.kvmInterface.fullScreen.toolBar.powerMenu.SingleMouseMenu.isSelected()) {
                        this.kvmInterface.fullScreen.toolBar.powerMenu.SingleMouseMenu.setSelected(true);
                    }
                }
                if (null != this.drawThread.imagePane && null != this.drawThread.imagePane.mouseTimerTask) {
                    this.drawThread.imagePane.mouseTimerTask = new ImagePane.MouseTimerTask(this.drawThread.imagePane);
                    KVMUtil.startMouseList(this.drawThread.imagePane);
                }
                if (null != this.kvmInterface.fullScreen && null != this.kvmInterface.fullScreen.toolBar && null != this.kvmInterface.fullScreen.toolBar.mouseModeButton) {
                    this.kvmInterface.fullScreen.toolBar.mouseModeButton.setEnabled(true);
                }
                if (null != this.kvmInterface.floatToolbar.powerMenu && this.kvmInterface.floatToolbar.powerMenu.mouseModeSwitchMenu.isSelected()) {
                    this.kvmInterface.floatToolbar.powerMenu.mouseModeSwitchMenu.setSelected(false);
                }
                if (!this.kvmInterface.isFullScreen || null == this.kvmInterface.fullScreen.toolBar.powerMenu || !this.kvmInterface.fullScreen.toolBar.powerMenu.mouseModeSwitchMenu.isSelected()) break;
                this.kvmInterface.fullScreen.toolBar.powerMenu.mouseModeSwitchMenu.setSelected(false);
                break;
            }
            case 1: {
                Base.isSynMouse = true;
                Base.isSingleMouse = false;
                this.setSingleMouseStatus(false);
                this.kvmInterface.floatToolbar.powerMenu.SingleMouseMenu.setSelected(false);
                if (this.kvmInterface.isFullScreen && null != this.kvmInterface.fullScreen.toolBar.powerMenu && this.kvmInterface.fullScreen.toolBar.powerMenu.SingleMouseMenu.isSelected()) {
                    this.kvmInterface.fullScreen.toolBar.powerMenu.SingleMouseMenu.setSelected(false);
                }
                if (null != this.kvmInterface.fullScreen && null != this.kvmInterface.fullScreen.toolBar && null != this.kvmInterface.fullScreen.toolBar.mouseModeButton) {
                    this.kvmInterface.fullScreen.toolBar.mouseSynButton.setEnabled(false);
                    this.kvmInterface.fullScreen.toolBar.mouseModeButton.setEnabled(false);
                    this.kvmInterface.base.isMstsc = false;
                }
                if (null != this.kvmInterface.floatToolbar.powerMenu && !this.kvmInterface.floatToolbar.powerMenu.mouseModeSwitchMenu.isSelected()) {
                    this.kvmInterface.floatToolbar.powerMenu.mouseModeSwitchMenu.setSelected(true);
                }
                if (!this.kvmInterface.isFullScreen || null == this.kvmInterface.fullScreen.toolBar.powerMenu || this.kvmInterface.fullScreen.toolBar.powerMenu.mouseModeSwitchMenu.isSelected()) break;
                this.kvmInterface.fullScreen.toolBar.powerMenu.mouseModeSwitchMenu.setSelected(true);
                break;
            }
        }
    }

    private static String convert(byte[] data, int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    private void distributeSecretKeyNegotiate(byte[] unPackData) {
        this.logger.info("distributeSecretKeyNegotiate:");
        int data_len = unPackData.length - 2;
        this.logger.info("data_len=" + data_len + " Base.negotiatepass:" + TestPrint.parseBytesToString(Base.negotiatepass) + " Base.negotiateiv:" + TestPrint.parseBytesToString(Base.negotiateiv));
        if (data_len > 0 && Base.negotiatepass != null && Base.negotiateiv != null) {
            this.logger.info("distributeSecretKeyNegotiate:data_len > 0 true");
            byte[] encryted_data = new byte[data_len];
            System.arraycopy(unPackData, 2, encryted_data, 0, data_len);
            byte[] decryted_data = AESHandler.aes_cbc_128_decrypt(encryted_data, Base.negotiatepass, Base.negotiateiv);
            if (decryted_data.length == 48) {
                String de_str = BladeThread.convert(decryted_data, 32);
                byte[] salt = new byte[16];
                System.arraycopy(decryted_data, 32, salt, 0, 16);
                this.initBladeNegotiatedKey(de_str.toCharArray(), salt);
                this.setNegotaitedKeyState(true);
            }
        }
    }

    private void distributeNegotiVMMCodeKey(byte[] unPackData) {
        this.logger.error("enter in distributeNegotiVMMCodeKey.");
        int data_len = unPackData.length - 2;
        if (data_len > 0) {
            byte[] nego_data;
            byte[] codekey = null;
            byte[] salt = null;
            byte[] key_salt_data = nego_data = new byte[data_len];
            System.arraycopy(unPackData, 2, nego_data, 0, data_len);
            this.logger.info("distributeNegotiVMMCodeKey, getSecretKVM(bladeNO)" + this.kvmInterface.kvmUtil.getSecretKVM(this.bladeNO) + "bladeNo:" + this.bladeNO);
            if (this.kvmInterface.kvmUtil.getSecretKVM(this.bladeNO)) {
                this.logger.info("distributeNegotiVMMCodeKey, getSecretKVM(bladeNO)" + this.kvmInterface.kvmUtil.getSecretKVM(this.bladeNO) + "bladeNo:" + this.bladeNO);
                byte[] key = this.getBladeKvmkey();
                byte[] iv = this.getBladeKeyIV();
                byte[] decryted_data = AESHandler.aes_cbc_128_decrypt(nego_data, key, iv);
                key_salt_data = decryted_data;
            }
            if (data_len >= 20) {
                codekey = new byte[20];
                System.arraycopy(key_salt_data, 0, codekey, 0, 20);
            }
            if (data_len >= 36) {
                salt = new byte[16];
                System.arraycopy(key_salt_data, 20, salt, 0, 16);
            }
            this.kvmInterface.kvmUtil.setVMMSecretCodeKey(this.bladeNO, codekey);
            this.kvmInterface.kvmUtil.setVMMSecretSalt(this.bladeNO, salt);
        }
    }

    public void setDrawThread(DrawThread drawThread) {
        this.drawThread = drawThread;
    }

    public DrawThread getDrawThread() {
        return this.drawThread;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public void setUnPackData(UnPackData unPack) {
        this.unPack = unPack;
    }

    public void setBladeNO(int bladeNO) {
        this.bladeNO = bladeNO;
    }

    public void setConn(boolean isConn) {
        this.isConn = isConn;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public int getBladeNO() {
        return this.bladeNO;
    }
}

