/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.oracle.webservices.internal.api.databinding.JavaCallInfo;
import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import java.lang.reflect.InvocationTargetException;

public class SEIInvokerTube
extends InvokerTube {
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.binding = binding;
        this.model = model;
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet req) {
        JavaCallInfo call = this.model.getDatabinding().deserializeRequest(req);
        if (call.getException() == null) {
            try {
                if (req.getMessage().isOneWay(this.model.getPort()) && req.transportBackChannel != null) {
                    req.transportBackChannel.close();
                }
                Object ret = this.getInvoker(req).invoke(req, call.getMethod(), call.getParameters());
                call.setReturnValue(ret);
            }
            catch (InvocationTargetException e) {
                call.setException((Throwable)e);
            }
            catch (Exception e) {
                call.setException((Throwable)e);
            }
        } else if (call.getException() instanceof DispatchException) {
            DispatchException e = (DispatchException)call.getException();
            return this.doReturnWith(req.createServerResponse(e.fault, this.model.getPort(), null, this.binding));
        }
        Packet res = (Packet)this.model.getDatabinding().serializeResponse(call);
        res = req.relateServerResponse(res, req.endpoint.getPort(), this.model, req.endpoint.getBinding());
        assert (res != null);
        return this.doReturnWith(res);
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        return this.doReturnWith(response);
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        return this.doThrow(t);
    }
}

