/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.HWDiscover.manage;

import com.huawei.cdrommount.HWDiscover.common.HWDiscoverEnum;
import com.huawei.cdrommount.HWDiscover.common.MessageDescription;
import com.huawei.cdrommount.HWDiscover.common.SSHDicover;
import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.UMateException;
import com.huawei.cdrommount.common.log.Logger;
import com.huawei.cdrommount.common.model.IPMIAndSNMPModel;
import com.huawei.cdrommount.common.snmp.SNMPBase;
import com.huawei.cdrommount.common.ssh.Shell;

public abstract class SNMPCommandBase {
    public Logger logger = new Logger(SNMPCommandBase.class);
    public HWDiscoverModel snmpModel = null;
    public SNMPBase snmpBase = null;

    public SNMPCommandBase(HWDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSNMPProtocolAndExecCmd() {
        Shell shell = null;
        try {
            if (this.snmpModel.getDiscoverType() != HWDiscoverEnum.DiscoverType.Unknown) {
                boolean bl = this.execSNMPCommand();
                return bl;
            }
            if (this.snmpModel.getVersion() != IPMIAndSNMPModel.SNMPVersion.V3) {
                this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V2C.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V2c);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V1.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V1);
                    boolean bl = true;
                    return bl;
                }
                if (this.snmpModel.getUserName().indexOf(" ") > -1) {
                    this.snmpModel.setMsg(MessageDescription.UserNameHasSpace);
                    boolean bl = false;
                    return bl;
                }
                shell = SSHDicover.getShell(this.snmpModel);
                if (null == shell) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.snmpModel.setVersion(IPMIAndSNMPModel.SNMPVersion.V3.name());
            if (this.snmpModel.getLastDiscoverType() == 0) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.MD5.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.DES.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(1);
            }
            if (this.snmpModel.getLastDiscoverType() == 1) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.SHA.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.AES.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(2);
            }
            if (this.snmpModel.getLastDiscoverType() == 2) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.MD5.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.AES.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(3);
            }
            if (this.snmpModel.getLastDiscoverType() == 3) {
                this.snmpModel.setAuthenticationProtocol(IPMIAndSNMPModel.AuthenticationProtocol.SHA.name());
                this.snmpModel.setPrivacyProtocol(IPMIAndSNMPModel.PrivacyProtocol.DES.name());
                if (this.execSNMPCommand()) {
                    this.snmpModel.setDiscoverType(HWDiscoverEnum.DiscoverType.SNMP_V3);
                    boolean bl = true;
                    return bl;
                }
                this.snmpModel.setLastDiscoverType(4);
            }
        }
        catch (Exception ex) {
            if (UMateException.SameNameDiffOtherInfo.equals(ex.getMessage())) {
                this.logger.info(this.snmpModel.getIPAddress() + " " + UMateException.SameNameDiffOtherInfo);
            } else {
                this.logger.error(ex);
                if (ex.getMessage().startsWith(MessageDescription.PWDLengthError)) {
                    this.snmpModel.setMsg(MessageDescription.PWDLengthShowError);
                    boolean bl = false;
                    return bl;
                }
            }
            this.snmpModel.setMsg(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.snmpBase != null) {
                this.snmpBase.SNMPClose();
            }
            if (shell != null) {
                try {
                    shell.disconnect();
                }
                catch (Exception ex) {
                    this.logger.error(ex);
                }
            }
        }
        return true;
    }

    public abstract boolean execSNMPCommand() throws Exception;

    public String getOIDValue(String serverOID) throws Exception {
        this.snmpModel.setOID(serverOID);
        String GetOIDValue = this.snmpBase.GetOIDValue(serverOID);
        if ("Request timeout.".equals(GetOIDValue)) {
            this.snmpModel.setMsg(MessageDescription.SNMPConfigError);
            return null;
        }
        if (GetOIDValue.startsWith("noSuch")) {
            this.logger.info(String.format("%s OID:%s, no such object.", this.snmpModel.getIPAddress(), serverOID));
            this.snmpModel.setMsg(MessageDescription.NotHuaweiServerError);
            return null;
        }
        return GetOIDValue;
    }

    public String getOIDValueNoErrorMsg(String serverOID) throws Exception {
        String GetOIDValue = this.snmpBase.GetOIDValue(serverOID);
        if (!"Request timeout.".equals(GetOIDValue) && !GetOIDValue.startsWith("noSuch")) {
            return GetOIDValue;
        }
        return null;
    }

    public void getPromptMsg(String message) {
        if (MessageDescription.NotHuaweiServerError.equals(this.snmpModel.getMsg())) {
            this.snmpModel.setMsg("The current version of iBMC does not support " + message + ", please upgrade to the latest version.");
            this.logger.info(String.format("%s does not support %s, OID:%s.", this.snmpModel.getIPAddress(), message, this.snmpModel.getOID()));
        } else {
            this.snmpModel.setMsg("SNMP config error,please check the configuration and then try again.");
            this.logger.info(String.format("%s %s settings error, OID:%s.", this.snmpModel.getIPAddress(), message, this.snmpModel.getOID()));
        }
    }
}

