/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common;

import com.huawei.cdrommount.common.GlobalStaticValue;
import com.huawei.cdrommount.common.internationalization.CommonEnum;
import com.huawei.cdrommount.common.log.Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SystemConfig {
    private Logger logger = new Logger(SystemConfig.class.getName());
    FileInputStream inputStream = null;
    Properties prop = null;
    private String filename = null;
    private static SystemConfig config = null;

    public static synchronized SystemConfig createSystemConfig() {
        if (null != config) {
            return config;
        }
        config = new SystemConfig();
        return config;
    }

    private SystemConfig() {
        try {
            this.filename = GlobalStaticValue.commonBundle.getValue((Object)CommonEnum.CommonResourcesEnum.SystemConfigFile);
            this.inputStream = new FileInputStream(this.filename);
            this.prop = new Properties();
            this.prop.load(this.inputStream);
        }
        catch (IOException ex) {
            this.logger.error(ex);
        }
    }

    public SystemConfig(String cfg) {
        try {
            this.inputStream = new FileInputStream(cfg);
            this.filename = cfg;
            this.prop = new Properties();
            this.prop.load(this.inputStream);
        }
        catch (IOException ex) {
            this.logger.error(ex);
        }
        this.prop.list(System.out);
    }

    public void SaveCfg() {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(this.filename);
            this.prop.store(outputFile, "save config");
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        finally {
            if (null != outputFile) {
                try {
                    outputFile.close();
                }
                catch (IOException ex) {
                    this.logger.error(ex);
                }
            }
        }
    }

    public String getConfigVlaue(String configName) {
        String value = this.prop.getProperty(configName);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public void setConfigVlaue(String configName, String configValue) {
        this.prop.setProperty(configName, configValue);
    }
}

