/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.common.model;

import com.huawei.cdrommount.common.UMateException;

public class IPMIAndSNMPModel {
    private SNMPVersion version = SNMPVersion.V2C;
    private String IPAddress = "";
    private String userName = "root";
    private String userPassword = "";
    private String SNMPPort = "161";
    private String SNMPTrapPort = "162";
    private String transmitType = "udp";
    private AuthenticationProtocol authenticationProtocol = AuthenticationProtocol.MD5;
    private PrivacyProtocol privacyProtocol = PrivacyProtocol.DES;
    private String community = "rwpublic";
    private String OID = "";
    private String IPMIPort = "623";
    private String IPMIParameter = "";
    private IPMIInterfaceEnum IPMIInterface = IPMIInterfaceEnum.lan;
    private String SSHPort = "22";
    private SNMPSetValueType SNMPValueType = SNMPSetValueType.None;
    private String SNMPSetValue = "";
    private int SNMPErrorCode = 0;
    private String SNMPErrorMsg = "";

    public SNMPVersion getVersion() {
        return this.version;
    }

    public void setVersion(String version) throws UMateException {
        String string = version = version == null ? "" : version.trim().toUpperCase();
        if ("".equals(version)) {
            return;
        }
        try {
            this.version = SNMPVersion.valueOf(version);
        }
        catch (Exception ex) {
            throw new UMateException("SNMP Version must be V1,V2c or V3.");
        }
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public void setIPAddress(String IPAddress) throws UMateException {
        String string = IPAddress = IPAddress == null ? "" : IPAddress.replace(" ", "");
        if ("".equals(IPAddress)) {
            throw new UMateException("IPAddress cannot be empty.");
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        if (!IPAddress.matches(regex)) {
            throw new UMateException(IPAddress + ":Invalid IPAddress.");
        }
        this.IPAddress = IPAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        String string = userName = userName == null ? "root" : userName.trim();
        if ("".equals(userName)) {
            return;
        }
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) throws UMateException {
        this.userPassword = userPassword = userPassword == null ? "" : userPassword;
    }

    public String getSNMPPort() {
        return this.SNMPPort;
    }

    public void setSNMPPort(String SNMPPort) throws UMateException {
        String string = SNMPPort = SNMPPort == null ? "" : SNMPPort.trim();
        if ("".equals(SNMPPort)) {
            return;
        }
        try {
            if (Integer.parseInt(SNMPPort) > 65535) {
                throw new UMateException("SNMPPort is greater than 65535.");
            }
        }
        catch (Exception ex) {
            if (SNMPPort.matches("[0-9]+")) {
                throw new UMateException("SNMPPort is greater than 65535.");
            }
            throw new UMateException("SNMPPort must be a number.");
        }
        this.SNMPPort = SNMPPort;
    }

    public String getSNMPTrapPort() {
        return this.SNMPTrapPort;
    }

    public void setSNMPTrapPort(String SNMPTrapPort) throws UMateException {
        String string = SNMPTrapPort = SNMPTrapPort == null ? "" : SNMPTrapPort.trim();
        if ("".equals(SNMPTrapPort)) {
            return;
        }
        try {
            if (Integer.parseInt(SNMPTrapPort) > 65535) {
                throw new UMateException("SNMPTrapPort is greater than 65535.");
            }
        }
        catch (Exception ex) {
            if (SNMPTrapPort.matches("[0-9]+")) {
                throw new UMateException("SNMPTrapPort is greater than 65535.");
            }
            throw new UMateException("SNMPTrapPort must be a number.");
        }
        this.SNMPTrapPort = SNMPTrapPort;
    }

    public String getTransmitType() {
        return this.transmitType;
    }

    public void setTransmitType(String transmitType) {
        String string = transmitType = transmitType == null ? "" : transmitType.trim();
        if ("".equals(transmitType)) {
            return;
        }
        this.transmitType = transmitType;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) throws UMateException {
        String string = authenticationProtocol = authenticationProtocol == null ? "" : authenticationProtocol.trim().toUpperCase();
        if ("".equals(authenticationProtocol)) {
            return;
        }
        try {
            this.authenticationProtocol = AuthenticationProtocol.valueOf(authenticationProtocol);
        }
        catch (Exception ex) {
            throw new UMateException("AuthenticationProtocol must be MD5 or SHA.");
        }
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setPrivacyProtocol(String privacyProtocol) throws UMateException {
        String string = privacyProtocol = privacyProtocol == null ? "" : privacyProtocol.trim().toUpperCase();
        if ("".equals(privacyProtocol)) {
            return;
        }
        try {
            this.privacyProtocol = PrivacyProtocol.valueOf(privacyProtocol);
        }
        catch (Exception ex) {
            throw new UMateException("PrivacyProtocol must be DES or AES.");
        }
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        String string = community = community == null ? "" : community.trim();
        if ("".equals(community)) {
            return;
        }
        this.community = community;
    }

    public String getOID() {
        return this.OID;
    }

    public void setOID(String OID) {
        this.OID = OID = OID == null ? "" : OID.trim();
    }

    public String getIPMIParameter() {
        return this.IPMIParameter;
    }

    public void setIPMIParameter(String IPMIParameter) {
        this.IPMIParameter = IPMIParameter;
    }

    public String getIPMIPort() {
        return this.IPMIPort;
    }

    public void setIPMIPort(String IPMIPort) throws UMateException {
        String string = IPMIPort = IPMIPort == null ? "" : IPMIPort.trim();
        if ("".equals(IPMIPort)) {
            return;
        }
        try {
            if (Integer.parseInt(IPMIPort) > 65535) {
                throw new UMateException("IPMIPort is greater than 65535.");
            }
        }
        catch (Exception ex) {
            if (IPMIPort.matches("[0-9]+")) {
                throw new UMateException("IPMIPort is greater than 65535.");
            }
            throw new UMateException("IPMIPort must be a number.");
        }
        this.IPMIPort = IPMIPort;
    }

    public String getSSHPort() {
        return this.SSHPort;
    }

    public void setSSHPort(String SSHPort) throws UMateException {
        String string = SSHPort = SSHPort == null ? "" : SSHPort.trim();
        if ("".equals(SSHPort)) {
            return;
        }
        try {
            if (Integer.parseInt(SSHPort) > 65535) {
                throw new UMateException("SSHPort is greater than 65535.");
            }
        }
        catch (Exception ex) {
            if (SSHPort.matches("[0-9]+")) {
                throw new UMateException("SSHPort is greater than 65535.");
            }
            throw new UMateException("SSHPort must be a number.");
        }
        this.SSHPort = SSHPort;
    }

    public IPMIInterfaceEnum getIPMIInterface() {
        return this.IPMIInterface;
    }

    public void setIPMIInterface(IPMIInterfaceEnum IPMIInterface) {
        this.IPMIInterface = IPMIInterface;
    }

    public SNMPSetValueType getSNMPValueType() {
        return this.SNMPValueType;
    }

    public void setSNMPValueType(SNMPSetValueType SNMPValueType) {
        this.SNMPValueType = SNMPValueType;
    }

    public String getSNMPSetValue() {
        return this.SNMPSetValue;
    }

    public void setSNMPSetValue(String SNMPSetValue) {
        this.SNMPSetValue = SNMPSetValue;
    }

    public void setSNMPErrorCode(int SNMPErrorCode) {
        this.SNMPErrorCode = SNMPErrorCode;
    }

    public void setSNMPErrorMsg(String SNMPErrorMsg) {
        this.SNMPErrorMsg = SNMPErrorMsg;
    }

    public static enum SNMPSetValueType {
        Integer32,
        Counter32,
        Counter64,
        Gauge32,
        GenericAddress,
        IpAddress,
        OctetString,
        OID,
        Opaque,
        UnsignedInteger32,
        None;

    }

    public static enum IPMIInterfaceEnum {
        lan,
        lanplus;

    }

    public static enum PrivacyProtocol {
        DES,
        AES;

    }

    public static enum AuthenticationProtocol {
        MD5,
        SHA;

    }

    public static enum SNMPVersion {
        V1,
        V2C,
        V3;

    }
}

