/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdrommount.model;

import com.huawei.cdrommount.HWDiscover.model.HWDiscoverModel;
import com.huawei.cdrommount.common.ipmitool.IPMITool;
import com.huawei.cdrommount.manage.LogStreamManage;
import java.security.SecureRandom;
import java.util.Arrays;

public class SetVmmKeyByIPMI {
    private String secretKey = "";
    private Long verifyId = null;
    private HWDiscoverModel snmpModel = null;
    private static final int OXFF = 255;

    public SetVmmKeyByIPMI(HWDiscoverModel snmpModel, Long id) {
        this.snmpModel = snmpModel;
        this.verifyId = id;
        this.secretKey = id == null ? SetVmmKeyByIPMI.createSecretUserKey() : String.valueOf(this.verifyId);
        LogStreamManage.log(this.secretKey + "\n");
    }

    private String createVMMSecretCodeKey() {
        SecureRandom random = new SecureRandom();
        StringBuffer sb = new StringBuffer();
        int randomNum = 0;
        for (int i = 1; i <= 36; ++i) {
            randomNum = random.nextInt(94) + 32;
            String hexStr = Integer.toHexString(randomNum);
            sb.append(hexStr);
        }
        return sb.toString();
    }

    public static String createSecretUserKey() {
        SecureRandom random = new SecureRandom();
        StringBuffer sb = new StringBuffer();
        int randomNum = 0;
        for (int i = 1; i <= 36; ++i) {
            randomNum = random.nextInt(94) + 32;
            String hexStr = Integer.toHexString(randomNum);
            sb.append("0x" + hexStr + " ");
        }
        return sb.toString();
    }

    public boolean execSNMPCommand() throws Exception {
        try {
            IPMITool ipmi = new IPMITool();
            String key = null;
            key = this.secretKey;
            String ipmiAdjure = null;
            String result = null;
            for (int i = 0; i < 4; ++i) {
                ipmiAdjure = i < 3 ? SetVmmKeyByIPMI.construcIpmiAdjureForKVMOrVMM("VMM", true, i, key) : SetVmmKeyByIPMI.construcIpmiAdjureForKVMOrVMM("VMM", false, i, key);
                this.snmpModel.setIPMIParameter("raw " + ipmiAdjure);
                LogStreamManage.log("raw " + ipmiAdjure + "\n");
                result = ipmi.GetExecResult(this.snmpModel);
                LogStreamManage.log("Exec ipmi command kvm inspect key result is " + result + "\n");
                if (null != result && result.contains("db 07 00")) continue;
                LogStreamManage.log("Exec ipmi command failed, kvm inspect key result is " + result + "\n");
                return false;
            }
            key = key.replaceAll(" ", "").replaceAll("0x", "");
            LogStreamManage.log("Exec ipmi command kvm inspect key.\n");
            return true;
        }
        catch (Exception e) {
            LogStreamManage.log("Exec ipmi command failure, exception is " + e + "\n");
            return false;
        }
    }

    private static String construcIpmiAdjureForKVMOrVMM(String type, boolean hasNext, int sequenceNo, String key) {
        StringBuilder sb = new StringBuilder();
        String baseCommond = "0x30 0x94 0xdb 0x07 0x00 0x21 0x06 ";
        sb.append(baseCommond);
        if (hasNext) {
            sb.append("0x01 ");
        } else {
            sb.append("0x00 ");
        }
        if (null != SetVmmKeyByIPMI.parseSequenceNoPartOne(sequenceNo)) {
            sb.append(SetVmmKeyByIPMI.parseSequenceNoPartOne(sequenceNo));
        }
        String[] keyArrays = key.split(" ");
        if (sequenceNo == 0) {
            if ("VMM".equals(type)) {
                sb.append("0x01 ");
            } else if ("KVM".equals(type)) {
                sb.append("0x00 ");
            }
            sb.append("0x24 ");
        }
        sb.append(SetVmmKeyByIPMI.parseSequenceNoPartTwo(sequenceNo, keyArrays));
        return sb.toString();
    }

    private static String parseSequenceNoPartOne(int sequenceNo) {
        switch (sequenceNo) {
            case 0: {
                return "0x00 0x10 ";
            }
            case 1: {
                return "0x10 0x10 ";
            }
            case 2: {
                return "0x20 0x10 ";
            }
            case 3: {
                return "0x30 0x08 ";
            }
        }
        return null;
    }

    private static String parseSequenceNoPartTwo(int sequenceNo, String[] keyArrays) {
        String str = null;
        switch (sequenceNo) {
            case 0: {
                return SetVmmKeyByIPMI.getKeyString(keyArrays, 0, 14);
            }
            case 1: {
                return SetVmmKeyByIPMI.getKeyString(keyArrays, 14, 30);
            }
            case 2: {
                str = SetVmmKeyByIPMI.getKeyString(keyArrays, 30, 36);
                str = str + "0 0 0 0 0 0 0 0 0 0";
                return str;
            }
            case 3: {
                str = "0 0 0 0 0 0 0 0";
                return str;
            }
        }
        return null;
    }

    private static String getKeyString(String[] keyArrays, int startIndex, int endIndex) {
        StringBuilder sb = new StringBuilder();
        String[] partKeyArrays = Arrays.copyOfRange(keyArrays, startIndex, endIndex);
        for (int i = 0; i < partKeyArrays.length; ++i) {
            sb.append(partKeyArrays[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static byte[] convertSecretKeyToBytes(String secretKey, int length) {
        String tmpHexstring = null;
        byte[] negotiatePass = new byte[length];
        for (int i = 0; i < length; ++i) {
            tmpHexstring = secretKey.substring(i * 2, i * 2 + 2);
            try {
                negotiatePass[i] = (byte)(Integer.parseInt(tmpHexstring, 16) & 0xFF);
                continue;
            }
            catch (NumberFormatException ex) {
                LogStreamManage.log("convertSecretKeyToBytes failed.\n");
            }
        }
        return negotiatePass;
    }

    public String getVmmKey() {
        return this.secretKey;
    }
}

