/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.huawei.vm.console.utils.ResourceUtil;
import com.kvm.Base;
import com.kvm.BladeThread;
import com.kvm.Client;
import com.kvm.ClientSocketCommunity;
import com.kvm.CopyFileToLocal;
import com.kvm.KVMException;
import com.kvm.KVMInterface;
import com.kvm.KVMUtil;
import com.kvm.LogManager;
import com.kvm.MoniterWindowsFocus;
import com.kvm.MouseDisplacementImpl;
import com.kvm.PackData;
import com.kvm.UnPackData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class KVMApplet
extends JApplet {
    private boolean kvmState = true;
    private KVMInterface kvmInterface = null;
    private static boolean isStart = false;
    private Thread timeHeart = null;
    private boolean conn = true;
    private static final String FREE_IP = "0.0.0.0";
    private final long i = Long.valueOf("4294967296").intValue();
    private static final int MastInt = Integer.MAX_VALUE;
    private static final int TIME_OUT = 60000;
    public String local = "ZH";
    public String strIP = "";
    public static String protocol = "TCP";
    public ClientSocketCommunity clientSocket = null;
    public KVMUtil kvmUtil = null;
    public Client client = null;
    public PackData packData = null;
    public UnPackData unPackData = null;
    public Base base = null;
    public boolean started = false;
    private Logger logger = LogManager.getInstance().getLogger(KVMApplet.class);

    @Override
    public void init() {
        String kvmencrypt;
        String secureKvm;
        try {
            String arch = System.getProperty("sun.arch.data.model");
            this.logger.info("java version digit = " + arch);
            if (arch.equals("64")) {
                ResourceUtil.CONFIG_VM_LIBARY = "com.huawei.vm.console.config.library.x64";
                Base.MOUSE_LIB = "KVMMouseDisPlace_x64";
            } else {
                ResourceUtil.CONFIG_VM_LIBARY = "com.huawei.vm.console.config.library";
                Base.MOUSE_LIB = "KVMMouseDisPlace";
            }
            CopyFileToLocal.cleanLib();
            if (!CopyFileToLocal.libarayPrepare()) {
                this.kvmState = false;
            }
        }
        catch (AccessControlException ae) {
            this.kvmState = false;
            this.logger.error("", ae);
        }
        this.base = new Base();
        this.kvmUtil = new KVMUtil();
        this.local = this.getParameter("local");
        if (this.local == null) {
            this.local = "EN";
        }
        Base.local = this.local;
        if (this.local.equalsIgnoreCase("ZH")) {
            this.kvmUtil.resourcePath = "com.kvm.resource.KVMResource_zh";
        }
        if (this.local.equalsIgnoreCase("EN")) {
            this.kvmUtil.resourcePath = "com.kvm.resource.Resource";
        }
        Base.securekvm = (secureKvm = this.getParameter("securekvm")) == null ? false : secureKvm.trim().equals(new String("1"));
        this.logger.info("securekvm:" + Base.securekvm);
        String secureVmm = this.getParameter("securevmm");
        Base.securevmm = secureVmm == null ? false : secureKvm.trim().equals(new String("1"));
        this.logger.debug("securevmm:" + secureVmm);
        String negotiatePass = this.getParameter("secretkey");
        String tmp_hexstring = null;
        if (negotiatePass != null && negotiatePass.length() >= 40) {
            this.logger.info("init Base.negotiatepass");
            Base.negotiatepass = new byte[16];
            for (int i = 0; i < 16; ++i) {
                tmp_hexstring = negotiatePass.substring(i * 2 + 8, i * 2 + 10);
                try {
                    Base.negotiatepass[i] = (byte)(Integer.parseInt(tmp_hexstring, 16) & 0xFF);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.logger.error("", ex);
                }
            }
            this.logger.info("init Base.negotiatepass finished");
        }
        Base.kvmencrypt = (kvmencrypt = this.getParameter("kvmencrypt")) == null ? false : kvmencrypt.trim().equals(new String("1"));
        String vmmencrypt = this.getParameter("vmmencrypt");
        Base.vmmencrypt = vmmencrypt == null ? false : vmmencrypt.trim().equals(new String("1"));
        this.logger.info("Base.vmmencrypt:" + Base.vmmencrypt + " Base.kvmencrypt:" + Base.kvmencrypt);
        String negotiateiv = this.getParameter("secretiv");
        if (negotiateiv != null && negotiateiv.length() >= 32) {
            Base.negotiateiv = new byte[16];
            for (int i = 0; i < 16; ++i) {
                tmp_hexstring = negotiateiv.substring(i * 2, i * 2 + 2);
                try {
                    Base.negotiateiv[i] = (byte)(Integer.parseInt(tmp_hexstring, 16) & 0xFF);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.logger.error("", ex);
                }
            }
            Base.negotiatesalt = new byte[16];
            System.arraycopy(Base.negotiateiv, 0, Base.negotiatesalt, 0, 16);
        }
        this.kvmUtil.setiWindosFocus(0);
        this.kvmUtil.setiRunMoniterWindows(0);
    }

    private void testInit() {
        Base.local = "ZH";
    }

    private void beforeStart() {
        while (this.clientSocket != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("", e);
            }
        }
        this.client = new Client();
        this.packData = new PackData();
        this.unPackData = new UnPackData();
        this.clientSocket = new ClientSocketCommunity();
        long typeData = this.getParameter("typeData") == null ? Long.parseLong("4294967297") : Long.parseLong(this.getParameter("typeData"));
        this.logger.info("typeData:" + typeData);
        Base.typeData = typeData;
        Object[] tDatas = new Object[]{Base.typeData, Base.typeData};
        this.logger.info("\r\n type data : %d | %x \r\n" + tDatas);
        this.kvmInterface = new KVMInterface(this.kvmUtil, this.client, this.packData, this.clientSocket, this.base);
        this.client.setKvmInterface(this.kvmInterface);
        this.clientSocket.setKvmInterface(this.kvmInterface);
        this.clientSocket.setUnPackData(this.unPackData);
        this.packData.setKvmInterface(this.kvmInterface);
        this.kvmUtil.setKvmInterface(this.kvmInterface);
        this.kvmUtil.setUnPack(this.unPackData);
        this.kvmUtil.setImageData(new byte[this.base.imageWidth * this.base.imageHeight]);
    }

    private boolean comInKVM() {
        String port;
        isStart = true;
        this.base.parameterIP = this.getParameter("IPA") != null ? this.getParameter("IPA").trim() : null;
        int n = this.base.parameterPort = this.getParameter("port") != null && !this.getParameter("port").toString().equals("") ? Integer.valueOf(this.getParameter("port").trim()) : 2198;
        if (this.kvmInterface.getBladeSize() > 1) {
            try {
                this.client.socket = KVMUtil.getProxySocket(this.base.parameterIP, 80, this.base.parameterIP, this.base.parameterPort);
                if (null != this.client.socket) {
                    Base.isProxy = true;
                }
            }
            catch (URISyntaxException e) {
                this.logger.error("Connect_lost_message_one:" + this.base.parameterIP, e);
                JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connection_failed"));
                return false;
            }
            catch (UnknownHostException e) {
                this.logger.error("Connect_lost_message_one:" + this.base.parameterIP, e);
                JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connection_failed"));
                return false;
            }
            catch (ConnectException e) {
                this.logger.error("Connect_lost_message_one:" + this.base.parameterIP, e);
                JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connect_lost_message_one") + ":" + this.base.parameterIP);
                return false;
            }
            catch (IOException e) {
                this.logger.error("Connection_failed:" + this.base.parameterIP, e);
                JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connection_failed"));
                return false;
            }
            if (Base.isProxy) {
                this.strIP = this.getParameter("IPA");
            } else if (this.socketTest(this.getParameter("IPA"), this.getParameter("port"))) {
                this.strIP = this.getParameter("IPA");
            } else if (this.socketTest(this.getParameter("IPB"), this.getParameter("port"))) {
                this.strIP = this.getParameter("IPB");
            }
        } else {
            String string = this.strIP = this.getParameter("IPA") == null ? this.getParameter("IPB") : this.getParameter("IPA");
        }
        if (this.strIP == null || this.strIP.equals("")) {
            this.logger.error("Connection_failed:" + this.base.parameterIP);
            JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connection_failed"));
            return false;
        }
        String codeKey = this.getParameter("verifyValue");
        if (codeKey == null) {
            codeKey = "0";
        }
        if (codeKey == null || this.getParameter("local") == null || this.getParameter("port") == null) {
            // empty if block
        }
        long tempLong = 0L;
        try {
            tempLong = Long.valueOf(codeKey);
        }
        catch (Exception e) {
            this.logger.error("parse codekey exception," + codeKey);
            return false;
        }
        if (tempLong > Integer.MAX_VALUE) {
            this.kvmInterface.codeKey = (int)(0L - (this.i - tempLong));
        } else {
            try {
                this.kvmInterface.codeKey = Integer.parseInt(codeKey);
            }
            catch (Exception e) {
                this.logger.error("parse codekey exception," + codeKey);
                return false;
            }
        }
        Base.initSessionIDAndKey(this.kvmInterface.codeKey);
        String mmCodeKey = this.getParameter("mmVerifyValue");
        if (null == mmCodeKey || "".equals(mmCodeKey)) {
            mmCodeKey = "0";
        } else {
            Base.vmmCodeKey = Integer.parseInt(mmCodeKey);
        }
        this.getBladeNames(this.kvmInterface);
        if (this.getParameter("bladeFlag") != null) {
            this.kvmInterface.setBladeFlag(this.getParameter("bladeFlag"));
        }
        if ((port = this.getParameter("port")) == null) {
            port = "2198";
        }
        Client.port = Integer.parseInt(port.trim());
        try {
            this.client.address = InetAddress.getByName(this.strIP);
            Base.vmmConnIP = this.strIP;
        }
        catch (UnknownHostException e1) {
            this.logger.error("strIP:" + this.strIP, e1);
            return false;
        }
        return true;
    }

    @Override
    public void start() {
        this.beforeStart();
        if (!this.comInKVM()) {
            this.logger.error("Connected kvm failed.");
            return;
        }
        if (this.kvmInterface.getBladeSize() == 1) {
            this.processRack();
        } else {
            this.processShelf();
        }
        super.start();
        this.setStarted(true);
        new Thread(new MoniterWindowsFocus(this.kvmInterface)).start();
    }

    private void startHeart() {
        this.timeHeart = new SMMHeartTimer();
        this.timeHeart.setName("SmmHeartThread");
        this.timeHeart.start();
    }

    private void processShelf() {
        try {
            if (!Base.isProxy) {
                this.logger.info("not proxy");
                this.logger.info("control ip::" + this.strIP + ":::CONTROL PORT::::" + Client.port);
                this.client.socket = new Socket(this.strIP, Client.port);
            }
            this.client.dout = new DataOutputStream(this.client.socket.getOutputStream());
            this.client.din = new BufferedInputStream(this.client.socket.getInputStream());
        }
        catch (IOException e) {
            this.logger.error("", e);
            JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connection_failed"));
            return;
        }
        if (this.strIP != null) {
            boolean isRight;
            block12: {
                block11: {
                    isRight = true;
                    this.clientSocket.setConn(true);
                    this.clientSocket.setName("receiveThread");
                    this.clientSocket.bladePresentInfo.clear();
                    this.clientSocket.start();
                    byte[] reqBladePresentInfo = this.packData.reqBladePresent();
                    try {
                        this.client.sentData(reqBladePresentInfo);
                    }
                    catch (KVMException ex) {
                        ex.printStackTrace();
                        if (!"IO_ERRCODE".equals(ex.getErrCode())) break block11;
                        JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("Network_interrupt_message"));
                    }
                }
                Timer timer = new Timer(1000, this.kvmUtil.taskPerformer);
                timer.start();
                do {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("", e);
                    }
                    if (!this.kvmUtil.isConn) continue;
                    timer.stop();
                    this.kvmUtil.times = 0;
                    break block12;
                } while (this.kvmUtil.times < 10);
                timer.stop();
                isRight = false;
                this.logger.info("no_right");
                JOptionPane.showMessageDialog(this, this.kvmUtil.getString("no_right"));
                this.kvmUtil.times = 0;
            }
            if (isRight) {
                this.kvmUtil.isConn = false;
                this.getContentPane().setLayout(new BorderLayout());
                this.startHeart();
                this.getContentPane().add((Component)this.kvmInterface, "Center");
                this.kvmUtil.setButtonEnable(false);
                this.kvmUtil.setBladeEnable();
            } else {
                this.clientSocket.setConn(false);
                this.clientSocket.bladePresentInfo.clear();
                this.clientSocket.stop();
            }
        }
    }

    private void processRack() {
        this.kvmUtil.isConn = false;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.kvmInterface, "Center");
        this.kvmUtil.setButtonEnable(false);
        if (this.kvmInterface.getBladeSize() == 1) {
            ActionEvent event = new ActionEvent(this.kvmInterface.toolbar, 1, "blade1");
            this.kvmInterface.toolbar.actionPerformed(event);
        }
    }

    private void getBladeNames(KVMInterface kvmInterface) {
        String bladeNames = this.getParameter("bladeNames");
        if (bladeNames != null) {
            kvmInterface.setBladeTip(bladeNames.split("#"));
        }
        this.logger.info("kvmInterface::" + bladeNames);
        kvmInterface.setBladeNames(bladeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean socketTest(String ip, String portStr) {
        boolean result = false;
        if (null != ip && !"".equals(ip) && null != portStr && !"".equals(portStr)) {
            try {
                int port = Integer.valueOf(portStr);
                Socket socket = null;
                try {
                    socket = new Socket(ip, port);
                    result = true;
                }
                catch (ConnectException e) {
                    this.logger.error("Connect_lost_message_one,ip:" + ip + " portStr:" + portStr, e);
                    JOptionPane.showMessageDialog(this, this.kvmUtil.getString("Connect_lost_message_one") + " " + ip);
                    result = false;
                }
                catch (Exception e) {
                    this.logger.error("", e);
                    result = false;
                }
                finally {
                    if (null != socket) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            this.logger.error("", e);
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                this.logger.error("", nfe);
            }
        }
        return result;
    }

    @Override
    public void stop() {
        ArrayList keyList = new ArrayList();
        if (this.kvmInterface != null) {
            this.kvmInterface.tabbedpane.getModel().removeChangeListener(this.kvmUtil.changeListener);
            Iterator iter = this.base.threadGroup.keySet().iterator();
            if (this.kvmInterface != null) {
                this.kvmInterface.tabbedpane.getModel().removeChangeListener(this.kvmUtil.changeListener);
            }
            while (iter.hasNext()) {
                keyList.add(iter.next());
            }
            int num = this.base.threadGroup.size();
            for (int i = 0; i < num; ++i) {
                int bladeNO = Integer.parseInt((String)keyList.get(i));
                ((BladeThread)this.base.threadGroup.get((Object)String.valueOf((int)bladeNO))).bladeCommu.setAutoFlag(false);
                this.kvmUtil.disconnectBlade(bladeNO);
            }
            keyList.clear();
            keyList = null;
            Object var2_2 = null;
        }
        super.stop();
        this.setStarted(false);
    }

    private void recyContainer() {
        isStart = false;
        this.kvmUtil.setUnPack(null);
        this.kvmUtil.imageData = null;
        this.kvmUtil.bladePreInfo = null;
        this.kvmUtil = null;
        if (this.client != null) {
            this.client.data = null;
            this.client.socket = null;
            this.client.socketUDP = null;
            this.client.packet = null;
            this.client = null;
        }
        this.packData = null;
        this.unPackData = null;
        this.base = null;
        if (this.kvmInterface != null) {
            if (this.kvmInterface.fullScreen != null) {
                this.kvmInterface.fullScreen.imageParentPane.removeAll();
                this.kvmInterface.fullScreen.imageParentPane.setLayout(null);
                this.kvmInterface.fullScreen.imageParentPane = null;
                this.kvmInterface.fullScreen.imageParentScrollPane = null;
                this.kvmInterface.fullScreen.toolBar.removeAll();
                this.kvmInterface.fullScreen.toolBar.fullToolBarRelease();
                this.kvmInterface.fullScreen.toolBarFrame.getContentPane().removeAll();
                this.kvmInterface.fullScreen.toolBar = null;
                this.kvmInterface.fullScreen.toolBarFrame = null;
                this.kvmInterface.fullScreen.getContentPane().removeAll();
                this.kvmInterface.fullScreen.dispose();
                this.kvmInterface.fullScreen = null;
            }
            this.kvmInterface.statusBar.dataStaTimer.cancel();
            this.kvmInterface.statusBar = null;
            this.kvmInterface.tabbedpane = null;
            this.kvmInterface.toolbar.releaseKVMToolBar();
            this.kvmInterface.toolbar.removeAll();
            this.kvmInterface.toolbar = null;
            this.kvmInterface.removeAll();
            this.getContentPane().removeAll();
            this.kvmInterface = null;
        }
    }

    @Override
    public void destroy() {
        block8: {
            this.kvmUtil.setBundle(null);
            if (this.client != null && this.client.socket != null) {
                try {
                    this.client.sentData(this.packData.deleteUser());
                }
                catch (KVMException ex) {
                    if (!"IO_ERRCODE".equals(ex.getErrCode())) break block8;
                    this.logger.error("IO Exception : ", ex);
                }
            }
        }
        if (this.timeHeart != null) {
            this.conn = false;
        }
        if (this.clientSocket != null && this.clientSocket.isAlive()) {
            this.clientSocket.stop();
            this.clientSocket.bladePresentInfo = null;
            this.clientSocket.bladeStateInfo = null;
            this.clientSocket.keyState = null;
            this.clientSocket.unPack = null;
            this.clientSocket = null;
            this.base.threadGroup = null;
        }
        if (this.base.getHookNum() != 0) {
            if (MouseDisplacementImpl.removeHook(this.base.getHookNum()) == 0) {
                this.logger.error("removeHook fail");
            } else {
                this.base.setHookNum(0);
            }
        }
        this.recyContainer();
        CopyFileToLocal.cleanLib();
        System.gc();
        super.destroy();
    }

    public boolean getStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public static boolean isStart() {
        return isStart;
    }

    public static void setStart(boolean isStart) {
        KVMApplet.isStart = isStart;
    }

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    class SMMHeartTimer
    extends Thread {
        SMMHeartTimer() {
        }

        @Override
        public void run() {
            KVMApplet.this.conn = true;
            while (KVMApplet.this.conn) {
                try {
                    Thread.sleep(2000L);
                    if (KVMApplet.this.client == null || KVMApplet.this.packData == null) continue;
                    KVMApplet.this.client.sentData(KVMApplet.this.packData.heartBeat());
                }
                catch (KVMException ex) {
                    if (!"IO_ERRCODE".equals(ex.getErrCode())) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

