#!/bin/bash

searchpkg() {
	local tools="
	H2OUVE
	H2OSDE
	H2OFFT
	H2ORTE
	H2OSDE
	"
	if [ ! -z "$1" -a -f "$1" ]; then
		toolpkg="$1"
		return 0
	fi
	for tool in $tools
	do
		toolpkg=$(ls -1 $PWD/Insyde${tool}*.rpm 2>/dev/null)
		if [ -z "$toolpkg" ]; then
			continue
		fi
		count=$(echo "$toolpkg" | wc -l)
		if [ "$count" -eq "1" ]; then
			break
		elif [ "$count" -ge "2" ]; then
			echo "$tool tool has more than two rpm package"
			unset toolpkg
		fi
	done
	if [ -z "$toolpkg" ]; then
		echo "not rpm tool package found"
	fi
}

chkplatform() {
	str=$(cat /etc/*release*)
	if [[ "$str" =~ .*Redhat.* ]] || [[ "$str" =~ .*Red\ Hat.* ]] || [[ "$str" =~ .*redhat.* ]]; then
		platform=redhat
	elif [[ "$str" =~ .*Ubuntu.* ]]; then
		platform=ubuntu
	else
		platform=unknown
	fi
}

redhat() {
	pkgs="
	kernel-devel
	gcc
	make
	elfutils-libelf-devel
	"
	sudo yum $type -y $pkgs &&\
	sudo yum $type -y $@
}

ubuntu() {
	echo -n
}

init() {
	type=install
	unset args
}

parseargs() {
	local i=0
	while true
	do
		case $1 in
			-d)
				type=remove
				;;
			-h|--help)
				cat << EOF
${0##*/} <rpm>
EOF
				exit 0
				;;
			*)
				args[$i]="$1"
				;;
		esac
		shift
		[ ! -z "${args[$i]}" ] && let i++
		[ -z "$1" ] && break
	done
}

init
parseargs "$@"
chkplatform
searchpkg "${args[0]}"

if [ -z "$toolpkg" ]; then
	exit
fi

case $platform in
	ubuntu|redhat)
		$platform "$toolpkg"
		;;
	unknown|*)
		echo "Platform not supported"
		;;
esac
